/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.confluent.kafka.schemaregistry.json.jackson.JsonOrgModule;
import java.util.TreeMap;

public class Jackson {
    private Jackson() {
    }

    public static ObjectMapper newObjectMapper() {
        return Jackson.newObjectMapper(false);
    }

    public static ObjectMapper newObjectMapper(boolean sorted) {
        ObjectMapper mapper = new ObjectMapper();
        return Jackson.configure(mapper, sorted);
    }

    public static ObjectMapper newObjectMapper(JsonFactory jsonFactory) {
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        return Jackson.configure(mapper, false);
    }

    private static ObjectMapper configure(ObjectMapper mapper, boolean sorted) {
        mapper.registerModule((Module)new GuavaModule());
        mapper.registerModule((Module)new JodaModule());
        mapper.registerModule((Module)new ParameterNamesModule());
        mapper.registerModule((Module)new Jdk8Module());
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new JsonOrgModule());
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setNodeFactory((JsonNodeFactory)(sorted ? new SortingNodeFactory(true) : JsonNodeFactory.withExactBigDecimals((boolean)true)));
        return mapper;
    }

    static class SortingNodeFactory
    extends JsonNodeFactory {
        public SortingNodeFactory(boolean bigDecimalExact) {
            super(bigDecimalExact);
        }

        public ObjectNode objectNode() {
            return new ObjectNode((JsonNodeFactory)this, new TreeMap());
        }
    }
}

