/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.diff;

import io.confluent.kafka.schemaregistry.json.diff.Context;
import io.confluent.kafka.schemaregistry.json.diff.Difference;
import io.confluent.kafka.schemaregistry.json.diff.SchemaDiff;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.Schema;

public class ArraySchemaDiff {
    static void compare(Context ctx, ArraySchema original, ArraySchema update) {
        ArraySchemaDiff.compareItemSchemaObject(ctx, original, update);
        ArraySchemaDiff.compareItemSchemaArray(ctx, original, update);
        ArraySchemaDiff.compareAdditionalItems(ctx, original, update);
        ArraySchemaDiff.compareAttributes(ctx, original, update);
    }

    private static void compareAttributes(Context ctx, ArraySchema original, ArraySchema update) {
        if (!Objects.equals(original.getMaxItems(), update.getMaxItems())) {
            if (original.getMaxItems() == null && update.getMaxItems() != null) {
                ctx.addDifference("maxItems", Difference.Type.MAX_ITEMS_ADDED);
            } else if (original.getMaxItems() != null && update.getMaxItems() == null) {
                ctx.addDifference("maxItems", Difference.Type.MAX_ITEMS_REMOVED);
            } else if (original.getMaxItems() < update.getMaxItems()) {
                ctx.addDifference("maxItems", Difference.Type.MAX_ITEMS_INCREASED);
            } else if (original.getMaxItems() > update.getMaxItems()) {
                ctx.addDifference("maxItems", Difference.Type.MAX_ITEMS_DECREASED);
            }
        }
        if (!Objects.equals(original.getMinItems(), update.getMinItems())) {
            if (original.getMinItems() == null && update.getMinItems() != null) {
                ctx.addDifference("minItems", Difference.Type.MIN_ITEMS_ADDED);
            } else if (original.getMinItems() != null && update.getMinItems() == null) {
                ctx.addDifference("minItems", Difference.Type.MIN_ITEMS_REMOVED);
            } else if (original.getMinItems() < update.getMinItems()) {
                ctx.addDifference("minItems", Difference.Type.MIN_ITEMS_INCREASED);
            } else if (original.getMinItems() > update.getMinItems()) {
                ctx.addDifference("minItems", Difference.Type.MIN_ITEMS_DECREASED);
            }
        }
        if (original.needsUniqueItems() != update.needsUniqueItems()) {
            if (original.needsUniqueItems()) {
                ctx.addDifference("uniqueItems", Difference.Type.UNIQUE_ITEMS_REMOVED);
            } else {
                ctx.addDifference("uniqueItems", Difference.Type.UNIQUE_ITEMS_ADDED);
            }
        }
    }

    private static void compareAdditionalItems(Context ctx, ArraySchema original, ArraySchema update) {
        try (Context.PathScope pathScope = ctx.enterPath("additionalItems");){
            if (original.permitsAdditionalItems() != update.permitsAdditionalItems()) {
                if (original.permitsAdditionalItems()) {
                    ctx.addDifference(Difference.Type.ADDITIONAL_ITEMS_REMOVED);
                } else {
                    ctx.addDifference(Difference.Type.ADDITIONAL_ITEMS_ADDED);
                }
            } else if (original.getSchemaOfAdditionalItems() == null && update.getSchemaOfAdditionalItems() != null) {
                ctx.addDifference(Difference.Type.ADDITIONAL_ITEMS_NARROWED);
            } else if (update.getSchemaOfAdditionalItems() == null && original.getSchemaOfAdditionalItems() != null) {
                ctx.addDifference(Difference.Type.ADDITIONAL_ITEMS_EXTENDED);
            } else {
                SchemaDiff.compare(ctx, original.getSchemaOfAdditionalItems(), update.getSchemaOfAdditionalItems());
            }
        }
    }

    private static void compareItemSchemaArray(Context ctx, ArraySchema original, ArraySchema update) {
        Context subctx;
        Schema schemaFromPartial;
        Throwable throwable;
        Context.PathScope pathScope;
        int index;
        List updateSchemas;
        List originalSchemas = original.getItemSchemas();
        if (originalSchemas == null) {
            originalSchemas = Collections.emptyList();
        }
        if ((updateSchemas = update.getItemSchemas()) == null) {
            updateSchemas = Collections.emptyList();
        }
        int originalSize = originalSchemas.size();
        int updateSize = updateSchemas.size();
        Iterator originalIterator = originalSchemas.iterator();
        Iterator updateIterator = updateSchemas.iterator();
        for (index = 0; originalIterator.hasNext() && index < Math.min(originalSize, updateSize); ++index) {
            pathScope = ctx.enterPath("items/" + index);
            throwable = null;
            try {
                SchemaDiff.compare(ctx, (Schema)originalIterator.next(), (Schema)updateIterator.next());
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pathScope != null) {
                    if (throwable != null) {
                        try {
                            pathScope.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        pathScope.close();
                    }
                }
            }
        }
        while (originalIterator.hasNext()) {
            pathScope = ctx.enterPath("items/" + index);
            throwable = null;
            try {
                Schema originalSchema = (Schema)originalIterator.next();
                if (ArraySchemaDiff.isOpenContentModel(update)) {
                    ctx.addDifference(Difference.Type.ITEM_REMOVED_FROM_OPEN_CONTENT_MODEL);
                } else {
                    schemaFromPartial = ArraySchemaDiff.schemaFromPartiallyOpenContentModel(update);
                    if (schemaFromPartial != null) {
                        subctx = ctx.getSubcontext();
                        SchemaDiff.compare(subctx, originalSchema, schemaFromPartial);
                        ctx.addDifferences(subctx.getDifferences());
                        if (subctx.isCompatible()) {
                            ctx.addDifference(Difference.Type.ITEM_REMOVED_IS_COVERED_BY_PARTIALLY_OPEN_CONTENT_MODEL);
                        } else {
                            ctx.addDifference(Difference.Type.ITEM_REMOVED_NOT_COVERED_BY_PARTIALLY_OPEN_CONTENT_MODEL);
                        }
                    } else if (originalSchema instanceof FalseSchema) {
                        ctx.addDifference(Difference.Type.ITEM_WITH_FALSE_REMOVED_FROM_CLOSED_CONTENT_MODEL);
                    } else {
                        ctx.addDifference(Difference.Type.ITEM_REMOVED_FROM_CLOSED_CONTENT_MODEL);
                    }
                }
            }
            catch (Throwable originalSchema) {
                throwable = originalSchema;
                throw originalSchema;
            }
            finally {
                if (pathScope != null) {
                    if (throwable != null) {
                        try {
                            pathScope.close();
                        }
                        catch (Throwable originalSchema) {
                            throwable.addSuppressed(originalSchema);
                        }
                    } else {
                        pathScope.close();
                    }
                }
            }
            ++index;
        }
        while (updateIterator.hasNext()) {
            pathScope = ctx.enterPath("items/" + index);
            throwable = null;
            try {
                Schema updateSchema = (Schema)updateIterator.next();
                if (ArraySchemaDiff.isOpenContentModel(original)) {
                    if (updateSchema instanceof EmptySchema) {
                        ctx.addDifference(Difference.Type.ITEM_WITH_EMPTY_SCHEMA_ADDED_TO_OPEN_CONTENT_MODEL);
                    } else {
                        ctx.addDifference(Difference.Type.ITEM_ADDED_TO_OPEN_CONTENT_MODEL);
                    }
                } else {
                    schemaFromPartial = ArraySchemaDiff.schemaFromPartiallyOpenContentModel(original);
                    if (schemaFromPartial != null) {
                        subctx = ctx.getSubcontext();
                        SchemaDiff.compare(subctx, schemaFromPartial, updateSchema);
                        ctx.addDifferences(subctx.getDifferences());
                        if (subctx.isCompatible()) {
                            ctx.addDifference(Difference.Type.ITEM_ADDED_IS_COVERED_BY_PARTIALLY_OPEN_CONTENT_MODEL);
                        } else {
                            ctx.addDifference(Difference.Type.ITEM_ADDED_NOT_COVERED_BY_PARTIALLY_OPEN_CONTENT_MODEL);
                        }
                    } else {
                        ctx.addDifference(Difference.Type.ITEM_ADDED_TO_CLOSED_CONTENT_MODEL);
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (pathScope != null) {
                    if (throwable != null) {
                        try {
                            pathScope.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        pathScope.close();
                    }
                }
            }
            ++index;
        }
    }

    private static void compareItemSchemaObject(Context ctx, ArraySchema original, ArraySchema update) {
        try (Context.PathScope pathScope = ctx.enterPath("items");){
            SchemaDiff.compare(ctx, original.getAllItemSchema(), update.getAllItemSchema());
        }
    }

    private static boolean isOpenContentModel(ArraySchema schema) {
        return schema.getSchemaOfAdditionalItems() == null && schema.permitsAdditionalItems();
    }

    private static Schema schemaFromPartiallyOpenContentModel(ArraySchema schema) {
        return schema.getSchemaOfAdditionalItems();
    }
}

