/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.util.KeystoreUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PfxOptions;
import java.util.Map;
import java.util.Optional;

public final class VertxSslOptionsFactory {
    private static final String SSL_STORE_TYPE_JKS = "JKS";

    private VertxSslOptionsFactory() {
    }

    private static String getTrustStoreLocation(Map<String, String> props) {
        return props.get("ssl.truststore.location");
    }

    private static String getTrustStorePassword(Map<String, String> props) {
        return props.get("ssl.truststore.password");
    }

    private static String getKeyStoreLocation(Map<String, String> props) {
        return props.get("ssl.keystore.location");
    }

    private static String getKeyStorePassword(Map<String, String> props) {
        return props.get("ssl.keystore.password");
    }

    private static String getKeyPassword(Map<String, String> props) {
        return props.get("ssl.key.password");
    }

    private static JksOptions buildJksOptions(String path, String password) {
        return new JksOptions().setPath(path).setPassword(Strings.nullToEmpty((String)password));
    }

    private static JksOptions buildJksOptions(Buffer buffer, String password) {
        return new JksOptions().setValue(buffer).setPassword(Strings.nullToEmpty((String)password));
    }

    private static Buffer loadJksKeyStore(String path, String keyStorePassword, String keyPassword, String alias) {
        return KeystoreUtil.getKeyStore(SSL_STORE_TYPE_JKS, path, Optional.ofNullable(Strings.emptyToNull((String)keyStorePassword)), Optional.ofNullable(Strings.emptyToNull((String)keyPassword)), alias);
    }

    private static PfxOptions buildPfxOptions(String path, String password) {
        return new PfxOptions().setPath(path).setPassword(Strings.nullToEmpty((String)password));
    }

    public static JksOptions getJksTrustStoreOptions(String path, String password) {
        return VertxSslOptionsFactory.buildJksOptions(path, password);
    }

    public static Optional<JksOptions> getJksTrustStoreOptions(Map<String, String> props) {
        String location = VertxSslOptionsFactory.getTrustStoreLocation(props);
        String password = VertxSslOptionsFactory.getTrustStorePassword(props);
        if (!Strings.isNullOrEmpty((String)location)) {
            return Optional.of(VertxSslOptionsFactory.buildJksOptions(location, password));
        }
        return Optional.empty();
    }

    public static Optional<PfxOptions> getPfxTrustStoreOptions(Map<String, String> props) {
        String location = VertxSslOptionsFactory.getTrustStoreLocation(props);
        String password = VertxSslOptionsFactory.getTrustStorePassword(props);
        if (!Strings.isNullOrEmpty((String)location)) {
            return Optional.of(VertxSslOptionsFactory.buildPfxOptions(location, password));
        }
        return Optional.empty();
    }

    public static Optional<JksOptions> buildJksKeyStoreOptions(Map<String, String> props, Optional<String> alias) {
        String location = VertxSslOptionsFactory.getKeyStoreLocation(props);
        String keyStorePassword = VertxSslOptionsFactory.getKeyStorePassword(props);
        String keyPassword = VertxSslOptionsFactory.getKeyPassword(props);
        if (!Strings.isNullOrEmpty((String)location)) {
            JksOptions jksOptions = alias.isPresent() && !alias.get().isEmpty() ? VertxSslOptionsFactory.buildJksOptions(VertxSslOptionsFactory.loadJksKeyStore(location, keyStorePassword, keyPassword, alias.get()), keyStorePassword) : VertxSslOptionsFactory.buildJksOptions(location, keyStorePassword);
            return Optional.of(jksOptions);
        }
        return Optional.empty();
    }

    public static JksOptions buildJksKeyStoreOptions(String path, String password, Optional<String> keyPassword, Optional<String> alias) {
        return VertxSslOptionsFactory.buildJksKeyStoreOptions((Map<String, String>)ImmutableMap.of((Object)"ssl.keystore.location", (Object)path, (Object)"ssl.keystore.password", (Object)password, (Object)"ssl.key.password", (Object)keyPassword.orElse("")), alias).get();
    }

    public static Optional<PfxOptions> getPfxKeyStoreOptions(Map<String, String> props) {
        String location = VertxSslOptionsFactory.getKeyStoreLocation(props);
        String password = VertxSslOptionsFactory.getKeyStorePassword(props);
        if (!Strings.isNullOrEmpty((String)location)) {
            return Optional.of(VertxSslOptionsFactory.buildPfxOptions(location, password));
        }
        return Optional.empty();
    }
}

