/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.PushOffsetRange;
import java.util.Objects;
import java.util.Optional;

public class RowMetadata {
    private final Optional<PushOffsetRange> pushOffsetsRange;
    private final Optional<ConsistencyOffsetVector> consistencyOffsetVector;

    public RowMetadata(Optional<PushOffsetRange> pushOffsetsRange, Optional<ConsistencyOffsetVector> consistencyOffsetVector) {
        this.pushOffsetsRange = pushOffsetsRange;
        this.consistencyOffsetVector = consistencyOffsetVector;
    }

    public Optional<PushOffsetRange> getPushOffsetsRange() {
        return this.pushOffsetsRange;
    }

    public Optional<ConsistencyOffsetVector> getConsistencyOffsetVector() {
        return this.consistencyOffsetVector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowMetadata rowMetadata = (RowMetadata)o;
        return Objects.equals(this.pushOffsetsRange, rowMetadata.pushOffsetsRange) && Objects.equals(this.consistencyOffsetVector, rowMetadata.consistencyOffsetVector);
    }

    public int hashCode() {
        return Objects.hash(this.pushOffsetsRange, this.consistencyOffsetVector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RowMetadata{");
        sb.append("pushOffsetsRange=").append(this.pushOffsetsRange);
        sb.append(", consistencyOffsetVector=").append(this.consistencyOffsetVector);
        sb.append('}');
        return sb.toString();
    }
}

