/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import org.apache.kafka.streams.KafkaStreams;

public final class KsqlConstants {
    public static final String CONFLUENT_AUTHOR = "Confluent";
    public static final String STREAMS_CHANGELOG_TOPIC_SUFFIX = "-changelog";
    public static final String STREAMS_REPARTITION_TOPIC_SUFFIX = "-repartition";
    public static final String STREAMS_JOIN_REGISTRATION_TOPIC_PATTERN = ".+-KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-\\d+-topic";
    public static final String STREAMS_JOIN_RESPONSE_TOPIC_PATTERN = ".+-KTABLE-FK-JOIN-SUBSCRIPTION-RESPONSE-\\d+-topic";
    private static final String SCHEMA_REGISTRY_KEY_SUFFIX = "-key";
    private static final String SCHEMA_REGISTRY_VALUE_SUFFIX = "-value";
    public static final long defaultSinkWindowChangeLogAdditionalRetention = 1000000L;
    public static final long defaultCommitIntervalMsConfig = 2000L;
    public static final long defaultCacheMaxBytesBufferingConfig = 10000000L;
    public static final int defaultNumberOfStreamsThreads = 4;
    public static final String LEGACY_RUN_SCRIPT_STATEMENTS_CONTENT = "ksql.run.script.statements";
    public static final String DOT = ".";
    public static final String STRUCT_FIELD_REF = "->";
    public static final String LAMBDA_FUNCTION = "=>";
    public static final String KSQL_SERVICE_ID_METRICS_TAG = "ksql_service_id";
    public static final String KSQL_QUERY_SOURCE_TAG = "query_source";
    public static final String KSQL_QUERY_PLAN_TYPE_TAG = "query_plan_type";
    public static final String KSQL_QUERY_ROUTING_TYPE_TAG = "query_routing_type";
    public static final String TIME_PATTERN = "HH:mm:ss.SSS";
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";

    private KsqlConstants() {
    }

    public static KsqlQueryStatus fromStreamsState(KafkaStreams.State state) {
        return state == KafkaStreams.State.ERROR ? KsqlQueryStatus.ERROR : KsqlQueryStatus.RUNNING;
    }

    public static String getSRSubject(String topicName, boolean isKey) {
        String suffix = isKey ? SCHEMA_REGISTRY_KEY_SUFFIX : SCHEMA_REGISTRY_VALUE_SUFFIX;
        return topicName + suffix;
    }

    public static enum RoutingNodeType {
        SOURCE_NODE,
        REMOTE_NODE;

    }

    public static enum QuerySourceType {
        NON_WINDOWED,
        WINDOWED,
        NON_WINDOWED_STREAM,
        WINDOWED_STREAM;

    }

    public static enum KsqlQueryStatus {
        RUNNING,
        ERROR,
        UNRESPONSIVE;

    }

    public static enum PersistentQueryType {
        CREATE_SOURCE,
        CREATE_AS,
        INSERT;

    }

    public static enum KsqlQueryType {
        PERSISTENT,
        PUSH,
        PULL;

    }
}

