/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.OffsetVector;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConsistencyOffsetVector
implements OffsetVector {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private int version;
    private Map<String, Map<Integer, Long>> offsetVector;
    private ReadWriteLock rwLock;

    public ConsistencyOffsetVector() {
        this.version = 0;
        this.offsetVector = new HashMap<String, Map<Integer, Long>>();
        this.rwLock = new ReentrantReadWriteLock();
    }

    @JsonCreator
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ConsistencyOffsetVector(@JsonProperty(value="version", required=true) int version, @JsonProperty(value="offsetVector", required=true) Map<String, Map<Integer, Long>> offsetVector) {
        this.version = version;
        this.offsetVector = offsetVector;
        this.rwLock = new ReentrantReadWriteLock();
    }

    public int getVersion() {
        return this.version;
    }

    public ImmutableMap<String, Map<Integer, Long>> getOffsetVector() {
        return ImmutableMap.copyOf(this.offsetVector);
    }

    public void addTopicOffsets(String topicID, Map<Integer, Long> offsets) {
        this.offsetVector.putIfAbsent(topicID, new HashMap());
        this.offsetVector.get(topicID).putAll(offsets);
    }

    public void setVersion(int newVersion) {
        this.version = newVersion;
    }

    @JsonAnySetter
    public void setOffsetVector(Map<String, Map<Integer, Long>> topicOffsets) {
        this.offsetVector.putAll(topicOffsets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String topic, int partition, long offset) {
        try {
            Map<Object, Object> partitionOffsets;
            this.rwLock.writeLock().lock();
            if (!this.offsetVector.containsKey(topic)) {
                partitionOffsets = new HashMap();
                this.offsetVector.put(topic, partitionOffsets);
            }
            if ((partitionOffsets = this.offsetVector.get(topic)).containsKey(partition)) {
                long oldOffset = (Long)partitionOffsets.get(partition);
                partitionOffsets.put(partition, Math.max(oldOffset, offset));
            } else {
                partitionOffsets.put(partition, offset);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(OffsetVector other) {
        if (this.getClass() != other.getClass()) {
            throw new KsqlException("Offset vector types don't match");
        }
        ConsistencyOffsetVector otherCV = (ConsistencyOffsetVector)other;
        try {
            this.rwLock.writeLock().lock();
            for (Map.Entry<String, Map<Integer, Long>> topicEntry : otherCV.offsetVector.entrySet()) {
                Map<Integer, Long> partitionOffsets;
                String topic = topicEntry.getKey();
                if (this.offsetVector.containsKey(topic)) {
                    partitionOffsets = this.offsetVector.get(topic);
                    Map<Integer, Long> otherPartitionOffsets = otherCV.offsetVector.get(topic);
                    for (Map.Entry<Integer, Long> p : otherPartitionOffsets.entrySet()) {
                        if (partitionOffsets.containsKey(p.getKey())) {
                            long offset = partitionOffsets.get(p.getKey());
                            partitionOffsets.put(p.getKey(), Math.max(p.getValue(), offset));
                            continue;
                        }
                        partitionOffsets.put(p.getKey(), p.getValue());
                    }
                    continue;
                }
                partitionOffsets = new HashMap<Integer, Long>(topicEntry.getValue());
                this.offsetVector.put(topic, partitionOffsets);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dominates(OffsetVector other) {
        if (this.getClass() != other.getClass()) {
            throw new KsqlException("Offset vector types don't match");
        }
        ConsistencyOffsetVector otherCV = (ConsistencyOffsetVector)other;
        try {
            this.rwLock.readLock().lock();
            for (Map.Entry<String, Map<Integer, Long>> topicEntry : this.offsetVector.entrySet()) {
                String topic = topicEntry.getKey();
                if (!otherCV.offsetVector.containsKey(topic)) continue;
                Map<Integer, Long> partitionOffsets = this.offsetVector.get(topic);
                Map<Integer, Long> otherPartitionOffsets = otherCV.offsetVector.get(topic);
                for (Map.Entry<Integer, Long> p : partitionOffsets.entrySet()) {
                    long otherOffset;
                    long offset;
                    if (!otherPartitionOffsets.containsKey(p.getKey()) || (offset = partitionOffsets.get(p.getKey()).longValue()) >= (otherOffset = otherPartitionOffsets.get(p.getKey()).longValue())) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public boolean lessThanOrEqualTo(OffsetVector other) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    @JsonIgnore
    public List<Long> getDenseRepresentation() {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public String serialize() {
        try {
            byte[] bytes = OBJECT_MAPPER.writeValueAsBytes((Object)this);
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new KsqlException("Couldn't encode consistency token", e);
        }
    }

    public static ConsistencyOffsetVector deserialize(String token) {
        try {
            byte[] bytes = Base64.getDecoder().decode(token);
            return (ConsistencyOffsetVector)OBJECT_MAPPER.readValue(bytes, ConsistencyOffsetVector.class);
        }
        catch (Exception e) {
            throw new KsqlException("Couldn't decode consistency token", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsistencyOffsetVector that = (ConsistencyOffsetVector)o;
        return this.dominates(that) && that.dominates(this);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.offsetVector, this.rwLock);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConsistencyOffsetVector{");
        sb.append("version=").append(this.version);
        sb.append(", offsetVector=").append(this.offsetVector);
        sb.append(", rwLock=").append(this.rwLock);
        sb.append('}');
        return sb.toString();
    }

    public static boolean isConsistencyVectorEnabled(KsqlConfig ksqlConfig, Map<String, Object> overrides) {
        if (overrides.containsKey("ksql.query.pull.consistency.token.enabled")) {
            return Boolean.TRUE.equals(overrides.get("ksql.query.pull.consistency.token.enabled"));
        }
        return ksqlConfig.getBoolean("ksql.query.pull.consistency.token.enabled");
    }

    public static boolean isConsistencyVectorEnabled(Map<String, Object> requestProperties) {
        Object consistencyEnabled = requestProperties.get("ksql.query.pull.consistency.token.enabled");
        if (consistencyEnabled instanceof Boolean) {
            return (Boolean)consistencyEnabled;
        }
        return false;
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
    }
}

