/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.util.KsqlException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.xml.bind.DatatypeConverter;

public final class BytesUtils {
    private static final Map<Encoding, Function<byte[], String>> ENCODERS = ImmutableMap.of((Object)((Object)Encoding.HEX), v -> BytesUtils.hexEncoding(v), (Object)((Object)Encoding.UTF8), v -> BytesUtils.utf8Encoding(v), (Object)((Object)Encoding.ASCII), v -> BytesUtils.asciiEncoding(v), (Object)((Object)Encoding.BASE64), v -> BytesUtils.base64Encoding(v));
    private static final Map<Encoding, Function<String, byte[]>> DECODERS = ImmutableMap.of((Object)((Object)Encoding.HEX), v -> BytesUtils.hexDecoding(v), (Object)((Object)Encoding.UTF8), v -> BytesUtils.utf8Decoding(v), (Object)((Object)Encoding.ASCII), v -> BytesUtils.asciiDecoding(v), (Object)((Object)Encoding.BASE64), v -> BytesUtils.base64Decoding(v));

    private BytesUtils() {
    }

    public static ByteOrder byteOrderType(String byteOrderStr) {
        if (byteOrderStr != null && byteOrderStr.equalsIgnoreCase(ByteOrder.BIG_ENDIAN.toString())) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (byteOrderStr != null && byteOrderStr.equalsIgnoreCase(ByteOrder.LITTLE_ENDIAN.toString())) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw new KsqlException(String.format("Byte order must be BIG_ENDIAN or LITTLE_ENDIAN. Unknown byte order '%s'.", byteOrderStr));
    }

    public static String encode(byte[] value, Encoding encoding) {
        Function<byte[], String> encoder = ENCODERS.get((Object)encoding);
        if (encoder == null) {
            throw new IllegalStateException(String.format("Unsupported encoding type '%s'. ", new Object[]{encoding}));
        }
        return encoder.apply(value);
    }

    public static byte[] decode(String value, Encoding encoding) {
        Function<String, byte[]> decoder = DECODERS.get((Object)encoding);
        if (decoder == null) {
            throw new IllegalStateException(String.format("Unsupported encoding type '%s'. ", new Object[]{encoding}));
        }
        return decoder.apply(value);
    }

    public static byte[] getByteArray(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (!buffer.hasArray()) {
            buffer.clear();
            byte[] internalByteArray = new byte[buffer.capacity()];
            buffer.get(internalByteArray);
            return internalByteArray;
        }
        return buffer.array();
    }

    public static byte[] getByteArray(ByteBuffer buffer, int start, int end) {
        return Arrays.copyOfRange(BytesUtils.getByteArray(buffer), start, end);
    }

    public static List<byte[]> split(byte[] b, byte[] delim) {
        int delimIdx;
        if (b.length == 0) {
            return Arrays.asList(new byte[][]{Arrays.copyOf(b, b.length)});
        }
        if (delim.length == 0) {
            return BytesUtils.splitAllBytes(b);
        }
        int offset = 0;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        while ((delimIdx = BytesUtils.indexOf(b, delim, offset)) != -1) {
            int newSplitLength = delimIdx - offset;
            byte[] newSplitArray = new byte[newSplitLength];
            System.arraycopy(b, offset, newSplitArray, 0, newSplitLength);
            list.add(newSplitArray);
            offset = delimIdx + delim.length;
        }
        list.add(Arrays.copyOfRange(b, offset, b.length));
        return list;
    }

    private static List<byte[]> splitAllBytes(byte[] b) {
        ArrayList<byte[]> result = new ArrayList<byte[]>(b.length);
        for (int i = 0; i < b.length; ++i) {
            result.add(new byte[]{b[i]});
        }
        return result;
    }

    public static int indexOf(byte[] array, byte[] target, int fromIndex) {
        for (int i = fromIndex; i < array.length; ++i) {
            if (array[i] != target[0] || !BytesUtils.arrayEquals(array, i, target, 0, target.length)) continue;
            return i;
        }
        return -1;
    }

    public static void checkBytesSize(ByteBuffer buffer, int size) {
        int bufferSize = BytesUtils.getByteArray(buffer).length;
        if (bufferSize != size) {
            throw new KsqlException(String.format("Number of bytes must be equal to %d, but found %d", size, bufferSize));
        }
    }

    private static boolean arrayEquals(byte[] a, int aFromIndex, byte[] b, int bFromIndex, int length) {
        if (aFromIndex + length > a.length) {
            return false;
        }
        if (bFromIndex + length > b.length) {
            return false;
        }
        int i = aFromIndex;
        for (int j = bFromIndex; i < length && j < b.length; ++i, ++j) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static String hexEncoding(byte[] value) {
        return DatatypeConverter.printHexBinary((byte[])value);
    }

    private static byte[] hexDecoding(String value) {
        return DatatypeConverter.parseHexBinary((String)value);
    }

    private static String utf8Encoding(byte[] value) {
        return new String(value, StandardCharsets.UTF_8);
    }

    private static byte[] utf8Decoding(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    private static String asciiEncoding(byte[] value) {
        return new String(value, StandardCharsets.US_ASCII);
    }

    private static byte[] asciiDecoding(String value) {
        return value.getBytes(StandardCharsets.US_ASCII);
    }

    private static String base64Encoding(byte[] value) {
        return Base64.getEncoder().encodeToString(value);
    }

    private static byte[] base64Decoding(String value) {
        return Base64.getDecoder().decode(value);
    }

    public static enum Encoding {
        HEX,
        UTF8,
        ASCII,
        BASE64;


        public static Encoding from(String value) {
            if (value.equalsIgnoreCase("hex")) {
                return HEX;
            }
            if (value.equalsIgnoreCase("utf8")) {
                return UTF8;
            }
            if (value.equalsIgnoreCase("ascii")) {
                return ASCII;
            }
            if (value.equalsIgnoreCase("base64")) {
                return BASE64;
            }
            throw new IllegalArgumentException("Unknown encoding type '" + value + "'. Supported formats are 'hex', 'utf8', 'ascii', and 'base64'.");
        }
    }
}

