/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.model.WindowType;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class WindowInfo {
    private final WindowType type;
    private final Optional<Duration> size;

    @JsonCreator
    public static WindowInfo of(@JsonProperty(value="type", required=true) WindowType type, @JsonProperty(value="size") Optional<Duration> size) {
        return new WindowInfo(type, size);
    }

    private WindowInfo(WindowType type, Optional<Duration> size) {
        this.type = Objects.requireNonNull(type, "type");
        this.size = Objects.requireNonNull(size, "size");
        if (type.requiresWindowSize() && !size.isPresent()) {
            throw new IllegalArgumentException("Size required");
        }
        if (!type.requiresWindowSize() && size.isPresent()) {
            throw new IllegalArgumentException("Size not required");
        }
        if (size.isPresent() && (size.get().isZero() || size.get().isNegative())) {
            throw new IllegalArgumentException("Size must be positive");
        }
    }

    public WindowType getType() {
        return this.type;
    }

    public Optional<Duration> getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowInfo that = (WindowInfo)o;
        return this.type == that.type && Objects.equals(this.size, that.size);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.size});
    }

    public String toString() {
        return "WindowInfo{type=" + (Object)((Object)this.type) + ", size=" + this.size.map(Duration::toMillis) + '}';
    }
}

