/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class VariableParser {
    private VariableParser() {
    }

    public static Map<String, String> getVariables(List<String> definedVars) {
        if (definedVars == null) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder variables = ImmutableMap.builder();
        for (String pair : definedVars) {
            String[] parts = pair.split("=");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Failed to parse argument " + pair + ": variables must be defined using '=' (i.e. var=val).");
            }
            variables.put((Object)parts[0], (Object)parts[1]);
        }
        return variables.build();
    }
}

