/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.model;

import org.apache.commons.lang3.StringUtils;

public enum WindowType {
    SESSION(false),
    HOPPING(true),
    TUMBLING(true);

    private final boolean requiresWindowSize;

    private WindowType(boolean requiresWindowSize) {
        this.requiresWindowSize = requiresWindowSize;
    }

    public boolean requiresWindowSize() {
        return this.requiresWindowSize;
    }

    public static WindowType of(String text) {
        try {
            return WindowType.valueOf(text.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown window type: '" + text + "' " + System.lineSeparator() + "Valid values are: " + StringUtils.join((Object[])WindowType.values(), (String)", "), e);
        }
    }
}

