/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.function.types.ParamType;
import java.util.Objects;

@Immutable
public final class ParameterInfo {
    private final String name;
    private final ParamType type;
    private final String description;
    private final boolean isVariadic;

    public ParameterInfo(String name, ParamType type, String description, boolean isVariadic) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.isVariadic = isVariadic;
    }

    public String name() {
        return this.name;
    }

    public ParamType type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public boolean isVariadic() {
        return this.isVariadic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterInfo that = (ParameterInfo)o;
        return this.isVariadic == that.isVariadic && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.description, this.isVariadic);
    }

    public String toString() {
        return "ParameterInfo{name='" + this.name + '\'' + ", type=" + this.type + ", description='" + this.description + '\'' + ", isVariadic=" + this.isVariadic + '}';
    }
}

