/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.config;

import java.util.Objects;
import org.apache.kafka.common.config.ConfigDef;

public interface ConfigItem {
    public boolean isResolved();

    public String getPropertyName();

    public Object parseValue(Object var1);

    public String convertToString(Object var1);

    public boolean isDefaultValue(Object var1);

    public static ConfigItem resolved(ConfigDef.ConfigKey key) {
        return new Resolved(key);
    }

    public static ConfigItem unresolved(String propertyName) {
        return new Unresolved(propertyName);
    }

    public static class Resolved
    implements ConfigItem {
        private final ConfigDef.ConfigKey key;

        private Resolved(ConfigDef.ConfigKey key) {
            this.key = Objects.requireNonNull(key, "key");
        }

        @Override
        public boolean isResolved() {
            return true;
        }

        @Override
        public String getPropertyName() {
            return this.key.name;
        }

        @Override
        public Object parseValue(Object value) {
            Object parsed = ConfigDef.parseType((String)this.key.name, (Object)value, (ConfigDef.Type)this.key.type);
            if (this.key.validator != null) {
                this.key.validator.ensureValid(this.key.name, parsed);
            }
            return parsed;
        }

        @Override
        public String convertToString(Object value) {
            Object parsed = this.parseValue(value);
            return ConfigDef.convertToString((Object)parsed, (ConfigDef.Type)this.key.type);
        }

        @Override
        public boolean isDefaultValue(Object value) {
            Object parsed = this.parseValue(value);
            return Objects.equals(parsed, this.key.defaultValue);
        }

        ConfigDef.ConfigKey getKey() {
            return this.key;
        }
    }

    public static class Unresolved
    implements ConfigItem {
        private final String propertyName;

        private Unresolved(String propertyName) {
            this.propertyName = Objects.requireNonNull(propertyName, "propertyName");
        }

        @Override
        public boolean isResolved() {
            return false;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public Object parseValue(Object value) {
            return value;
        }

        @Override
        public String convertToString(Object value) {
            return value == null ? "NULL" : value.toString();
        }

        @Override
        public boolean isDefaultValue(Object value) {
            return false;
        }
    }
}

