/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.services.sso.auth.ExpiredTokenException;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class SsoAccessTokenProvider {
    private static final JsonNodeParser PARSER = JsonNodeParser.builder().removeErrorLocations(true).build();
    private final Path cachedTokenFilePath;

    public SsoAccessTokenProvider(Path cachedTokenFilePath) {
        this.cachedTokenFilePath = cachedTokenFilePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resolveAccessToken() {
        try (InputStream cachedTokenStream = Files.newInputStream(this.cachedTokenFilePath, new OpenOption[0]);){
            String string = this.getTokenFromJson(IoUtils.toUtf8String((InputStream)cachedTokenStream));
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getTokenFromJson(String json) {
        JsonNode jsonNode = PARSER.parse(json);
        String expiration = jsonNode.field("expiresAt").map(JsonNode::text).orElse(null);
        Validate.notNull((Object)expiration, (String)"The SSO session's expiration time could not be determined. Please refresh your SSO session.", (Object[])new Object[0]);
        if (this.tokenIsInvalid(expiration)) {
            throw ExpiredTokenException.builder().message("The SSO session associated with this profile has expired or is otherwise invalid. To refresh this SSO session run aws sso login with the corresponding profile.").build();
        }
        return ((JsonNode)jsonNode.asObject().get("accessToken")).text();
    }

    private boolean tokenIsInvalid(String expirationTime) {
        return Instant.now().isAfter(Instant.parse(expirationTime).minus(15L, ChronoUnit.MINUTES));
    }
}

