/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.SupportsTriggerAvailableNow;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.MemoryStreamBase;
import org.apache.spark.sql.execution.streaming.MemoryStreamInputPartition;
import org.apache.spark.sql.execution.streaming.MemoryStreamReaderFactory$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u0015v!B\"E\u0011\u0003\tf!B*E\u0011\u0003!\u0006\"B2\u0002\t\u0003!\u0007bB3\u0002\u0005\u0004%\tB\u001a\u0005\u0007c\u0006\u0001\u000b\u0011B4\t\u000fI\f!\u0019!C\tM\"11/\u0001Q\u0001\n\u001dDQ\u0001^\u0001\u0005\u0002UDa\u0001^\u0001\u0005\u0002\r-\u0003\u0002\u0003;\u0002\u0003\u0003%\ti!\u0019\t\u0013\r]\u0014!%A\u0005\u0002\re\u0004\"CB?\u0003\u0005\u0005I\u0011QB@\u0011%\u0019)*AI\u0001\n\u0003\u00199\nC\u0005\u0004\u001c\u0006\t\t\u0011\"\u0003\u0004\u001e\u001a!1\u000b\u0012!y\u0011)\t\tF\u0004BK\u0002\u0013\u0005\u00111\u000b\u0005\u000b\u00037r!\u0011#Q\u0001\n\u0005U\u0003BCA/\u001d\tU\r\u0011\"\u0001\u0002`!Q\u0011\u0011\u000e\b\u0003\u0012\u0003\u0006I!!\u0019\t\u0015\u0005-dB!f\u0001\n\u0003\ti\u0007\u0003\u0006\u0002v9\u0011\t\u0012)A\u0005\u0003_B!\"a\u001e\u000f\u0005\u0007\u0005\u000b1BA=\u0011\u0019\u0019g\u0002\"\u0001\u0002\u0000!I\u0011Q\u0012\bC\u0002\u0013E\u0011q\u0012\u0005\t\u0003Os\u0001\u0015!\u0003\u0002\u0012\"I\u0011\u0011\u0016\bC\u0002\u0013E\u00111\u0016\u0005\t\u0003\u0013t\u0001\u0015!\u0003\u0002.\"I\u0011Q\u001d\bA\u0002\u0013E\u0011q\u001d\u0005\n\u0003_t\u0001\u0019!C\t\u0003cD\u0001\"!@\u000fA\u0003&\u0011\u0011\u001e\u0005\n\u0005\u0003q\u0001\u0019!C\t\u0003OD\u0011Ba\u0001\u000f\u0001\u0004%\tB!\u0002\t\u0011\t%a\u0002)Q\u0005\u0003SD\u0011B!\u0004\u000f\u0001\u0004%I!a:\t\u0013\t=a\u00021A\u0005\n\tE\u0001\u0002\u0003B\u000b\u001d\u0001\u0006K!!;\t\u0017\tea\u00021AA\u0002\u0013%!1\u0004\u0005\f\u0005Gq\u0001\u0019!a\u0001\n\u0013\u0011)\u0003C\u0006\u0003*9\u0001\r\u0011!Q!\n\tu\u0001\"\u0003B\u0017\u001d\u0001\u0007I\u0011CAt\u0011%\u0011yC\u0004a\u0001\n#\u0011\t\u0004\u0003\u0005\u000369\u0001\u000b\u0015BAu\u0011\u001d\u0011ID\u0004C\u0001\u0005wAqAa\u0013\u000f\t\u0003\u0012i\u0005C\u0004\u0003`9!\tE!\u0019\t\u000f\t\u001dd\u0002\"\u0011\u0003j!9!1\u000e\b\u0005B\t5\u0004b\u0002B8\u001d\u0011\u0005#\u0011\u000e\u0005\b\u0005_rA\u0011\tB9\u0011\u001d\u0011yH\u0004C!\u0005\u0003CqA!&\u000f\t\u0003\u00129\nC\u0004\u0003 :!IA!)\t\u000f\tEf\u0002\"\u0011\u00034\"9!q\u0017\b\u0005B\t5\u0004b\u0002B]\u001d\u0011\u0005!Q\u000e\u0005\n\u0005ws\u0011\u0011!C\u0001\u0005{C\u0011Ba5\u000f#\u0003%\tA!6\t\u0013\t5h\"%A\u0005\u0002\t=\b\"\u0003B|\u001dE\u0005I\u0011\u0001B}\u0011%\u0019\tADA\u0001\n\u0003\u001a\u0019\u0001C\u0005\u0004\u00109\t\t\u0011\"\u0001\u0002T!I1\u0011\u0003\b\u0002\u0002\u0013\u000511\u0003\u0005\n\u0007/q\u0011\u0011!C!\u00073A\u0011ba\t\u000f\u0003\u0003%\ta!\n\t\u0013\r=b\"!A\u0005B\rE\u0002\"CB\u001b\u001d\u0005\u0005I\u0011IB\u001c\u0011%\u0019IDDA\u0001\n\u0003\u001aY$\u0001\u0007NK6|'/_*ue\u0016\fWN\u0003\u0002F\r\u0006I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f\"\u000b\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005%S\u0015aA:rY*\u00111\nT\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b:\u000ba!\u00199bG\",'\"A(\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005I\u000bQ\"\u0001#\u0003\u00195+Wn\u001c:z'R\u0014X-Y7\u0014\u0007\u0005)6\f\u0005\u0002W36\tqKC\u0001Y\u0003\u0015\u00198-\u00197b\u0013\tQvK\u0001\u0004B]f\u0014VM\u001a\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000b!![8\u000b\u0003\u0001\fAA[1wC&\u0011!-\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u000babY;se\u0016tGO\u00117pG.LE-F\u0001h!\tAw.D\u0001j\u0015\tQ7.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003Y6\f!bY8oGV\u0014(/\u001a8u\u0015\tqw,\u0001\u0003vi&d\u0017B\u00019j\u00055\tEo\\7jG&sG/Z4fe\u0006y1-\u001e:sK:$(\t\\8dW&#\u0007%\u0001\bnK6|'/_*ue\u0016\fW.\u00133\u0002\u001f5,Wn\u001c:z'R\u0014X-Y7JI\u0002\nQ!\u00199qYf,2A^B!)\u0015981IB%!\u0011\u0011fba\u0010\u0016\u0005e|8\u0003\u0004\b{\u0003#\t\u0019#!\u000b\u00026\u0005m\u0002c\u0001*|{&\u0011A\u0010\u0012\u0002\u0011\u001b\u0016lwN]=TiJ,\u0017-\u001c\"bg\u0016\u0004\"A`@\r\u0001\u00119\u0011\u0011\u0001\bC\u0002\u0005\r!!A!\u0012\t\u0005\u0015\u00111\u0002\t\u0004-\u0006\u001d\u0011bAA\u0005/\n9aj\u001c;iS:<\u0007c\u0001,\u0002\u000e%\u0019\u0011qB,\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002\u0014\u0005}QBAA\u000b\u0015\r)\u0015q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003sK\u0006$'bAA\u000f\u0011\u0006I1m\u001c8oK\u000e$xN]\u0005\u0005\u0003C\t)B\u0001\tNS\u000e\u0014xNQ1uG\"\u001cFO]3b[B!\u00111CA\u0013\u0013\u0011\t9#!\u0006\u00037M+\b\u000f]8siN$&/[4hKJ\fe/Y5mC\ndWMT8x!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018\u0015\u0006A\u0011N\u001c;fe:\fG.\u0003\u0003\u00024\u00055\"a\u0002'pO\u001eLgn\u001a\t\u0004-\u0006]\u0012bAA\u001d/\n9\u0001K]8ek\u000e$\b\u0003BA\u001f\u0003\u001brA!a\u0010\u0002J9!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002FA\u000ba\u0001\u0010:p_Rt\u0014\"\u0001-\n\u0007\u0005-s+A\u0004qC\u000e\\\u0017mZ3\n\u0007\t\fyEC\u0002\u0002L]\u000b!!\u001b3\u0016\u0005\u0005U\u0003c\u0001,\u0002X%\u0019\u0011\u0011L,\u0003\u0007%sG/A\u0002jI\u0002\n!b]9m\u0007>tG/\u001a=u+\t\t\t\u0007\u0005\u0003\u0002d\u0005\u0015T\"\u0001%\n\u0007\u0005\u001d\u0004J\u0001\u0006T#2\u001buN\u001c;fqR\f1b]9m\u0007>tG/\u001a=uA\u0005ia.^7QCJ$\u0018\u000e^5p]N,\"!a\u001c\u0011\u000bY\u000b\t(!\u0016\n\u0007\u0005MtK\u0001\u0004PaRLwN\\\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003))g/\u001b3f]\u000e,G\u0005\u000e\t\u0006\u0003G\nY(`\u0005\u0004\u0003{B%aB#oG>$WM\u001d\u000b\t\u0003\u0003\u000b9)!#\u0002\fR!\u00111QAC!\r\u0011f\" \u0005\b\u0003o2\u00029AA=\u0011\u001d\t\tF\u0006a\u0001\u0003+Bq!!\u0018\u0017\u0001\u0004\t\t\u0007C\u0005\u0002lY\u0001\n\u00111\u0001\u0002p\u00051q.\u001e;qkR,\"!!%\u0011\r\u0005u\u00121SAL\u0013\u0011\t)*a\u0014\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u001a\u0006\rVBAAN\u0015\u0011\ti*a(\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0004\u0003CC\u0015\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005\u0015\u00161\u0014\u0002\n\u0003R$(/\u001b2vi\u0016\fqa\\;uaV$\b%A\u0004cCR\u001c\u0007.Z:\u0016\u0005\u00055\u0006CBAX\u0003s\u000bi,\u0004\u0002\u00022*!\u00111WA[\u0003\u001diW\u000f^1cY\u0016T1!a.X\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003w\u000b\tL\u0001\u0006MSN$()\u001e4gKJ\u0004RAVA`\u0003\u0007L1!!1X\u0005\u0015\t%O]1z!\u0011\tI*!2\n\t\u0005\u001d\u00171\u0014\u0002\n+:\u001c\u0018MZ3S_^\f\u0001BY1uG\",7\u000f\t\u0015\b5\u00055\u0017q\\Aq!\u0011\ty-a7\u000e\u0005\u0005E'b\u00017\u0002T*!\u0011Q[Al\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u00033\fQA[1wCbLA!!8\u0002R\nIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003G\fA\u0001\u001e5jg\u0006i1-\u001e:sK:$xJ\u001a4tKR,\"!!;\u0011\u0007I\u000bY/C\u0002\u0002n\u0012\u0013!\u0002T8oO>3gm]3u\u0003E\u0019WO\u001d:f]R|eMZ:fi~#S-\u001d\u000b\u0005\u0003g\fI\u0010E\u0002W\u0003kL1!a>X\u0005\u0011)f.\u001b;\t\u0013\u0005mH$!AA\u0002\u0005%\u0018a\u0001=%c\u0005q1-\u001e:sK:$xJ\u001a4tKR\u0004\u0003fB\u000f\u0002N\u0006}\u0017\u0011]\u0001\fgR\f'\u000f^(gMN,G/A\bti\u0006\u0014Ho\u00144gg\u0016$x\fJ3r)\u0011\t\u0019Pa\u0002\t\u0013\u0005mx$!AA\u0002\u0005%\u0018\u0001D:uCJ$xJ\u001a4tKR\u0004\u0003f\u0002\u0011\u0002N\u0006}\u0017\u0011]\u0001\nK:$wJ\u001a4tKR\fQ\"\u001a8e\u001f\u001a47/\u001a;`I\u0015\fH\u0003BAz\u0005'A\u0011\"a?#\u0003\u0003\u0005\r!!;\u0002\u0015\u0015tGm\u00144gg\u0016$\b\u0005K\u0004$\u0003\u001b\fy.!9\u0002+\u00054\u0018-\u001b7bE2,gj\\<F]\u0012|eMZ:fiV\u0011!Q\u0004\t\u0005\u0003'\u0011y\"\u0003\u0003\u0003\"\u0005U!AB(gMN,G/A\rbm\u0006LG.\u00192mK:{w/\u00128e\u001f\u001a47/\u001a;`I\u0015\fH\u0003BAz\u0005OA\u0011\"a?&\u0003\u0003\u0005\rA!\b\u0002-\u00054\u0018-\u001b7bE2,gj\\<F]\u0012|eMZ:fi\u0002BsAJAg\u0003?\f\t/A\nmCN$xJ\u001a4tKR\u001cu.\\7jiR,G-A\fmCN$xJ\u001a4tKR\u001cu.\\7jiR,Gm\u0018\u0013fcR!\u00111\u001fB\u001a\u0011%\tY\u0010KA\u0001\u0002\u0004\tI/\u0001\u000bmCN$xJ\u001a4tKR\u001cu.\\7jiR,G\r\t\u0015\bS\u00055\u0017q\\Aq\u0003\u001d\tG\r\u001a#bi\u0006$BA!\u0010\u0003BA\u0019!Ka\u0010\n\u0007\t\u0005B\tC\u0004\u0003D)\u0002\rA!\u0012\u0002\t\u0011\fG/\u0019\t\u0006\u0003{\u00119%`\u0005\u0005\u0005\u0013\nyE\u0001\u0007Ji\u0016\u0014\u0018M\u00197f\u001f:\u001cW-\u0001\u0005u_N#(/\u001b8h)\t\u0011y\u0005\u0005\u0003\u0003R\tec\u0002\u0002B*\u0005+\u00022!!\u0011X\u0013\r\u00119fV\u0001\u0007!J,G-\u001a4\n\t\tm#Q\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t]s+A\teKN,'/[1mSj,wJ\u001a4tKR$BA!\b\u0003d!9!Q\r\u0017A\u0002\t=\u0013\u0001\u00026t_:\fQ\"\u001b8ji&\fGn\u00144gg\u0016$HC\u0001B\u000f\u0003u\u0001(/\u001a9be\u00164uN\u001d+sS\u001e<WM]!wC&d\u0017M\u00197f\u001d><HCAAz\u00031a\u0017\r^3ti>3gm]3u)\u0019\u0011iBa\u001d\u0003v!9!\u0011\u0001\u0019A\u0002\tu\u0001b\u0002B<a\u0001\u0007!\u0011P\u0001\u0006Y&l\u0017\u000e\u001e\t\u0005\u0003'\u0011Y(\u0003\u0003\u0003~\u0005U!!\u0003*fC\u0012d\u0015.\\5u\u0003M\u0001H.\u00198J]B,H\u000fU1si&$\u0018n\u001c8t)\u0019\u0011\u0019I!$\u0003\u0012B)a+a0\u0003\u0006B!!q\u0011BE\u001b\t\t9\"\u0003\u0003\u0003\f\u0006]!AD%oaV$\b+\u0019:uSRLwN\u001c\u0005\b\u0005\u001f\u000b\u0004\u0019\u0001B\u000f\u0003\u0015\u0019H/\u0019:u\u0011\u001d\u0011\u0019*\ra\u0001\u0005;\t1!\u001a8e\u0003M\u0019'/Z1uKJ+\u0017\rZ3s\r\u0006\u001cGo\u001c:z)\t\u0011I\n\u0005\u0003\u0003\b\nm\u0015\u0002\u0002BO\u0003/\u0011a\u0003U1si&$\u0018n\u001c8SK\u0006$WM\u001d$bGR|'/_\u0001\u0014O\u0016tWM]1uK\u0012+'-^4TiJLgn\u001a\u000b\t\u0005\u001f\u0012\u0019K!+\u0003.\"9!QU\u001aA\u0002\t\u001d\u0016\u0001\u0002:poN\u0004b!!\u0010\u0002\u0014\u0006\r\u0007b\u0002BVg\u0001\u0007\u0011QK\u0001\rgR\f'\u000f^(sI&t\u0017\r\u001c\u0005\b\u0005_\u001b\u0004\u0019AA+\u0003))g\u000eZ(sI&t\u0017\r\\\u0001\u0007G>lW.\u001b;\u0015\t\u0005M(Q\u0017\u0005\b\u0005'#\u0004\u0019\u0001B\u000f\u0003\u0011\u0019Ho\u001c9\u0002\u000bI,7/\u001a;\u0002\t\r|\u0007/_\u000b\u0005\u0005\u007f\u00139\r\u0006\u0005\u0003B\n5'q\u001aBi)\u0011\u0011\u0019M!3\u0011\tIs!Q\u0019\t\u0004}\n\u001dGaBA\u0001o\t\u0007\u00111\u0001\u0005\b\u0003o:\u00049\u0001Bf!\u0019\t\u0019'a\u001f\u0003F\"I\u0011\u0011K\u001c\u0011\u0002\u0003\u0007\u0011Q\u000b\u0005\n\u0003;:\u0004\u0013!a\u0001\u0003CB\u0011\"a\u001b8!\u0003\u0005\r!a\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!!q\u001bBv+\t\u0011IN\u000b\u0003\u0002V\tm7F\u0001Bo!\u0011\u0011yNa:\u000e\u0005\t\u0005(\u0002\u0002Br\u0005K\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Uw+\u0003\u0003\u0003j\n\u0005(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129\u0011\u0011\u0001\u001dC\u0002\u0005\r\u0011AD2paf$C-\u001a4bk2$HEM\u000b\u0005\u0005c\u0014)0\u0006\u0002\u0003t*\"\u0011\u0011\rBn\t\u001d\t\t!\u000fb\u0001\u0003\u0007\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0003\u0003|\n}XC\u0001B\u007fU\u0011\tyGa7\u0005\u000f\u0005\u0005!H1\u0001\u0002\u0004\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"a!\u0002\u0011\t\r\u001d1QB\u0007\u0003\u0007\u0013Q1aa\u0003`\u0003\u0011a\u0017M\\4\n\t\tm3\u0011B\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tYa!\u0006\t\u0013\u0005mX(!AA\u0002\u0005U\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\rm\u0001CBB\u000f\u0007?\tY!\u0004\u0002\u00026&!1\u0011EA[\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\r\u001d2Q\u0006\t\u0004-\u000e%\u0012bAB\u0016/\n9!i\\8mK\u0006t\u0007\"CA~\u007f\u0005\u0005\t\u0019AA\u0006\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\r\u001511\u0007\u0005\n\u0003w\u0004\u0015\u0011!a\u0001\u0003+\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003+\na!Z9vC2\u001cH\u0003BB\u0014\u0007{A\u0011\"a?C\u0003\u0003\u0005\r!a\u0003\u0011\u0007y\u001c\t\u0005B\u0004\u0002\u0002\u001d\u0011\r!a\u0001\t\u0013\r\u0015s!!AA\u0004\r\u001d\u0013AC3wS\u0012,gnY3%cA1\u00111MA>\u0007\u007fAq!!\u0018\b\u0001\b\t\t'\u0006\u0003\u0004N\rUC\u0003BB(\u0007?\"ba!\u0015\u0004X\ru\u0003\u0003\u0002*\u000f\u0007'\u00022A`B+\t\u001d\t\t\u0001\u0003b\u0001\u0003\u0007A\u0011b!\u0017\t\u0003\u0003\u0005\u001daa\u0017\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u0004\u0002d\u0005m41\u000b\u0005\b\u0003;B\u00019AA1\u0011\u001d\tY\u0007\u0003a\u0001\u0003+*Baa\u0019\u0004lQA1QMB9\u0007g\u001a)\b\u0006\u0003\u0004h\r5\u0004\u0003\u0002*\u000f\u0007S\u00022A`B6\t\u001d\t\t!\u0003b\u0001\u0003\u0007Aq!a\u001e\n\u0001\b\u0019y\u0007\u0005\u0004\u0002d\u0005m4\u0011\u000e\u0005\b\u0003#J\u0001\u0019AA+\u0011\u001d\ti&\u0003a\u0001\u0003CB\u0011\"a\u001b\n!\u0003\u0005\r!a\u001c\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM*BAa?\u0004|\u00119\u0011\u0011\u0001\u0006C\u0002\u0005\r\u0011aB;oCB\u0004H._\u000b\u0005\u0007\u0003\u001b\u0019\n\u0006\u0003\u0004\u0004\u000e-\u0005#\u0002,\u0002r\r\u0015\u0005#\u0003,\u0004\b\u0006U\u0013\u0011MA8\u0013\r\u0019Ii\u0016\u0002\u0007)V\u0004H.Z\u001a\t\u0013\r55\"!AA\u0002\r=\u0015a\u0001=%aA!!KDBI!\rq81\u0013\u0003\b\u0003\u0003Y!\u0019AA\u0002\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU!!1`BM\t\u001d\t\t\u0001\u0004b\u0001\u0003\u0007\tAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"aa(\u0011\t\r\u001d1\u0011U\u0005\u0005\u0007G\u001bIA\u0001\u0004PE*,7\r\u001e")
public class MemoryStream<A>
extends MemoryStreamBase<A>
implements MicroBatchStream,
SupportsTriggerAvailableNow,
Logging,
Product,
Serializable {
    private final int id;
    private final SQLContext sqlContext;
    private final Option<Object> numPartitions;
    private final Seq<Attribute> output;
    @GuardedBy(value="this")
    private final ListBuffer<UnsafeRow[]> batches;
    @GuardedBy(value="this")
    private LongOffset currentOffset;
    @GuardedBy(value="this")
    private LongOffset startOffset;
    @GuardedBy(value="this")
    private LongOffset endOffset;
    @GuardedBy(value="this")
    private org.apache.spark.sql.connector.read.streaming.Offset availableNowEndOffset;
    @GuardedBy(value="this")
    private LongOffset lastOffsetCommitted;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <A> Option<Object> $lessinit$greater$default$3() {
        return MemoryStream$.MODULE$.$lessinit$greater$default$3();
    }

    public static <A> Option<Tuple3<Object, SQLContext, Option<Object>>> unapply(MemoryStream<A> x$0) {
        return MemoryStream$.MODULE$.unapply(x$0);
    }

    public static <A> Option<Object> apply$default$3() {
        return MemoryStream$.MODULE$.apply$default$3();
    }

    public static <A> MemoryStream<A> apply(int id, SQLContext sqlContext, Option<Object> numPartitions, Encoder<A> evidence$4) {
        return MemoryStream$.MODULE$.apply(id, sqlContext, numPartitions, evidence$4);
    }

    public static <A> MemoryStream<A> apply(int numPartitions, Encoder<A> evidence$2, SQLContext sqlContext) {
        return MemoryStream$.MODULE$.apply(numPartitions, evidence$2, sqlContext);
    }

    public static <A> MemoryStream<A> apply(Encoder<A> evidence$1, SQLContext sqlContext) {
        return MemoryStream$.MODULE$.apply(evidence$1, sqlContext);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int id() {
        return this.id;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Option<Object> numPartitions() {
        return this.numPartitions;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public ListBuffer<UnsafeRow[]> batches() {
        return this.batches;
    }

    public LongOffset currentOffset() {
        return this.currentOffset;
    }

    public void currentOffset_$eq(LongOffset x$1) {
        this.currentOffset = x$1;
    }

    public LongOffset startOffset() {
        return this.startOffset;
    }

    public void startOffset_$eq(LongOffset x$1) {
        this.startOffset = x$1;
    }

    private LongOffset endOffset() {
        return this.endOffset;
    }

    private void endOffset_$eq(LongOffset x$1) {
        this.endOffset = x$1;
    }

    private org.apache.spark.sql.connector.read.streaming.Offset availableNowEndOffset() {
        return this.availableNowEndOffset;
    }

    private void availableNowEndOffset_$eq(org.apache.spark.sql.connector.read.streaming.Offset x$1) {
        this.availableNowEndOffset = x$1;
    }

    public LongOffset lastOffsetCommitted() {
        return this.lastOffsetCommitted;
    }

    public void lastOffsetCommitted_$eq(LongOffset x$1) {
        this.lastOffsetCommitted = x$1;
    }

    @Override
    public Offset addData(IterableOnce<A> data) {
        LongOffset longOffset;
        Seq objects = (Seq)data.iterator().to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Seq()));
        UnsafeRow[] rows = (UnsafeRow[])objects.iterator().map((Function1 & Serializable)d -> (UnsafeRow)this.toRow().apply(d).copy()).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Adding: " + objects);
        MemoryStream memoryStream = this;
        synchronized (memoryStream) {
            this.currentOffset_$eq(this.currentOffset().$plus(1L));
            this.batches().$plus$eq((Object)rows);
            longOffset = this.currentOffset();
        }
        return longOffset;
    }

    public String toString() {
        return "MemoryStream[" + org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString(this.output(), ",", SQLConf$.MODULE$.get().maxToStringFields()) + "]";
    }

    @Override
    public org.apache.spark.sql.connector.read.streaming.Offset deserializeOffset(String json) {
        return new LongOffset(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(json)));
    }

    @Override
    public org.apache.spark.sql.connector.read.streaming.Offset initialOffset() {
        return new LongOffset(-1L);
    }

    public synchronized void prepareForTriggerAvailableNow() {
        this.availableNowEndOffset_$eq(this.latestOffset(this.initialOffset(), ReadLimit.allAvailable()));
    }

    public org.apache.spark.sql.connector.read.streaming.Offset latestOffset() {
        throw new IllegalStateException("Should not reach here!");
    }

    public org.apache.spark.sql.connector.read.streaming.Offset latestOffset(org.apache.spark.sql.connector.read.streaming.Offset startOffset, ReadLimit limit) {
        if (this.currentOffset().offset() == -1L) {
            return null;
        }
        return this.currentOffset();
    }

    public InputPartition[] planInputPartitions(org.apache.spark.sql.connector.read.streaming.Offset start, org.apache.spark.sql.connector.read.streaming.Offset end) {
        InputPartition[] inputPartitionArray;
        LongOffset startOffset = (LongOffset)start;
        LongOffset endOffset = (LongOffset)end;
        MemoryStream memoryStream = this;
        synchronized (memoryStream) {
            InputPartition[] inputPartitionArray2;
            ListBuffer listBuffer;
            int startOrdinal = (int)startOffset.offset() + 1;
            int endOrdinal = (int)endOffset.offset() + 1;
            MemoryStream memoryStream2 = this;
            synchronized (memoryStream2) {
                int sliceStart = startOrdinal - (int)this.lastOffsetCommitted().offset() - 1;
                int sliceEnd = endOrdinal - (int)this.lastOffsetCommitted().offset() - 1;
                Predef$.MODULE$.assert(sliceStart <= sliceEnd, (Function0 & Serializable)() -> "sliceStart: " + sliceStart + " sliceEnd: " + sliceEnd);
                listBuffer = (ListBuffer)this.batches().slice(sliceStart, sliceEnd);
            }
            ListBuffer newBlocks = listBuffer;
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> this.generateDebugString((Seq<UnsafeRow>)((IterableOnceOps)newBlocks.flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs))).toSeq(), startOrdinal, endOrdinal));
            Option<Object> option = this.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numParts = BoxesRunTime.unboxToInt((Object)some.value());
                UnsafeRow[] inputRows = (UnsafeRow[])((IterableOnceOps)newBlocks.flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs))).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class));
                inputPartitionArray2 = (InputPartition[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numParts).map((Function1 & Serializable)newPartIdx -> MemoryStream.$anonfun$planInputPartitions$5(inputRows, numParts, BoxesRunTime.unboxToInt((Object)newPartIdx))).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
            } else {
                inputPartitionArray2 = (InputPartition[])((IterableOnceOps)newBlocks.map((Function1 & Serializable)block -> new MemoryStreamInputPartition((UnsafeRow[])block))).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
            }
            inputPartitionArray = inputPartitionArray2;
        }
        return inputPartitionArray;
    }

    public PartitionReaderFactory createReaderFactory() {
        return MemoryStreamReaderFactory$.MODULE$;
    }

    private String generateDebugString(Seq<UnsafeRow> rows, int startOrdinal, int endOrdinal) {
        ExpressionEncoder.Deserializer fromRow = this.encoder().resolveAndBind(this.encoder().resolveAndBind$default$1(), this.encoder().resolveAndBind$default$2()).createDeserializer();
        return "MemoryBatch [" + startOrdinal + ", " + endOrdinal + "]: " + ((IterableOnceOps)rows.map((Function1 & Serializable)row -> fromRow.apply((InternalRow)row))).mkString(", ");
    }

    @Override
    public synchronized void commit(org.apache.spark.sql.connector.read.streaming.Offset end) {
        LongOffset newOffset = (LongOffset)end;
        int offsetDiff = (int)(newOffset.offset() - this.lastOffsetCommitted().offset());
        if (offsetDiff < 0) {
            throw new IllegalStateException("Offsets committed out of order: " + this.lastOffsetCommitted() + " followed by " + end);
        }
        this.batches().dropInPlace(offsetDiff);
        this.lastOffsetCommitted_$eq(newOffset);
    }

    public void stop() {
    }

    public synchronized void reset() {
        this.batches().clear();
        this.startOffset_$eq(new LongOffset(-1L));
        this.endOffset_$eq(new LongOffset(-1L));
        this.currentOffset_$eq(new LongOffset(-1L));
        this.lastOffsetCommitted_$eq(new LongOffset(-1L));
        this.availableNowEndOffset_$eq(null);
    }

    public <A> MemoryStream<A> copy(int id, SQLContext sqlContext, Option<Object> numPartitions, Encoder<A> evidence$4) {
        return new MemoryStream<A>(id, sqlContext, numPartitions, evidence$4);
    }

    public <A> int copy$default$1() {
        return this.id();
    }

    public <A> SQLContext copy$default$2() {
        return this.sqlContext();
    }

    public <A> Option<Object> copy$default$3() {
        return this.numPartitions();
    }

    public String productPrefix() {
        return "MemoryStream";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.id());
            }
            case 1: {
                return this.sqlContext();
            }
            case 2: {
                return this.numPartitions();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MemoryStream;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "id";
            }
            case 1: {
                return "sqlContext";
            }
            case 2: {
                return "numPartitions";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.id());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sqlContext()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.numPartitions()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MemoryStream)) return false;
        boolean bl = true;
        if (!bl) return false;
        MemoryStream memoryStream = (MemoryStream)x$1;
        if (this.id() != memoryStream.id()) return false;
        SQLContext sQLContext = this.sqlContext();
        SQLContext sQLContext2 = memoryStream.sqlContext();
        if (sQLContext == null) {
            if (sQLContext2 != null) {
                return false;
            }
        } else if (!sQLContext.equals(sQLContext2)) return false;
        Option<Object> option = this.numPartitions();
        Option<Object> option2 = memoryStream.numPartitions();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!memoryStream.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$planInputPartitions$6(int numParts$1, int newPartIdx$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int idx = tuple2._2$mcI$sp();
            return idx % numParts$1 == newPartIdx$1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ MemoryStreamInputPartition $anonfun$planInputPartitions$5(UnsafeRow[] inputRows$1, int numParts$1, int newPartIdx) {
        UnsafeRow[] records = (UnsafeRow[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])inputRows$1))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MemoryStream.$anonfun$planInputPartitions$6(numParts$1, newPartIdx, x0$1)))), (Function1 & Serializable)x$2 -> (UnsafeRow)x$2._1(), ClassTag$.MODULE$.apply(UnsafeRow.class));
        return new MemoryStreamInputPartition(records);
    }

    public MemoryStream(int id, SQLContext sqlContext, Option<Object> numPartitions, Encoder<A> evidence$4) {
        this.id = id;
        this.sqlContext = sqlContext;
        this.numPartitions = numPartitions;
        super(sqlContext, evidence$4);
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.output = this.logicalPlan().output();
        this.batches = new ListBuffer();
        this.currentOffset = new LongOffset(-1L);
        this.startOffset = new LongOffset(-1L);
        this.endOffset = new LongOffset(-1L);
        this.lastOffsetCommitted = new LongOffset(-1L);
    }
}

