% WURZEL DOCUMENT CLASS -- Released September 2007 for LaTeX2e
% tf@wurzel.org
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\wzlversion{-old}
\def\filedate{2008/01/10}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{wurzel\wzlversion}[\filedate]

%%% COMPLILER (LATEX/PDFLATEX) UND AUSGABEFORMAT (DVI/PDF) ERMITTELN
\newif\ifpdflatex\pdflatexfalse
\ifx\pdfoutput\undefined\else\ifx\pdfoutput\relax\else\pdflatextrue\fi\fi
\newif\ifpdfoutput\pdfoutputfalse
\ifpdflatex\ifcase\pdfoutput\else\pdfoutputtrue\fi\fi

%%% VARIABLEN ZUR SPEICHERUNG DER KLASSENOPTIONEN
\newif\ifafive\afivetrue
\newif\ifmpost\mpostfalse
\newif\iffinal\finalfalse
\newif\ifprint\printfalse
\newif\ifmain\mainfalse
%%% DEKLARATION DER ALLGEMEINEN KLASSENOPTIONEN
\DeclareOption{dvioutput}  {\pdfoutputfalse}
\DeclareOption{pdfoutput}  {\pdfoutputtrue}
\DeclareOption{a5}         {\afivetrue}       % A5-Format fr Einzelseiten
\DeclareOption{a4}         {\afivefalse}      % A4-Format fr Einzelseiten
\DeclareOption{mpost}      {\mposttrue\pdfoutputfalse}% Zur Verwendung in Metapost
\DeclareOption{final}      {\finaltrue}       % Endversion (ohne Markierungen)
\DeclareOption{print}      {\printtrue\finaltrue} % Druckversion (ohne hyperref)
\DeclareOption{main}       {\maintrue}        % Steuerdatei fuer gesamtes Heft
%%% LAYOUTOPTIONEN
\DeclareOption{1993}       {\def\layout{1993}}
\DeclareOption{2000}       {\def\layout{2000}}
\DeclareOption{2001}       {\def\layout{2001}}%Preis in EUR und DM
\DeclareOption{2002}       {\def\layout{2002}}%nur noch in EUR 
\DeclareOption{2004}       {\def\layout{2004}}%Preiserhoehung
\DeclareOption{2005}       {\def\layout{2005}}%Neues Layout (fast wie 2008)
%%% LISTE DER ARTIKELOPTIONEN
\def\@wzloptionlist{firstpage,bookcorner,bookscorner,exercises,solutions}
\@for\@opt:=\@wzloptionlist\do{
  \expandafter\newif\csname if\@opt\endcsname   % \if-Befehl erzeugen
  \csname\@opt false\endcsname                  % Option auf false setzen
  %% Erzeuge \DeclareOption{xyz}{\xyztrue} mit xyz=\@opt
  \expandafter\DeclareOption\expandafter\@opt\csname\@opt true\endcsname
}
%%% OPTIONEN AUSFUEHREN (VARABLEN BELEGEN)
\pdfoutputtrue                                % Default: pdf-Ausgabe
\ProcessOptions

% Ausgabeformat je nach Programm und Klassenoptionen endgueltig festlegen
\ifpdflatex
  \ifpdfoutput\pdfoutput=1\else\pdfoutput=0\fi
\else
  \pdfoutputfalse
\fi

%%% KLASSE UND PAKETE LADEN
\LoadClass[twoside]{article}            % Standard Article-Klasse, zweiseitig
\RequirePackage[latin1]{inputenc}       % LATIN1 Eingabekodierung (bald utf8)
\RequirePackage{ifthen,calc}            % Abfragen und Arithmetik
\RequirePackage{amsmath,amssymb,amsthm} % AMS-Pakete
\let\mpoststop\relax\ifmpost            % Falls Metapost-Modus
  \RequirePackage{wzlfont\wzlversion}     % Zeichensatzanpassungen
  \RequirePackage{wzltool\wzlversion}     % Hilfsbefehle
  \let\mpoststop\endinput                 % ganzen Rest ignorieren
\fi\mpoststop
\RequirePackage[greek,english,french,german,ngerman]{babel}[2001/03/01] % mit \frenchspacing
\RequirePackage{wzlpage\wzlversion}     % Seiteneinrichtung
\ifpdfoutput                            % Hyperrefs, \url-Befehl
  \RequirePackage[pdftex]{hyperref}
\else
  \RequirePackage[dvips]{hyperref}
\fi
% Einstellungen fuer Hyperref
\ifafive\hypersetup{a5paper}\else\hypersetup{a4paper}\fi
\ifprint\hypersetup{draft}\fi
\pdfstringdefDisableCommands{\renewcommand\Wurzel{Wurzel}\renewcommand\\{ }}
\def\UrlFont{\vttfamily}
% Grafik, Spezialbefehle (\scalebox, \rotatebox, etc.)
\ifpdfoutput
  \RequirePackage[pdftex]{graphicx}
  \DeclareGraphicsExtensions{.png,.jpg,.mps,.pdf}
  \pdfcompresslevel=9
  \RequirePackage[pdftex,cmyk]{xcolor}
\else
  \RequirePackage[dvips]{graphicx}
  \DeclareGraphicsExtensions{.eps,.mps}
  \RequirePackage[dvips,cmyk]{xcolor}
\fi

%%% TITLE AND AUTHOR COMMANDS
\renewcommand\author[1]{\def\@author{#1}}
\renewcommand\title[2][\@title]{\def\@title{#2}\def\@headtitle{#1}}
\newcommand\name[1]{#1}
\newcommand\contentsignore[1]{#1}
\newcommand\onlycontents[1]{#1}
\newcommand\maketitleauthor{\maketitle[author]}
\renewcommand\maketitle[1][noauthor]{%
  \@maketitle{#1}%
  \markboth\@headtitle\@headtitle%
  \ifmain\writetitletotoc\fi%
}
\newcommand\titlefont{\normalfont\sffamily\bfseries}
\renewcommand\@maketitle[1]{%
  \renewcommand\contentsignore[1]{##1}%
  \renewcommand\onlycontents[1]{}%
  \renewcommand\name[1]{\textsc{##1}}%
  \part{\@title}
   \begin{center}
     \vspace*{1.0ex}\vspace{-1.5ex}
     {\Large\titlefont\@title\par\smallskip}
     \ifthenelse{\equal{#1}{author}}{\rmfamily von \@author}{}
   \end{center}\vspace*{-0.2ex}\nopagebreak%
}
\newcommand\authorfont{\normalfont\slshape}
\newcommand\makeauthor{\@makeauthor}
\newcommand\@makeauthor{\par\nopagebreak%
  \renewcommand\name[1]{##1}%
  \begin{flushright}{\authorfont\@author}\end{flushright}\vspace{-2ex}%
}
% Jeden Artikel als \part behandeln
\renewcommand\@part[2][]{%
  \refstepcounter{part}%
  \addcontentsline{toc}{part}{#1}%
  \@afterheading%
}
\setcounter{tocdepth}{2}

%%% Dokument-Einstellungen
\newcommand\extrafoot[1]{\def\outerfoot{#1}}
\newcommand\articleinfo[1]{\def\@articleinfo{[#1]}}\articleinfo{}
\newcommand\twodigits[1]{\two@digits{\value{#1}}}
\newcounter{hours}\newcounter{mins}\renewcommand\themins{\twodigits{mins}}
\newcommand\timestamp{%
  \setcounter{hours}{\time/60}\setcounter{mins}{\time-\value{hours}*60}%
  \texttt{\number\day.\,\number\month.\,\number\year~~\thehours:\themins~~}%
  \url{\jobname.tex}\ifx\@articleinfo\@empty\else~\texttt{\@articleinfo}\fi}

%%% IMPLEMENTATION DER ARTIKELOPTIONEN
\newcommand\processwzldocumentoptions{
  \ifbookcorner \title{Buchvorstellung} \fi
  \ifbookscorner\title{Buchvorstellungen} \fi
  \ifexercises  \title{\Wurzel-Aufgaben}\author{} \fi
  \ifsolutions  \author{} \fi
  \iffirstpage
    \thispagestyle{title}\enlargethispage{-125pt}
    \renewcommand\author[1]{\@latex@error{\string\author\space not allowed for firstpage. Use
                            \string\title\space for cover description}{}}%
    \renewcommand\title[1]{\ifmain\writetocfile{\string\def\string\coverinfo{##1}}\fi}%
  \fi
}
\processwzldocumentoptions

%%% UMBRUCHBEFEHLE, DIE NUR IM MAIN-MODUS AKTIV SIND
\newcommand\finalvspace{\@ifstar{\@gobble}{\@gobble}}
\newcommand\finalpagebreak[1][4]{}
\newcommand\finalnewpage{}
\newcommand\finalenlargethispage{\@ifstar{\@gobble}{\@gobble}}

%%% ALLGEMEINE ZUSATZBEFEHLE LADEN
\RequirePackage{wzlfont\wzlversion}     % Zeichensatzanpassungen
\RequirePackage{wzltool\wzlversion}     % Hilfsbefehle
\RequirePackage{wzlbook\wzlversion}     % Fuer Buchbesprechung(en)
\RequirePackage{wzlprob\wzlversion}     % Fuer Aufgaben und Loesungen
%%% ZUSATZBEFEHLE FUER KOMPLETTWURZEL LADEN
\ifmain
  \RequirePackage{wzlmain\wzlversion}
\fi

%%% MARKIERUNGEN (IM FINAL-MODUS AUS)
\iffinal
  \overfullrule0pt%
  \extrafoot{}%
  \newcommand\rem[1]{}
\else
  \overfullrule8pt%
  \extrafoot{\timestamp}
  \newcommand\rem[1]{{\normalmarginpar\marginparwidth4cm\marginpar{%
                      \footnotesize\sffamily\sbcseries #1}}}
  \RequirePackage{showlabels}[2005/05/26]
  \showlabels{cite}
  \showlabels{bibitem}
\fi

%%% INITIALISIERUNG
\def\@Preis{0,00\,\euro}
\def\@Zeitschrift{Zeitschrift f\"ur Mathematik}%
\def\@Ausgabe{0.~Jahrgang}%
\def\@Heft{Nullheft}
\def\@Wurzelheft{\Wurzel}
\def\@articleinfo{}
\pagestyle{headings}

%%% Hyperref verunstaltet i.V.m. \def\UrlFont{\vttfamily} den ersten \url-Link
%   durch ein vorgestelltes "j". Deshalb erzeugen wir einen 0-ten Wegwerf-Link:
\AtBeginDocument{\newsavebox\@bugbox\begin{lrbox}\@bugbox\url{www}\end{lrbox}}

%%%
%%% LAYOUT-VERSIONEN ANPASSUNGEN
%%%
% Hilfsbefehl fuer alle Ausgaben von 1993 bis 2004
% Syntax: \wzloldstyle{Einzelheftpreis}{Doppelheftpreis}{vorher}{nachher}
\newcommand\wzloldstylei[3]{
  \input{wzlallnames.def}
  \def\signature{Ihre \Wurzel--Redaktion}
  \DeclareGraphicsRule{*}{mps}{*}{}
  \newcommand\epsfig[2][]{\@epsfig[##1]|##2,|}
  \def\@epsfig[##1]|file=##2,##3|{\includegraphics[##3,##1]{##2}}
  \def\wzl@cons##1##2{\begingroup\let\@elt\relax\edef##1{##1\@elt ##2}\endgroup}
  \def\wzladdtoreset##1##2{\expandafter\wzl@cons\csname cl@##2\endcsname {{##1}}}
  \RequirePackage{2000_math}
  \input{2000_aufbox.def}
  \PassOptionsToPackage{german}{babel}
  \AtBeginDocument{\selectlanguage{german}}
  %%% References
  \RequirePackage{2002_newref}
  \newcommand\LABEL[1]{\label{\jobname:##1}}
  \newcommand\EQREF[1]{\eqref{\jobname:##1}}
  \newcommand\REF[1]{\ref{\jobname:##1}}
  \newcommand\PAGEREF[1]{\pageref\jobname:##1}
  %%% Kopf- und Fusszeilen, Abschnitte
  \def\innerheadstyle{\slshape}
  \def\outerheadstyle{}
  \def\innerfootstyle{\small\slshape}
  \def\outerfootstyle{}
  \def\titlefont{\normalfont\rmfamily\bfseries\Large}
  \def\section{\@startsection {section}{2}{\z@}{
    -2.5ex plus -0.8ex minus -0.2ex}{1.5ex plus0.2ex}{\large\bfseries}}
  \def\subsection{\@startsection{subsection}{3}{\z@}{
    -2.25ex plus -0.8ex minus -0.2ex}{0.9ex plus.1ex}{\normalsize\bfseries}}
  \def\subsubsection{\@startsection{subsubsection}{4}{\z@}{
    -2ex plus -0.8ex minus -0.2ex}{0.6ex plus.05ex}{\normalsize\bfseries}}
  \setcounter{secnumdepth}{4}
  \parskip0.5ex plus 0.3ex minus 0.3ex
  %%% \Wurzel
  \newsavebox{\wurzelbox}
  \DeclareRobustCommand\Wurzel[1][~]{%
      \sbox{\wurzelbox}{\uppercase{Wurzel}}%
      $\,\sqrt[\!\mathrm{##1}]{\usebox{\wurzelbox}}$\xspace}
  %%% Ausgabe, Preis
  \ifmain
    \renewcommand\thefirstmonth{\arabic{firstmonth}}
    \renewcommand\thesecondmonth{\arabic{secondmonth}}
    \renewcommand\issue[1]{%
      \@getyearmonth##1/%
      \def\@issuestring{\twodigits{year}\twodigits{firstmonth}}
      \def\@Zeitschrift{Zeitschrift f\"ur Mathematik}%
      \def\@Ausgabe{\thevolume.~Jahrgang}%
      \ifthenelse{\value{secondmonth}=0}
        {\def\@Preis{#1}%
         \def\@Heft{Heft \thefirstmonth/\twodigits{year}}
         \def\@Wurzelheft{\Wurzel~\thefirstmonth/\twodigits{year}}}
        {\def\@Preis{#2}
         \def\@Heft{Doppelheft \thefirstmonth+\thesecondmonth/\twodigits{year}}
         \def\@Wurzelheft{\Wurzel~\thefirstmonth+\thesecondmonth/\twodigits{year}}}%
    }
  \fi
  %%% Titelseite
  \def\ps@title{%
    \topmargin30pt
    \ifafive\addtolength\topmargin{-25mm}\fi
    \headheight64pt
    \topskip0pt
    \headsep64pt
    \footskip40pt
    \let\@mkboth\@gobbletwo
    \def\@oddhead{\parbox\textwidth{%
        \vspace*{-8pt}%
        \centerline{\scalebox{5.7}{\boldmath%
        $\sqrt[\scalebox{0.18}{\textbf{\Large\kern-8pt\raisebox{6pt}{Die}\kern5pt}}]
        {\scalebox{0.18}{\scalebox{3.16}{\textbf{\LARGE WURZEL}%
        \rule[-1.5pt]{0mm}{14.5pt}}}}$}}%
        \vspace{8pt}%
        \textbf{\Large\@Zeitschrift\hfill\@Preis}%
        \vspace{4pt}\hrule\hrule\hrule
        \vspace*{3pt}}}
    \def\@oddfoot{\raisebox{130pt}[0pt]{\parbox\textwidth{%
        \hrule\hrule\hrule\vspace{5pt}%
        {\bfseries\Large\@Heft\hfill\@Ausgabe}}}}
    \def\@evenhead{\@oddhead}
    \def\@evenfoot{\@oddfoot}
  }
  %%% Impressum
  \def\coverauthor{\coverinfo}
  \newcommand\makecontents[2][{1.2}\small]{%
    \immediate\closeout\tocfile%
    \clearpage
    \begingroup%
    \def\Bbb{\mathbb}%
    \newcommand\cntentry[3]{\renewcommand\@pnumwidth{1.55em}%
        \renewcommand\@dotsep{3}%
        \@dottedtocline{0}{0mm}{1.5em}{####1}{\rmfamily ####3}}
    \renewcommand\@maketitle[1]{}
    \renewcommand\writetitletotoc{}
    \title{Inhalt}\maketitle
    \unitlength=1mm\linethickness{0.4pt}\special{em:linewidth 0.4pt}\font\hands=wzlhand
    \begin{picture}(92,40)\put(-.5,18.2){\hands A}\put(69,20){\oval(92,40)}\end{picture}
    \rmfamily
    \par\vspace{20pt}
    \renewcommand\baselinestretch##1
    \textbf{In dieser Ausgabe lesen Sie:}
    \par\medskip
    \input cont\@issuestring.cnt
    \par\smallskip\vfill
    \def\getidate|####1.####2.####3|{\day=####1\month=####2\year=####3}%
    \imprintfbox{\getidate|##2|\input{./imprint.def}}
    \endgroup%
  }
  \let\imprintfbox\fbox
  \providecommand\rightbox[2]{\begin{insbox}{r}{##1}{\let\par\ipar##2}\end{insbox}}
  \providecommand\leftbox[2]{\begin{insbox}{l}{##1}{\let\par\ipar##2}\end{insbox}}
  \ifmain
    \newcommand\subarticleinput[3][\bigskipamount]{%
        \articleinput*[##1]{##2}\articleinput{##3}}
  \fi
  #3
}
\ifthenelse{\equal{\layout}{1993}}{%
  \wzloldstylei{1,00\,DM}{2,00\,DM}{%
    \inputencoding{cp850}\def\3{\ss}
    \RequirePackage[mp]{mppic-old}
    \setmpfontname{\jobname}
    \def\@cover{\coverinfo}
}}{}
\ifthenelse{\equal{\layout}{2000}}{%
  \wzloldstylei{1,00\,DM}{2,00\,DM}{%
    \inputencoding{latin1}
}}{}
\ifthenelse{\equal{\layout}{2001}}{%
  \wzloldstylei{0,80\,\euro\,/\,1,56\,DM}{1,60\,\euro\,/\,3,13\,DM}{%
    \inputencoding{latin1}
    \RequirePackage{2001_theorem}
}}{}
\ifthenelse{\equal{\layout}{2002}}{\wzloldstylei{0,80\,\euro}{1,60\,\euro}{%
    \inputencoding{latin1}
    \RequirePackage{2001_theorem}
    \RequirePackage{2002_book}
}}{}
\ifthenelse{\equal{\layout}{2004}}{\wzloldstylei{1,00\,\euro}{2,00\,\euro}{%
    \inputencoding{latin1}
    \RequirePackage{2001_theorem}
    \RequirePackage{2004_book}
    \input{2004_aufbox.def}
    \let\imprintfbox\relax
    %%% caption-Paket fuer Abbildungsunterschriften
    \RequirePackage{caption}
    \DeclareCaptionFont{wzlo-cf}{\renewcommand\baselinestretch{0.9}\small}
    \DeclareCaptionLabelFormat{wzlo-clf}{\textbf{#1~#2:}}
    \DeclareCaptionLabelSeparator{wzlo-cls}{~}
    \captionsetup{font=wzlo-cf,labelformat=wzlo-clf,labelsep=wzlo-cls}
    \newcommand\shortcaption{\captionsetup{labelsep=period}\caption{}}
}}{}
\ifthenelse{\equal{\layout}{2005}}{
    \inputencoding{latin1}
    \RequirePackage{fancybox}               % SHADED BOXES
    \RequirePackage{2005_book}
    \RequirePackage{2005_aufbox}
    %  \def\signature{Ihre \Wurzel--Redaktion}
    %  \AtBeginDocument{\def\refname{Literatur}}
    \DeclareGraphicsRule{*}{mps}{*}{}
    \renewcommand\wzllogo{\includegraphics{wurzel\wzlversion.100}}
    %% Abschnittsueberschriften etwas enger und in Sans-Font setzen
    \newcommand\Normalsize{\normalsize\@setfontsize\Normalsize\@xipt{13}}
    \newcommand\sectionfont{\normalfont\sffamily\bfseries}
    \def\section{\@startsection{section}{1}{0pt}%
     {2.5ex \@plus 1.0ex \@minus.3ex}{1.2ex \@plus.2ex \@minus.3ex}{\sectionfont\large}}
    \def\subsection{\@startsection{subsection}{2}{0pt}%
     {2.2ex \@plus 0.9ex \@minus.3ex}{0.7ex \@plus.2ex \@minus.2ex}{\sectionfont\normalsize}}
    \def\subsubsection{\@startsection{subsubsection}{3}{0pt}%
     {1.5ex \@plus 0.8ex \@minus.5ex}{0.1ex \@plus.1ex \@minus.1ex}{\sectionfont\normalsize}}
    \def\paragraph{\@startsection{paragraph}{4}{0pt}%
     {1.8ex \@plus 0.8ex \@minus.5ex}{-0.9em}{\sectionfont\normalsize}}
    \def\subparagraph{\@startsection{subparagraph}{5}{0pt}%
     {0.8ex \@plus 0.7ex \@minus.3ex}{-0.9em}{\sectionfont\normalsize}}
    \setcounter{secnumdepth}{2}
    \let\minisection\subsubsection
    \newcommand\insboxx[1]{\begin{insbox}#1\end{insbox}}
    % Miniitemize
    \newenvironment{miniitemize}{\begin{list}{\raisebox{0.2ex}{$\scriptstyle\bullet$}}
        {\parsep0.5\smallskipamount\leftmargin1.5em\labelwidth1em\labelsep0.5em%
         \topsep0.5\smallskipamount\itemsep0.5\smallskipamount}}{\end{list}}
    % CAPTIONS WITHOUT ADDITIONAL TEXT (==> Figure <n>.)
    \RequirePackage{caption}
    \captionsetup{font={small,sf},labelfont=bf,justification=centerlast}
    \abovecaptionskip0.5\abovecaptionskip
    \newcommand\shortcaption{\captionsetup{labelsep=period}\caption{}}
    % NON FLOATING FIGURES
    \renewenvironment{fixedfigure}[1][\linewidth]
        {\begin{minipage}{#1}\def\@captype{figure}}{\end{minipage}}
    %Lastpage
    \ifmain
      \renewcommand\makelastpage[2][{1.0}\normalsize]{%
        \immediate\closeout\tocfile%
        \clearpage
        \begingroup%
          \def\Bbb{\mathbb}%
          \newcommand\cntentry[3]{\renewcommand\@pnumwidth{1.55em}%
              \renewcommand\@dotsep{3}%
              \@dottedtocline{0}{0mm}{1.5em}{##1}{\sffamily ##3}}
          \renewcommand\@maketitle[1]{}
          \renewcommand\writetitletotoc{}
          \title{Inhalt}\maketitle
          % THE POINTING HAND
          \includegraphics{wurzel\wzlversion.0}
          \hfill
          \cornersize*{4mm}\ovalbox{\rule{85mm}{0mm}\rule[-20mm]{0mm}{37mm}}
          % TABLE OF CONTENTS
          \sffamily
          \par\vspace{20pt}
          \renewcommand\baselinestretch#1
          \textbf{In dieser Ausgabe lesen Sie:}
          \par\medskip
          \input cont\@issuestring.cnt
          \par\smallskip\vfill
          \fboxsep3pt
          \fbox{\begin{minipage}{\linewidth-2\fboxsep-2\fboxrule}
            \vskip1pt\sffamily\footnotesize\parskip0pt
            \centerline{\textbf{\large Impressum}}
            \par\smallskip
            #2
          \end{minipage}}%
        \endgroup%
      }
    \fi
}{}


\endinput
