/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.solver;

import uk.me.parabola.splitter.AbstractMapProcessor;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.MapDetails;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.RoundingUtils;
import uk.me.parabola.splitter.args.SplitterParams;
import uk.me.parabola.splitter.solver.DensityMap;

class DensityMapCollector
extends AbstractMapProcessor {
    private final DensityMap densityMap;
    private final MapDetails details = new MapDetails();
    private Area bounds;
    private final boolean ignoreBoundsTags;
    private int files;

    public DensityMapCollector(SplitterParams mainOptions) {
        Area densityBounds = new Area(-4194304, -8388608, 0x400000, 0x800000);
        this.densityMap = new DensityMap(densityBounds, mainOptions.getResolution());
        this.ignoreBoundsTags = mainOptions.getIgnoreOsmBounds();
    }

    @Override
    public boolean skipTags() {
        return true;
    }

    @Override
    public boolean skipWays() {
        return true;
    }

    @Override
    public boolean skipRels() {
        return true;
    }

    @Override
    public void startFile() {
        if (++this.files > 1) {
            this.checkBounds();
        }
    }

    @Override
    public void boundTag(Area fileBbox) {
        if (this.ignoreBoundsTags) {
            return;
        }
        this.bounds = this.bounds == null ? fileBbox : this.bounds.add(fileBbox);
    }

    @Override
    public void processNode(Node n) {
        int glat = n.getMapLat();
        int glon = n.getMapLon();
        this.densityMap.addNode(glat, glon);
        this.details.addToBounds(glat, glon);
    }

    public void checkBounds() {
        if (this.bounds == null) {
            this.bounds = this.getExactArea();
        }
    }

    public Area getExactArea() {
        if (this.bounds != null) {
            return this.bounds;
        }
        return this.details.getBounds();
    }

    public void mergeSeaData(DensityMapCollector seaData, boolean trim, int resolution) {
        Area roundedBounds = RoundingUtils.round(this.getExactArea(), resolution);
        this.densityMap.mergeSeaData(seaData.densityMap, roundedBounds, trim);
    }

    public void saveMap(String fileName) {
        if (this.details.getBounds() != null) {
            this.densityMap.saveMap(fileName, this.details.getBounds(), this.bounds);
        }
    }

    public void readMap(String fileName) {
        this.bounds = this.densityMap.readMap(fileName, this.details);
    }

    public DensityMap getDensityMap() {
        return this.densityMap;
    }
}

