/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import uk.me.parabola.splitter.AbstractMapProcessor;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.AreaDictionary;
import uk.me.parabola.splitter.AreaGridResult;
import uk.me.parabola.splitter.AreaSet;
import uk.me.parabola.splitter.DataStorer;
import uk.me.parabola.splitter.Element;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.Relation;
import uk.me.parabola.splitter.SplitFailedException;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.Way;
import uk.me.parabola.splitter.tools.Long2IntClosedMap;
import uk.me.parabola.splitter.tools.Long2IntClosedMapFunction;
import uk.me.parabola.splitter.tools.OSMId2ObjectMap;
import uk.me.parabola.splitter.tools.SparseBitSet;

class MultiTileProcessor
extends AbstractMapProcessor {
    private static final int PHASE1_RELS_ONLY = 1;
    private static final int PHASE2_WAYS_ONLY = 2;
    private static final int PHASE3_NODES_AND_WAYS = 3;
    private static final int PHASE4_WAYS_ONLY = 4;
    private final boolean addParentRels = false;
    private static final byte MEM_NODE_TYPE = 1;
    private static final byte MEM_WAY_TYPE = 2;
    private static final byte MEM_REL_TYPE = 3;
    private static final byte MEM_INVALID_TYPE = -1;
    private static final int PROBLEM_WIDTH = Utils.toMapUnit(180.0);
    protected static final String[] NAME_TAGS = new String[]{"name", "name:en", "int_name", "note"};
    private static final String NOT_SORTED_MSG = "Maybe the IDs are not sorted. This is not supported with keep-complete=true or --problem-list";
    private int phase = 1;
    private final DataStorer dataStorer;
    private final AreaDictionary areaDictionary;
    private Long2ObjectLinkedOpenHashMap<MTRelation> relMap = new Long2ObjectLinkedOpenHashMap();
    private Long2IntClosedMapFunction nodeWriterMap;
    private Long2IntClosedMapFunction wayWriterMap;
    private Long2IntClosedMapFunction relWriterMap;
    private int[] nodeLons;
    private int[] nodeLats;
    private SparseBitSet problemRels = new SparseBitSet();
    private SparseBitSet neededWays = new SparseBitSet();
    private SparseBitSet neededNodes = new SparseBitSet();
    private OSMId2ObjectMap<Rectangle> wayBboxMap = new OSMId2ObjectMap();
    private SparseBitSet mpWays = new SparseBitSet();
    private OSMId2ObjectMap<JoinedWay> mpWayEndNodesMap = new OSMId2ObjectMap();
    private final AreaSet workWriterSet = new AreaSet();
    private long lastCoordId = Long.MIN_VALUE;
    private int foundWays;
    private int neededNodesCount;
    private int neededWaysCount;
    private int neededMpWaysCount;
    private int visitId;

    MultiTileProcessor(DataStorer dataStorer, LongArrayList problemWayList, LongArrayList problemRelList) {
        long id;
        this.dataStorer = dataStorer;
        this.areaDictionary = dataStorer.getAreaDictionary();
        LongListIterator longListIterator = problemWayList.iterator();
        while (longListIterator.hasNext()) {
            id = (Long)longListIterator.next();
            this.neededWays.set(id);
        }
        longListIterator = problemRelList.iterator();
        while (longListIterator.hasNext()) {
            id = (Long)longListIterator.next();
            this.problemRels.set(id);
        }
        this.neededMpWaysCount = this.mpWays.cardinality();
        if (problemRelList.isEmpty()) {
            this.phase = 2;
        }
    }

    @Override
    public boolean skipTags() {
        return this.phase != 1;
    }

    @Override
    public boolean skipNodes() {
        return this.phase != 3;
    }

    @Override
    public boolean skipWays() {
        return this.phase == 1;
    }

    @Override
    public boolean skipRels() {
        return this.phase != 1 || this.problemRels.cardinality() <= 0;
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    @Override
    public void processNode(Node node) {
        if (this.phase == 3 && this.neededNodes.get(node.getId())) {
            this.storeCoord(node);
            this.neededNodes.clear(node.getId());
        }
    }

    @Override
    public void processWay(Way way) {
        if (this.phase == 2) {
            if (!this.neededWays.get(way.getId())) {
                return;
            }
            LongListIterator longListIterator = way.getRefs().iterator();
            while (longListIterator.hasNext()) {
                long id = (Long)longListIterator.next();
                this.neededNodes.set(id);
            }
            if (this.mpWays.get(way.getId())) {
                this.mpWays.clear(way.getId());
                int numRefs = way.getRefs().size();
                if (numRefs >= 2) {
                    JoinedWay joinedWay = new JoinedWay(way.getRefs().getLong(0), way.getRefs().getLong(numRefs - 1));
                    this.mpWayEndNodesMap.put(way.getId(), joinedWay);
                }
            }
            ++this.foundWays;
        } else if (this.phase == 3) {
            if (!this.neededWays.get(way.getId())) {
                return;
            }
            int numRefs = way.getRefs().size();
            boolean isClosed = numRefs > 1 && way.getRefs().get(0).equals(way.getRefs().get(numRefs - 1));
            this.workWriterSet.clear();
            Rectangle wayBbox = this.getWayBbox(way.getId(), way.getRefs());
            if (wayBbox == null) {
                return;
            }
            this.wayBboxMap.put(way.getId(), wayBbox);
            if (isClosed) {
                this.checkBoundingBox(this.workWriterSet, wayBbox);
            } else {
                this.addWritersOfWay(this.workWriterSet, wayBbox, way.getId(), way.getRefs());
            }
            int wayWriterIdx = this.workWriterSet.isEmpty() ? Short.MIN_VALUE : this.areaDictionary.translate(this.workWriterSet);
            try {
                this.wayWriterMap.add(way.getId(), wayWriterIdx);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
                throw new SplitFailedException(NOT_SORTED_MSG);
            }
        } else if (this.phase == 4) {
            if (!this.neededWays.get(way.getId())) {
                return;
            }
            int wayWriterIdx = this.wayWriterMap.getRandom(way.getId());
            if (wayWriterIdx != Short.MIN_VALUE) {
                AreaSet wayWriterSet = this.areaDictionary.getSet(wayWriterIdx);
                LongListIterator longListIterator = way.getRefs().iterator();
                while (longListIterator.hasNext()) {
                    long id = (Long)longListIterator.next();
                    this.addOrMergeWriters(this.nodeWriterMap, wayWriterSet, wayWriterIdx, id);
                }
            }
        }
    }

    @Override
    public void processRelation(Relation rel) {
        if (this.phase == 1) {
            MTRelation myRel = new MTRelation(rel);
            this.relMap.put(myRel.getId(), myRel);
        }
    }

    @Override
    public boolean endMap() {
        if (this.phase == 1) {
            this.stats("Finished collecting relations.");
            Utils.printMem();
            System.out.println("starting to resolve relations containing problem relations ...");
            this.markProblemMembers();
            this.relMap.long2ObjectEntrySet().removeIf(e -> !this.problemRels.get(e.getLongKey()));
            this.problemRels = null;
            this.relMap = new Long2ObjectLinkedOpenHashMap<MTRelation>((Long2ObjectMap<MTRelation>)this.relMap);
            System.out.println("Finished adding members of problem relations to problem lists.");
            this.stats("starting to collect ids of needed way nodes ...");
            this.neededMpWaysCount = this.mpWays.cardinality();
            this.neededWaysCount = this.neededWays.cardinality();
            ++this.phase;
        } else if (this.phase == 2) {
            this.stats("Finished collecting problem ways.");
            this.neededNodesCount = this.neededNodes.cardinality();
            this.nodeWriterMap = new Long2IntClosedMap("node", this.neededNodesCount, Short.MIN_VALUE);
            this.wayWriterMap = new Long2IntClosedMap("way", this.foundWays, Short.MIN_VALUE);
            this.dataStorer.setWriterMap(0, this.nodeWriterMap);
            this.dataStorer.setWriterMap(1, this.wayWriterMap);
            this.nodeLons = new int[this.neededNodesCount];
            this.nodeLats = new int[this.neededNodesCount];
            System.out.println("Found " + Utils.format(this.foundWays) + " of " + Utils.format(this.neededWaysCount) + " needed ways.");
            System.out.println("Found " + Utils.format(this.mpWayEndNodesMap.size()) + " of " + Utils.format(this.neededMpWaysCount) + " needed multipolygon ways.");
            this.stats("Starting to collect coordinates for " + Utils.format(this.neededNodesCount) + " needed nodes.");
            Utils.printMem();
            ++this.phase;
        } else if (this.phase == 3) {
            System.out.println("Found " + Utils.format(this.nodeWriterMap.size()) + " of " + Utils.format(this.neededNodesCount) + " needed nodes.");
            Utils.printMem();
            this.mpWays = null;
            this.neededNodes = null;
            System.out.println("Calculating tiles for problem relations...");
            this.calcWritersOfRelWaysAndNodes();
            this.nodeLats = null;
            this.nodeLons = null;
            this.calcWritersOfMultiPolygonRels();
            this.mergeRelMemWriters();
            this.propagateWritersOfRelsToMembers();
            this.mpWayEndNodesMap.clear();
            this.wayBboxMap = null;
            this.relWriterMap = new Long2IntClosedMap("rel", this.relMap.size(), Short.MIN_VALUE);
            for (Long2ObjectMap.Entry entry : this.relMap.long2ObjectEntrySet()) {
                int val = ((MTRelation)entry.getValue()).getMultiTileWriterIndex();
                if (val == Short.MIN_VALUE) continue;
                try {
                    this.relWriterMap.add(entry.getLongKey(), val);
                }
                catch (IllegalArgumentException e2) {
                    System.err.println(e2);
                    throw new SplitFailedException(NOT_SORTED_MSG);
                }
            }
            this.relMap = null;
            this.dataStorer.setWriterMap(2, this.relWriterMap);
            this.stats("Making sure that needed way nodes of relations are written to the correct tiles...");
            ++this.phase;
        } else if (this.phase == 4) {
            this.stats("Finished processing problem lists.");
            return true;
        }
        return false;
    }

    private void markProblemMembers() {
        ArrayList<MTRelation> visited = new ArrayList<MTRelation>();
        for (MTRelation rel : this.relMap.values()) {
            if (!this.problemRels.get(rel.getId())) continue;
            this.incVisitID();
            visited.clear();
            this.MarkNeededMembers(rel, 0, visited);
            assert (visited.size() == 0);
        }
    }

    private void MarkNeededMembers(MTRelation rel, int depth, ArrayList<MTRelation> visited) {
        if (rel.getLastVisitId() == this.visitId) {
            return;
        }
        rel.setLastVisitId(this.visitId);
        if (depth > 15) {
            System.out.println("MarkNeededMembers reached max. depth: " + rel.getId() + " " + depth);
            return;
        }
        for (int i = 0; i < rel.numMembers; ++i) {
            MTRelation subRel;
            long memId = rel.memRefs[i];
            byte memType = rel.memTypes[i];
            if (memType == 2) {
                this.neededWays.set(memId);
                if (!rel.isMultiPolygon()) continue;
                this.mpWays.set(memId);
                continue;
            }
            if (memType == 1) {
                this.neededNodes.set(memId);
                continue;
            }
            if (memType != 3 || (subRel = this.relMap.get(memId)) == null) continue;
            if (subRel.getLastVisitId() == this.visitId) {
                MultiTileProcessor.loopAction(rel, subRel, visited);
                continue;
            }
            this.problemRels.set(memId);
            visited.add(subRel);
            this.MarkNeededMembers(subRel, depth + 1, visited);
            visited.remove(visited.size() - 1);
        }
    }

    private void markParentRels() {
        boolean changed;
        do {
            changed = false;
            block1: for (MTRelation rel : this.relMap.values()) {
                if (!rel.hasRelMembers() || this.problemRels.get(rel.getId())) continue;
                for (int i = 0; i < rel.numMembers; ++i) {
                    long memId = rel.memRefs[i];
                    if (rel.memTypes[i] != 3 || !this.problemRels.get(memId)) continue;
                    this.problemRels.set(rel.getId());
                    rel.setAddedAsParent();
                    System.out.println("Adding parent of problem rel " + memId + " to problem list: " + rel.getId());
                    changed = true;
                    continue block1;
                }
            }
        } while (changed);
    }

    private void calcWritersOfRelWaysAndNodes() {
        for (MTRelation rel : this.relMap.values()) {
            if (!(rel.hasWayMembers() || rel.hasNodeMembers())) continue;
            AreaSet writerSet = new AreaSet();
            for (int i = 0; i < rel.numMembers; ++i) {
                long memId = rel.memRefs[i];
                boolean memFound = false;
                if (rel.memTypes[i] == 1) {
                    int pos = this.nodeWriterMap.getKeyPos(memId);
                    if (pos >= 0) {
                        this.addWritersOfPoint(writerSet, this.nodeLats[pos], this.nodeLons[pos]);
                        memFound = true;
                    }
                } else if (rel.memTypes[i] == 2) {
                    int idx = this.wayWriterMap.getRandom(memId);
                    if (idx != Short.MIN_VALUE) {
                        writerSet.or(this.areaDictionary.getSet(idx));
                        memFound = true;
                    }
                    if (this.wayBboxMap.get(memId) != null) {
                        memFound = true;
                    }
                } else if (rel.memTypes[i] == 3) continue;
                if (memFound) continue;
                rel.setNotComplete();
            }
            if (writerSet.isEmpty()) continue;
            int idx = this.areaDictionary.translate(writerSet);
            rel.setMultiTileWriterIndex(idx);
        }
    }

    private void calcWritersOfMultiPolygonRels() {
        ArrayList<MTRelation> visited = new ArrayList<MTRelation>();
        for (MTRelation rel : this.relMap.values()) {
            AreaSet relWriters = new AreaSet();
            if (!rel.isMultiPolygon()) continue;
            if (rel.hasRelMembers()) {
                this.incVisitID();
                visited.clear();
                this.orSubRelWriters(rel, 0, visited);
            }
            this.checkSpecialMP(relWriters, rel);
            if (relWriters.isEmpty()) continue;
            int writerIdx = this.areaDictionary.translate(relWriters);
            rel.setMultiTileWriterIndex(writerIdx);
            int touchedTiles = relWriters.cardinality();
            if (touchedTiles <= this.dataStorer.getNumOfAreas() / 2 || this.dataStorer.getNumOfAreas() <= 10) continue;
            System.out.println("Warning: rel " + rel.getId() + " touches " + touchedTiles + " tiles.");
        }
    }

    private void mergeRelMemWriters() {
        ArrayList<MTRelation> visited = new ArrayList<MTRelation>();
        for (MTRelation rel : this.relMap.values()) {
            this.incVisitID();
            visited.clear();
            this.orSubRelWriters(rel, 0, visited);
        }
    }

    private void propagateWritersOfRelsToMembers() {
        for (MTRelation rel : this.relMap.values()) {
            int relWriterIdx;
            if (rel.wasAddedAsParent() || (relWriterIdx = rel.getMultiTileWriterIndex()) == Short.MIN_VALUE) continue;
            AreaSet relWriters = this.areaDictionary.getSet(relWriterIdx);
            block5: for (int i = 0; i < rel.numMembers; ++i) {
                long memId = rel.memRefs[i];
                switch (rel.memTypes[i]) {
                    case 2: {
                        this.addOrMergeWriters(this.wayWriterMap, relWriters, relWriterIdx, memId);
                        continue block5;
                    }
                    case 1: {
                        this.addOrMergeWriters(this.nodeWriterMap, relWriters, relWriterIdx, memId);
                        continue block5;
                    }
                }
            }
        }
    }

    private void storeCoord(Node node) {
        long id = node.getId();
        if (this.lastCoordId >= id) {
            System.err.println("Error: Node ids are not sorted. Use e.g. osmosis to sort the input data.");
            System.err.println("This is not supported with keep-complete=true or --problem-list");
            throw new SplitFailedException("Node ids are not sorted");
        }
        int nodePos = -1;
        try {
            nodePos = this.nodeWriterMap.add(id, Short.MIN_VALUE);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            throw new SplitFailedException(NOT_SORTED_MSG);
        }
        this.nodeLons[nodePos] = node.getMapLon();
        this.nodeLats[nodePos] = node.getMapLat();
        this.lastCoordId = id;
    }

    private void orSubRelWriters(MTRelation rel, int depth, ArrayList<MTRelation> visited) {
        if (rel.getLastVisitId() == this.visitId) {
            return;
        }
        rel.setLastVisitId(this.visitId);
        if (depth > 15) {
            System.out.println("orSubRelWriters reached max. depth: " + rel.getId() + " " + depth);
            return;
        }
        AreaSet relWriters = new AreaSet();
        int relWriterIdx = rel.getMultiTileWriterIndex();
        if (relWriterIdx != Short.MIN_VALUE) {
            relWriters.or(this.areaDictionary.getSet(relWriterIdx));
        }
        boolean changed = false;
        for (int i = 0; i < rel.numMembers; ++i) {
            MTRelation subRel;
            long memId = rel.memRefs[i];
            if (rel.memTypes[i] != 3 || (subRel = this.relMap.get(memId)) == null) continue;
            if (subRel.getLastVisitId() == this.visitId) {
                MultiTileProcessor.loopAction(rel, subRel, visited);
                continue;
            }
            visited.add(rel);
            this.orSubRelWriters(subRel, depth + 1, visited);
            visited.remove(visited.size() - 1);
            int memWriterIdx = subRel.getMultiTileWriterIndex();
            if (memWriterIdx == Short.MIN_VALUE || memWriterIdx == relWriterIdx) continue;
            AreaSet memWriters = this.areaDictionary.getSet(memWriterIdx);
            int oldSize = relWriters.cardinality();
            relWriters.or(memWriters);
            if (oldSize == relWriters.cardinality()) continue;
            changed = true;
        }
        if (changed) {
            rel.setMultiTileWriterIndex(this.areaDictionary.translate(relWriters));
        }
    }

    private void stats(String msg) {
        System.out.println("Stats for " + this.getClass().getSimpleName() + " pass " + this.phase);
        if (this.problemRels != null) {
            System.out.println("  " + this.problemRels.getClass().getSimpleName() + " problemRels contains now " + Utils.format(this.problemRels.cardinality()) + " Ids.");
        }
        if (this.neededWays != null) {
            System.out.println("  " + this.neededWays.getClass().getSimpleName() + " neededWays contains now " + Utils.format(this.neededWays.cardinality()) + " Ids.");
        }
        if (this.mpWays != null) {
            System.out.println("  " + this.mpWays.getClass().getSimpleName() + " mpWays contains now " + Utils.format(this.mpWays.cardinality()) + " Ids.");
        }
        if (this.neededNodes != null) {
            System.out.println("  " + this.neededNodes.getClass().getSimpleName() + " neededNodes contains now " + Utils.format(this.neededNodes.cardinality()) + " Ids.");
        }
        if (this.relMap != null) {
            System.out.println("  Number of stored relations: " + Utils.format(this.relMap.size()));
        }
        System.out.println("  Number of stored tile combinations in multiTileDictionary: " + Utils.format(this.areaDictionary.size()));
        if (this.phase == 4) {
            this.dataStorer.stats("  ");
        }
        System.out.println("Status: " + msg);
    }

    private boolean checkBoundingBox(AreaSet writerSet, Rectangle polygonBbox) {
        boolean foundIntersection = false;
        if (polygonBbox != null) {
            for (int i = 0; i < this.dataStorer.getNumOfAreas(); ++i) {
                Rectangle writerBbox = Utils.area2Rectangle(this.dataStorer.getArea(i), 1);
                if (!writerBbox.intersects(polygonBbox)) continue;
                writerSet.set(i);
                foundIntersection = true;
            }
        }
        return foundIntersection;
    }

    private void addOrMergeWriters(Long2IntClosedMapFunction map, AreaSet parentWriters, int parentWriterIdx, long childId) {
        int pos = map.getKeyPos(childId);
        if (pos < 0) {
            return;
        }
        int childWriterIdx = map.getRandom(childId);
        if (childWriterIdx != Short.MIN_VALUE) {
            if (parentWriterIdx == childWriterIdx) {
                return;
            }
            AreaSet childWriters = this.areaDictionary.getSet(childWriterIdx);
            AreaSet mergedWriters = new AreaSet(parentWriters);
            mergedWriters.or(childWriters);
            childWriterIdx = this.areaDictionary.translate(mergedWriters);
        } else {
            childWriterIdx = parentWriterIdx;
        }
        map.replace(childId, childWriterIdx);
    }

    private boolean addWritersOfPoint(AreaSet writerSet, int mapLat, int mapLon) {
        AreaGridResult writerCandidates = this.dataStorer.getGrid().get(mapLat, mapLon);
        if (writerCandidates == null) {
            return false;
        }
        boolean foundWriter = false;
        for (int n : writerCandidates.set) {
            Area extbbox = this.dataStorer.getExtendedArea(n);
            boolean found = writerCandidates.testNeeded ? extbbox.contains(mapLat, mapLon) : true;
            foundWriter |= found;
            if (!found) continue;
            writerSet.set(n);
        }
        return foundWriter;
    }

    private void addWritersOfCrossedTiles(AreaSet writerSet, AreaSet possibleWriters, Point p1, Point p2) {
        for (int i : possibleWriters) {
            Rectangle writerBbox = Utils.area2Rectangle(this.dataStorer.getArea(i), 1);
            if (!writerBbox.intersectsLine(p1.x, p1.y, p2.x, p2.y)) continue;
            writerSet.set(i);
        }
    }

    private void addWritersOfWay(AreaSet writerSet, Rectangle wayBbox, long wayId, LongArrayList wayRefs) {
        int numRefs = wayRefs.size();
        int foundNodes = 0;
        boolean needsCrossTileCheck = false;
        Point p1 = null;
        Point p2 = null;
        for (int i = 0; i < numRefs; ++i) {
            long id = wayRefs.getLong(i);
            int pos = this.nodeWriterMap.getKeyPos(id);
            if (pos < 0) continue;
            ++foundNodes;
            boolean hasWriters = this.addWritersOfPoint(writerSet, this.nodeLats[pos], this.nodeLons[pos]);
            if (hasWriters) continue;
            needsCrossTileCheck = true;
        }
        if (foundNodes < numRefs) {
            System.out.println("Sorry, way " + wayId + " is missing " + (numRefs - foundNodes) + " node(s).");
        }
        if (!needsCrossTileCheck) {
            int numWriters = writerSet.cardinality();
            if (numWriters == 0) {
                needsCrossTileCheck = true;
            } else if (numWriters > 1 && this.dataStorer.getAreaDictionary().mayCross(writerSet)) {
                needsCrossTileCheck = true;
            }
        }
        if (needsCrossTileCheck) {
            AreaSet possibleWriters = new AreaSet();
            this.checkBoundingBox(possibleWriters, wayBbox);
            for (int i = 0; i < numRefs; ++i) {
                long id = wayRefs.getLong(i);
                int pos = this.nodeWriterMap.getKeyPos(id);
                if (pos < 0) continue;
                if (i > 0) {
                    p1 = p2;
                }
                p2 = new Point(this.nodeLons[pos], this.nodeLats[pos]);
                if (p1 == null) continue;
                this.addWritersOfCrossedTiles(writerSet, possibleWriters, p1, p2);
            }
        }
    }

    private Rectangle getWayBbox(long wayId, LongArrayList wayRefs) {
        int minLat = Integer.MAX_VALUE;
        int minLon = Integer.MAX_VALUE;
        int maxLat = Integer.MIN_VALUE;
        int maxLon = Integer.MIN_VALUE;
        int numRefs = wayRefs.size();
        for (int i = 0; i < numRefs; ++i) {
            long id = wayRefs.getLong(i);
            int pos = this.nodeWriterMap.getKeyPos(id);
            if (pos < 0) continue;
            int lat = this.nodeLats[pos];
            int lon = this.nodeLons[pos];
            if (lat < minLat) {
                minLat = lat;
            }
            if (lat > maxLat) {
                maxLat = lat;
            }
            if (lon < minLon) {
                minLon = lon;
            }
            if (lon <= maxLon) continue;
            maxLon = lon;
        }
        if (maxLon == Integer.MIN_VALUE || maxLat == Integer.MIN_VALUE) {
            System.out.println("Sorry, no nodes found for needed way " + wayId);
            return null;
        }
        return new Rectangle(minLon, minLat, Math.max(1, maxLon - minLon), Math.max(1, maxLat - minLat));
    }

    private void incVisitID() {
        if (this.visitId == Integer.MAX_VALUE) {
            this.visitId = 0;
            for (Long2ObjectMap.Entry entry : this.relMap.long2ObjectEntrySet()) {
                ((MTRelation)entry.getValue()).setLastVisitId(this.visitId);
            }
        }
        ++this.visitId;
    }

    static void loopAction(MTRelation rel, MTRelation subRel, ArrayList<MTRelation> visited) {
        if (subRel.isOnLoop()) {
            return;
        }
        if (rel.getId() == subRel.getId()) {
            System.out.println("Loop in relation " + rel.getId() + ": Contains itself as sub relation.");
            rel.markOnLoop();
        } else if (visited.contains(rel)) {
            subRel.markOnLoop();
            StringBuilder sb = new StringBuilder("Loop in relation " + subRel.getId() + ". Loop contains relation(s): ");
            for (MTRelation r : visited) {
                sb.append(r.getId());
                sb.append(' ');
                r.markOnLoop();
            }
            System.out.println(sb);
        } else {
            System.out.println("Duplicate sub relation in relation " + rel.getId() + ". Already looked at member " + subRel.getId() + ".");
        }
    }

    private void checkSpecialMP(AreaSet relWriters, MTRelation rel) {
        long[] joinedWays = null;
        LinkedList<Long> wayMembers = new LinkedList<Long>();
        LongArrayList polygonWays = new LongArrayList();
        for (int i = 0; i < rel.numMembers; ++i) {
            long memId = rel.memRefs[i];
            if (rel.memTypes[i] != 2 || "inner".equals(rel.memRoles[i])) continue;
            wayMembers.add(memId);
        }
        boolean complainedAboutSize = false;
        boolean hasMissingWays = false;
        while (wayMembers.size() > 0) {
            boolean changed;
            polygonWays.clear();
            Rectangle mpBbox = null;
            boolean closed = false;
            block2: do {
                changed = false;
                for (int i = wayMembers.size() - 1; i >= 0; --i) {
                    boolean added = false;
                    long memId = (Long)wayMembers.get(i);
                    JoinedWay mpWay = this.mpWayEndNodesMap.get(memId);
                    if (mpWay == null) {
                        wayMembers.remove(i);
                        hasMissingWays = true;
                        continue;
                    }
                    long mpWayStart = mpWay.startNode;
                    long mpWayEnd = mpWay.endNode;
                    added = true;
                    if (joinedWays == null) {
                        joinedWays = new long[]{mpWayStart, mpWayEnd};
                    } else if (joinedWays[0] == mpWayStart) {
                        joinedWays[0] = mpWayEnd;
                    } else if (joinedWays[0] == mpWayEnd) {
                        joinedWays[0] = mpWayStart;
                    } else if (joinedWays[1] == mpWayStart) {
                        joinedWays[1] = mpWayEnd;
                    } else if (joinedWays[1] == mpWayEnd) {
                        joinedWays[1] = mpWayStart;
                    } else {
                        added = false;
                    }
                    if (added) {
                        Rectangle wayBbox;
                        changed = true;
                        wayMembers.remove(i);
                        polygonWays.add(memId);
                        int pos = this.wayWriterMap.getKeyPos(memId);
                        if (pos < 0 || (wayBbox = this.wayBboxMap.get(memId)) == null) continue;
                        if (wayBbox.x < 0 && wayBbox.getMaxX() > 0.0 && wayBbox.width >= PROBLEM_WIDTH) {
                            System.out.println("way crosses -180/180: " + memId);
                        }
                        if (mpBbox == null) {
                            mpBbox = new Rectangle(wayBbox);
                        } else {
                            mpBbox.add(wayBbox);
                        }
                        if (!complainedAboutSize && mpBbox.x < 0 && mpBbox.getMaxX() > 0.0 && mpBbox.width >= PROBLEM_WIDTH) {
                            System.out.println("rel crosses -180/180: " + rel.getId());
                            complainedAboutSize = true;
                        }
                    }
                    if (joinedWays[0] != joinedWays[1]) continue;
                    closed = true;
                    continue block2;
                }
            } while (changed && !closed);
            if (mpBbox != null) {
                boolean isRelevant = this.checkBoundingBox(relWriters, mpBbox);
                if (isRelevant & hasMissingWays) {
                    System.out.println("Warning: Incomplete multipolygon relation " + rel.getId() + " (" + rel.getName() + "): using bbox of " + (closed ? "closed" : "unclosed") + " polygon to calc tiles, ways: " + polygonWays);
                }
                mpBbox = null;
            }
            joinedWays = null;
        }
    }

    private class MTRelation {
        private static final short IS_MP = 1;
        private static final short ON_LOOP = 2;
        private static final short HAS_NODES = 4;
        private static final short HAS_WAYS = 8;
        private static final short HAS_RELS = 16;
        private static final short IS_JUST_PARENT = 32;
        private static final short IS_NOT_COMPLETE = 64;
        private final long id;
        protected final byte[] memTypes;
        protected final String[] memRoles;
        protected final long[] memRefs;
        protected final int numMembers;
        private final String name;
        private int multiTileWriterIndex = Short.MIN_VALUE;
        private int lastVisitId;
        private short flags;

        public MTRelation(Relation rel) {
            this.numMembers = rel.getMembers().size();
            this.memTypes = new byte[this.numMembers];
            this.memRoles = new String[this.numMembers];
            this.memRefs = new long[this.numMembers];
            this.id = rel.getId();
            for (int i = 0; i < this.numMembers; ++i) {
                Relation.Member mem = rel.getMembers().get(i);
                this.memRefs[i] = mem.getRef();
                this.memRoles[i] = mem.getRole().intern();
                if ("node".equals(mem.getType())) {
                    this.memTypes[i] = 1;
                    this.flags = (short)(this.flags | 4);
                    continue;
                }
                if ("way".equals(mem.getType())) {
                    this.memTypes[i] = 2;
                    this.flags = (short)(this.flags | 8);
                    continue;
                }
                if ("relation".equals(mem.getType())) {
                    this.memTypes[i] = 3;
                    this.flags = (short)(this.flags | 0x10);
                    continue;
                }
                this.memTypes[i] = -1;
            }
            String type = rel.getTag("type");
            if ("multipolygon".equals(type) || "boundary".equals(type)) {
                this.markAsMultiPolygon();
            }
            String goodNameCandidate = null;
            String nameCandidate = null;
            String zipCode = null;
            Iterator<Element.Tag> tags = rel.tagsIterator();
            while (tags.hasNext()) {
                Element.Tag t = tags.next();
                for (String nameTag : NAME_TAGS) {
                    if (!nameTag.equals(t.key)) continue;
                    goodNameCandidate = t.value;
                    break;
                }
                if (goodNameCandidate != null) break;
                if (t.key.contains("name")) {
                    nameCandidate = t.value;
                    continue;
                }
                if (!"postal_code".equals(t.key)) continue;
                zipCode = t.value;
            }
            this.name = goodNameCandidate != null ? goodNameCandidate : (nameCandidate != null ? nameCandidate : (zipCode != null ? "postal_code=" + zipCode : "?"));
        }

        public long getId() {
            return this.id;
        }

        public boolean isOnLoop() {
            return (this.flags & 2) != 0;
        }

        public void markOnLoop() {
            this.flags = (short)(this.flags | 2);
        }

        public int getMultiTileWriterIndex() {
            return this.multiTileWriterIndex;
        }

        public void setMultiTileWriterIndex(int multiTileWriterIndex) {
            this.multiTileWriterIndex = multiTileWriterIndex;
        }

        public boolean hasNodeMembers() {
            return (this.flags & 4) != 0;
        }

        public boolean hasWayMembers() {
            return (this.flags & 8) != 0;
        }

        public boolean hasRelMembers() {
            return (this.flags & 0x10) != 0;
        }

        public boolean wasAddedAsParent() {
            return (this.flags & 0x20) != 0;
        }

        public void setAddedAsParent() {
            this.flags = (short)(this.flags | 0x20);
        }

        public boolean isNotComplete() {
            return (this.flags & 0x40) != 0;
        }

        public void setNotComplete() {
            this.flags = (short)(this.flags | 0x40);
        }

        public boolean isMultiPolygon() {
            return (this.flags & 1) != 0;
        }

        public void markAsMultiPolygon() {
            this.flags = (short)(this.flags | 1);
        }

        public int getLastVisitId() {
            return this.lastVisitId;
        }

        public void setLastVisitId(int visitId) {
            this.lastVisitId = visitId;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "r" + this.id + " " + this.name + " subrels:" + this.hasRelMembers() + " incomplete:" + this.isNotComplete();
        }
    }

    class JoinedWay {
        long startNode;
        long endNode;

        public JoinedWay(long startNode, long endNode) {
            this.startNode = startNode;
            this.endNode = endNode;
        }
    }
}

