/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.osmosis.core.filter.common.PolygonFileReader;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;

public class Java2DConverter {
    private static final Logger log = Logger.getLogger(Java2DConverter.class);

    public static java.awt.geom.Area createBoundsArea(Area bbox) {
        return Java2DConverter.createArea(bbox.toCoords());
    }

    public static Area createBbox(Shape shape) {
        Rectangle areaBounds = shape.getBounds();
        return new Area(areaBounds.y, areaBounds.x, (int)areaBounds.getMaxY(), (int)areaBounds.getMaxX());
    }

    public static java.awt.geom.Area createArea(List<Coord> polygonPoints) {
        return new java.awt.geom.Area(Java2DConverter.createPath2D(polygonPoints));
    }

    public static Path2D createPath2D(List<Coord> polygonPoints) {
        int n = polygonPoints.size();
        if (n < 3) {
            return new Path2D.Double();
        }
        Path2D.Double path = new Path2D.Double(1, n);
        if (polygonPoints.get(0).highPrecEquals(polygonPoints.get(n - 1))) {
            --n;
        }
        int lastLat = Integer.MAX_VALUE;
        int lastLon = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            Coord co = polygonPoints.get(i);
            int latHp = co.getHighPrecLat();
            int lonHp = co.getHighPrecLon();
            double x = (double)lonHp / 64.0;
            double y = (double)latHp / 64.0;
            if (i == 0) {
                ((Path2D)path).moveTo(x, y);
            } else if (lastLon != lonHp || lastLat != latHp) {
                ((Path2D)path).lineTo(x, y);
            }
            lastLon = lonHp;
            lastLat = latHp;
        }
        path.closePath();
        return path;
    }

    public static Polygon createHighPrecPolygon(List<Coord> points) {
        Polygon polygon = new Polygon();
        for (Coord co : points) {
            polygon.addPoint(co.getHighPrecLon(), co.getHighPrecLat());
        }
        return polygon;
    }

    public static List<java.awt.geom.Area> areaToSingularAreas(java.awt.geom.Area area) {
        return Java2DConverter.areaToSingularAreas(0, area);
    }

    private static List<java.awt.geom.Area> areaToSingularAreas(int depth, java.awt.geom.Area area) {
        if (area.isEmpty()) {
            return Collections.emptyList();
        }
        if (area.isSingular()) {
            return Collections.singletonList(area);
        }
        ArrayList<java.awt.geom.Area> singularAreas = new ArrayList<java.awt.geom.Area>();
        double[] res = new double[6];
        PathIterator pit = area.getPathIterator(null);
        Path2D path = null;
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            double lat = res[1];
            double lon = res[0];
            switch (type) {
                case 1: {
                    path.lineTo(lon, lat);
                    break;
                }
                case 4: {
                    path.closePath();
                    java.awt.geom.Area a = new java.awt.geom.Area(path);
                    if (!a.isEmpty()) {
                        if (depth < 10 && !a.isSingular()) {
                            singularAreas.addAll(Java2DConverter.areaToSingularAreas(depth + 1, a));
                        } else {
                            singularAreas.add(a);
                        }
                    }
                    path = null;
                    break;
                }
                case 0: {
                    path = new Path2D.Double();
                    path.moveTo(lon, lat);
                    break;
                }
                default: {
                    log.error((Object)("Unsupported path iterator type " + type + ". This is an mkgmap error."));
                }
            }
            pit.next();
        }
        return singularAreas;
    }

    public static List<Coord> singularAreaToPoints(java.awt.geom.Area area) {
        return Java2DConverter.singularAreaToPoints(area, null);
    }

    public static List<Coord> singularAreaToPoints(java.awt.geom.Area area, Long2ObjectOpenHashMap<Coord> coordPool) {
        if (area.isEmpty()) {
            return null;
        }
        ArrayList<Coord> points = null;
        double[] res = new double[6];
        PathIterator pit = area.getPathIterator(null);
        int prevLatHp = Integer.MIN_VALUE;
        int prevLongHp = Integer.MIN_VALUE;
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            int latHp = (int)Math.round(res[1] * 64.0);
            int lonHp = (int)Math.round(res[0] * 64.0);
            switch (type) {
                case 0: {
                    if (points != null) {
                        log.error((Object)"area not singular");
                    }
                    points = new ArrayList<Coord>();
                    points.add(Coord.makeHighPrecCoord(latHp, lonHp, coordPool));
                    break;
                }
                case 1: {
                    assert (points != null);
                    if (prevLatHp == latHp && prevLongHp == lonHp) break;
                    points.add(Coord.makeHighPrecCoord(latHp, lonHp, coordPool));
                    break;
                }
                case 4: {
                    assert (points != null);
                    if (points.size() < 3) {
                        points = null;
                        break;
                    }
                    if (((Coord)points.get(0)).highPrecEquals((Coord)points.get(points.size() - 1))) {
                        points.set(points.size() - 1, (Coord)points.get(0));
                    } else {
                        points.add((Coord)points.get(0));
                    }
                    if (points.size() < 4) {
                        points = null;
                        break;
                    }
                    return points;
                }
                default: {
                    log.error((Object)("Unsupported path iterator type " + type + ". This is an mkgmap error."));
                }
            }
            prevLatHp = latHp;
            prevLongHp = lonHp;
            pit.next();
        }
        return points;
    }

    public static List<List<Coord>> areaToShapes(java.awt.geom.Area area) {
        return Java2DConverter.areaToShapes(area, null);
    }

    public static List<List<Coord>> areaToShapes(java.awt.geom.Area area, Long2ObjectOpenHashMap<Coord> coordPool) {
        ArrayList<List<Coord>> outputs = new ArrayList<List<Coord>>(4);
        double[] res = new double[6];
        PathIterator pit = area.getPathIterator(null);
        ArrayList<Coord> coords = null;
        int prevLatHp = Integer.MIN_VALUE;
        int prevLongHp = Integer.MIN_VALUE;
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            int latHp = (int)Math.round(res[1] * 64.0);
            int lonHp = (int)Math.round(res[0] * 64.0);
            switch (type) {
                case 1: {
                    if (prevLatHp != latHp || prevLongHp != lonHp) {
                        coords.add(Coord.makeHighPrecCoord(latHp, lonHp, coordPool));
                    }
                    prevLatHp = latHp;
                    prevLongHp = lonHp;
                    break;
                }
                case 0: 
                case 4: {
                    if (type == 0 && coords != null || type == 4) {
                        if (coords.size() > 2) {
                            if (((Coord)coords.get(0)).highPrecEquals((Coord)coords.get(coords.size() - 1))) {
                                coords.set(coords.size() - 1, (Coord)coords.get(0));
                            } else {
                                coords.add((Coord)coords.get(0));
                            }
                        }
                        if (coords.size() > 3) {
                            outputs.add(coords);
                        }
                    }
                    if (type == 0) {
                        coords = new ArrayList<Coord>();
                        coords.add(Coord.makeHighPrecCoord(latHp, lonHp, coordPool));
                        prevLatHp = latHp;
                        prevLongHp = lonHp;
                        break;
                    }
                    coords = null;
                    prevLatHp = Integer.MIN_VALUE;
                    prevLongHp = Integer.MIN_VALUE;
                    break;
                }
                default: {
                    log.error((Object)("Unsupported path iterator type " + type + ". This is an mkgmap error."));
                }
            }
            pit.next();
        }
        return outputs;
    }

    public static java.awt.geom.Area AreaDegreesToMapUnit(java.awt.geom.Area area) {
        if (area == null) {
            return null;
        }
        double[] res = new double[6];
        Path2D.Double path = new Path2D.Double();
        PathIterator pit = area.getPathIterator(null);
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            double fLat = res[1];
            double fLon = res[0];
            int lat = Utils.toMapUnit(fLat);
            int lon = Utils.toMapUnit(fLon);
            switch (type) {
                case 1: {
                    ((Path2D)path).lineTo(lon, lat);
                    break;
                }
                case 0: {
                    ((Path2D)path).moveTo(lon, lat);
                    break;
                }
                case 4: {
                    path.closePath();
                    break;
                }
                default: {
                    System.out.println("Unsupported path iterator type " + type + ". This is an internal splitter error.");
                }
            }
            pit.next();
        }
        return new java.awt.geom.Area(path);
    }

    public static java.awt.geom.Area readPolyFile(String polygonFile) {
        File f = new File(polygonFile);
        if (!f.exists()) {
            throw new IllegalArgumentException("polygon file doesn't exist: " + polygonFile);
        }
        try {
            PolygonFileReader pfr = new PolygonFileReader(f);
            java.awt.geom.Area polygonInDegrees = pfr.loadPolygon();
            return Java2DConverter.AreaDegreesToMapUnit(polygonInDegrees);
        }
        catch (Exception e) {
            log.error("cannot read polygon file", polygonFile);
            log.error((Object)e);
            return null;
        }
    }
}

