/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.scan;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokType;
import uk.me.parabola.mkgmap.scan.Token;
import uk.me.parabola.mkgmap.scan.WordInfo;

public class TokenScanner {
    private static final int NO_PUSHBACK = 0;
    private String charset = "utf-8";
    private final Reader reader;
    private int pushback = 0;
    private boolean isEOF;
    private final String fileName;
    private int linenumber;
    private final LinkedList<Token> tokens = new LinkedList();
    private boolean bol = true;
    private String extraWordChars = "";
    private String commentChar = "#";

    public TokenScanner(String filename, Reader reader) {
        this.reader = reader instanceof BufferedReader ? reader : new BufferedReader(reader);
        this.fileName = filename;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Token peekToken() {
        this.ensureTok();
        return this.tokens.peek();
    }

    public Token nextRawToken() {
        Token token;
        this.ensureTok();
        if (this.bol) {
            this.bol = false;
            ++this.linenumber;
        }
        if ((token = this.tokens.removeFirst()).getType() == TokType.EOL) {
            this.bol = true;
        }
        return token;
    }

    public Token nextToken() {
        this.skipSpace();
        return this.nextRawToken();
    }

    public void pushToken(Token tok) {
        this.tokens.push(tok);
    }

    public String nextValue() {
        this.skipSpace();
        return this.nextRawToken().getValue();
    }

    public boolean isEndOfFile() {
        this.ensureTok();
        if (this.tokens.isEmpty()) {
            return this.isEOF;
        }
        return this.tokens.peek().getType() == TokType.EOF;
    }

    public void skipSpace() {
        while (!this.isEndOfFile()) {
            if (this.tokens.peek().isValue(this.commentChar)) {
                this.skipLine();
                continue;
            }
            if (!this.tokens.peek().isWhiteSpace()) break;
            this.nextRawToken();
        }
    }

    public void skipLine() {
        Token t;
        while (!this.isEndOfFile() && (t = this.nextRawToken()).getType() != TokType.EOL) {
        }
    }

    private void ensureTok() {
        if (this.tokens.isEmpty()) {
            this.fillTok();
        }
    }

    private void fillTok() {
        Token t = this.readTok();
        this.tokens.add(t);
    }

    private Token readTok() {
        TokType tt;
        if (this.isEOF) {
            return new Token(TokType.EOF);
        }
        int c = this.readChar();
        if (c == -1) {
            this.isEOF = true;
            return new Token(TokType.EOF);
        }
        StringBuilder val = new StringBuilder();
        val.append((char)c);
        if (c == 13) {
            c = this.readChar();
            if (c != 10) {
                this.pushback = c;
            }
            tt = TokType.EOL;
        } else if (c == 10) {
            tt = TokType.EOL;
        } else if (this.isSpace(c)) {
            while (this.isSpace(c = this.readChar()) && c != 10) {
                val.append((char)c);
            }
            this.pushback = c;
            tt = TokType.SPACE;
        } else if (this.isWordChar(c)) {
            while (this.isWordChar(c = this.readChar())) {
                val.append((char)c);
            }
            this.pushback = c;
            tt = TokType.TEXT;
        } else {
            if (c == 33 || c == 60 || c == 62) {
                c = this.readChar();
                if (c == 61) {
                    val.append('=');
                } else {
                    this.pushback = c;
                }
            } else if (c == 38 || c == 124) {
                int c2 = this.readChar();
                if (c2 == c) {
                    val.append((char)c2);
                } else {
                    this.pushback = c2;
                }
            }
            tt = TokType.SYMBOL;
        }
        Token t = new Token(tt);
        t.setValue(val.toString());
        return t;
    }

    private int readChar() {
        int c;
        if (this.pushback != 0) {
            int c2 = this.pushback;
            this.pushback = 0;
            return c2;
        }
        try {
            c = this.reader.read();
            if (c == 65533) {
                throw new SyntaxException(this, "Bad character in input, file probably not in " + this.charset);
            }
        }
        catch (IOException e) {
            this.isEOF = true;
            c = -1;
        }
        return c;
    }

    private boolean isSpace(int nextch) {
        return Character.isWhitespace(nextch) || nextch == 65279;
    }

    private boolean isWordChar(int ch) {
        return Character.isLetterOrDigit(ch) || ch == 95 || this.extraWordChars.indexOf(ch) >= 0;
    }

    public String readLine() {
        String res = this.readUntil(TokType.EOL, null);
        this.nextRawToken();
        return res;
    }

    public String readUntil(TokType type, String value) {
        Token t;
        StringBuilder sb = new StringBuilder();
        while (!this.isEndOfFile() && ((t = this.peekToken()).getType() != type || value != null && !value.equals(t.getValue()))) {
            sb.append(this.nextRawToken().getValue());
        }
        return sb.toString().trim();
    }

    public int nextInt() throws NumberFormatException {
        this.skipSpace();
        Token t = this.nextRawToken();
        if (t == null) {
            throw new NumberFormatException("no number");
        }
        return Integer.parseInt(t.getValue());
    }

    public String nextWord() {
        WordInfo info = this.nextWordWithInfo();
        return info.getText();
    }

    public WordInfo nextWordWithInfo() {
        String s;
        this.skipSpace();
        Token tok = this.peekToken();
        char quotec = '\u0000';
        if (tok.getType() == TokType.SYMBOL && ("'".equals(s = tok.getValue()) || "\"".equals(s))) {
            quotec = s.charAt(0);
            this.nextRawToken();
        }
        StringBuilder sb = new StringBuilder();
        while (!this.isEndOfFile()) {
            tok = this.nextRawToken();
            if (quotec == '\u0000') {
                sb.append(tok.getValue());
                break;
            }
            if (tok.isValue(String.valueOf(quotec))) break;
            sb.append(tok.getValue());
        }
        this.skipSpace();
        return new WordInfo(sb.toString(), quotec != '\u0000');
    }

    public boolean checkToken(String val) {
        this.skipSpace();
        Token tok = this.peekToken();
        if (val == null || tok.getValue() == null) {
            return false;
        }
        return val.equals(tok.getValue());
    }

    public void validateNext(String val) {
        this.skipSpace();
        Token tok = this.nextToken();
        if (val == null || !val.equals(tok.getValue())) {
            throw new SyntaxException(this, "Expecting " + val + ", instead saw " + tok.getValue());
        }
    }

    public int getLinenumber() {
        return this.linenumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setExtraWordChars(String extraWordChars) {
        this.extraWordChars = extraWordChars;
    }

    public void setCommentChar(String commentChar) {
        this.commentChar = commentChar == null ? "" : commentChar;
    }
}

