/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.osmstyle.StyleImpl;
import uk.me.parabola.mkgmap.osmstyle.StyledConverter;
import uk.me.parabola.mkgmap.reader.MapperBasedMapDataSource;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.HighwayHooks;
import uk.me.parabola.mkgmap.reader.osm.HousenumberHooks;
import uk.me.parabola.mkgmap.reader.osm.LinkDestinationHook;
import uk.me.parabola.mkgmap.reader.osm.LocationHook;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonFinishHook;
import uk.me.parabola.mkgmap.reader.osm.OsmConverter;
import uk.me.parabola.mkgmap.reader.osm.OsmHandler;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooksChain;
import uk.me.parabola.mkgmap.reader.osm.POIGeneratorHook;
import uk.me.parabola.mkgmap.reader.osm.RelationStyleHook;
import uk.me.parabola.mkgmap.reader.osm.ResidentialHook;
import uk.me.parabola.mkgmap.reader.osm.RoutingHook;
import uk.me.parabola.mkgmap.reader.osm.SeaGenerator;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.UnusedElementsRemoverHook;
import uk.me.parabola.mkgmap.reader.osm.bin.OsmBinHandler;
import uk.me.parabola.mkgmap.reader.osm.o5m.O5mBinHandler;
import uk.me.parabola.mkgmap.reader.osm.xml.OsmXmlHandler;
import uk.me.parabola.util.EnhancedProperties;

public class OsmMapDataSource
extends MapperBasedMapDataSource
implements LoadableMapDataSource {
    private static final Logger log = Logger.getLogger(OsmMapDataSource.class);
    private Style style;
    private final OsmReadingHooks[] POSSIBLE_HOOKS = new OsmReadingHooks[]{new SeaGenerator(), new MultiPolygonFinishHook(), new RelationStyleHook(), new LinkDestinationHook(), new UnusedElementsRemoverHook(), new RoutingHook(), new HighwayHooks(), new LocationHook(), new POIGeneratorHook(), new ResidentialHook(), new HousenumberHooks()};
    protected OsmConverter converter;
    private final Set<String> usedTags = new HashSet<String>();
    protected ElementSaver elementSaver;
    protected OsmReadingHooks osmReadingHooks;
    protected static final List<OsmHandler> handlers = new ArrayList<OsmHandler>();

    @Override
    public LevelInfo[] mapLevels() {
        String levelSpec = this.getLevelSpec("levels");
        if (levelSpec == null) {
            levelSpec = "0:24, 1:22, 2:20, 3:18, 4:16";
        }
        return LevelInfo.createFromString(levelSpec);
    }

    @Override
    public LevelInfo[] overviewMapLevels() {
        String levelSpec = this.getLevelSpec("overview-levels");
        if (levelSpec == null) {
            return null;
        }
        LevelInfo[] levels = LevelInfo.createFromString(levelSpec);
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = new LevelInfo(levels.length - i - 1, levels[i].getBits());
        }
        return levels;
    }

    private String getLevelSpec(String optionName) {
        String levelSpec = this.getConfig().getProperty(optionName);
        log.debug(optionName, levelSpec, ", ", levelSpec != null ? Integer.valueOf(levelSpec.length()) : "");
        if ((levelSpec == null || levelSpec.length() < 2) && this.style != null) {
            levelSpec = this.style.getOption(optionName);
            log.debug("getting " + optionName + " from style:", levelSpec);
        }
        return levelSpec;
    }

    @Override
    public void load(String name, boolean addBackground) throws FileNotFoundException {
        try (InputStream is = Utils.openFile(name);){
            this.parse(is, name);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.elementSaver.finishLoading();
        this.osmReadingHooks.end();
        this.osmReadingHooks = null;
        this.elementSaver.convert(this.getConverter());
        if (addBackground) {
            this.addBackground();
        }
    }

    protected void parse(InputStream is, String name) {
        for (OsmHandler h : handlers) {
            if (!h.isFileSupported(name)) continue;
            try {
                OsmHandler handler = (OsmHandler)h.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.setupHandler(handler);
                handler.parse(is);
                break;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error((Object)"Unexpected error", e);
            }
        }
    }

    @Override
    public String[] copyrightMessages() {
        String copyrightFileName = this.getConfig().getProperty("copyright-file", null);
        if (copyrightFileName != null) {
            return OsmMapDataSource.readCopyrightFile(copyrightFileName);
        }
        String note = this.getConfig().getProperty("copyright-message", "OpenStreetMap.org contributors. See: http://wiki.openstreetmap.org/index.php/Attribution");
        return new String[]{note};
    }

    protected void setStyle(Style style) {
        this.style = style;
    }

    protected void setupHandler(OsmHandler handler) {
        this.createElementSaver();
        this.createConverter();
        handler.setIgnoreBounds(this.getConfig().getProperty("ignore-osm-bounds", false));
        this.osmReadingHooks = this.pluginChain(this.elementSaver, this.getConfig());
        handler.setElementSaver(this.elementSaver);
        handler.setHooks(this.osmReadingHooks);
        handler.setUsedTags(this.getUsedTags());
        String deleteTagsFileName = this.getConfig().getProperty("delete-tags-file");
        if (deleteTagsFileName != null) {
            Map<String, Set<String>> deltags = OsmMapDataSource.readDeleteTagsFile(deleteTagsFileName);
            handler.setTagsToDelete(deltags);
        }
        if (this.getConfig().getProperty("ignore-fixme-values", false)) {
            handler.setDeleteFixmeValues(true);
        }
        if (this.getConfig().getProperty("keep-empty-value-tags", false)) {
            handler.setDeleteEmptyValueTag(false);
        }
    }

    protected void createElementSaver() {
        this.elementSaver = new ElementSaver(this.getConfig());
    }

    public ElementSaver getElementSaver() {
        return this.elementSaver;
    }

    protected OsmReadingHooks[] getPossibleHooks() {
        return this.POSSIBLE_HOOKS;
    }

    protected OsmReadingHooks pluginChain(ElementSaver saver, EnhancedProperties props) {
        OsmReadingHooks hooks;
        ArrayList<OsmReadingHooks> plugins = new ArrayList<OsmReadingHooks>();
        for (OsmReadingHooks p : this.getPossibleHooks()) {
            if (p instanceof ResidentialHook && this.style != null && !this.style.getUsedTags().contains("mkgmap:residential") || !p.init(saver, props, this.style)) continue;
            plugins.add(p);
        }
        switch (plugins.size()) {
            case 0: {
                hooks = new NullHook();
                break;
            }
            case 1: {
                hooks = (OsmReadingHooks)plugins.get(0);
                break;
            }
            default: {
                OsmReadingHooksChain chain = new OsmReadingHooksChain();
                for (OsmReadingHooks p : plugins) {
                    chain.add(p);
                }
                hooks = chain;
            }
        }
        this.usedTags.addAll(hooks.getUsedTags());
        return hooks;
    }

    private static Map<String, Set<String>> readDeleteTagsFile(String fileName) {
        HashMap<String, Set<String>> deletedTags = new HashMap<String, Set<String>>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '\ufeff' && (line = line.substring(1)).isEmpty() || line.startsWith("#") || line.startsWith(";")) continue;
                String[] parts = line.split("=");
                if (parts.length == 2) {
                    parts[0] = parts[0].trim();
                    parts[1] = parts[1].trim();
                    if ("*".equals(parts[1])) {
                        deletedTags.put(parts[0], new HashSet());
                        continue;
                    }
                    deletedTags.computeIfAbsent(parts[0], k -> new HashSet()).add(parts[1]);
                    continue;
                }
                log.error((Object)("Ignoring bad line in deleted tags file: " + line));
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Could not open delete tags file " + fileName));
        }
        catch (IOException e) {
            log.error((Object)("Error reading delete tags file " + fileName));
        }
        if (deletedTags.isEmpty()) {
            deletedTags = null;
        }
        return deletedTags;
    }

    protected void createConverter() {
        EnhancedProperties props = this.getConfig();
        this.setStyle(StyleImpl.readStyle(props));
        this.usedTags.addAll(this.style.getUsedTags());
        this.style.getUsedTags().stream().filter(s -> s.startsWith("mkgmap:from-node:")).map(s -> s.substring("mkgmap:from-node:".length())).forEach(this.usedTags::add);
        this.usedTags.addAll(CommandArgs.getNameTags(props));
        this.converter = new StyledConverter(this.style, this.mapper, props);
    }

    public OsmConverter getConverter() {
        return this.converter;
    }

    public Set<String> getUsedTags() {
        return this.usedTags;
    }

    @Override
    public Boolean getDriveOnLeft() {
        return this.converter.getDriveOnLeft();
    }

    @Override
    public boolean isFileSupported(String name) {
        return true;
    }

    @Override
    public int getPoiDispFlag() {
        return 0;
    }

    static {
        handlers.add(new OsmBinHandler());
        handlers.add(new O5mBinHandler());
        handlers.add(new OsmXmlHandler());
    }

    private class NullHook
    implements OsmReadingHooks {
        private NullHook() {
        }
    }
}

