/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.Way;

public abstract class OsmHandler {
    protected ElementSaver saver;
    protected OsmReadingHooks hooks;
    private Map<String, Set<String>> deletedTags;
    private Map<String, String> usedTags;
    private static final Pattern FIXME_PATTERN = Pattern.compile("(?i)fix[ _]?+me");
    private boolean removeFixme;
    private boolean ignoreBounds;
    private long firstNodeRef;
    private long lastNodeRef;
    private boolean missingNodeRef;
    private boolean removeEmptyValue = true;

    public void setTagsToDelete(Map<String, Set<String>> deletedTags) {
        this.deletedTags = deletedTags;
    }

    public void setUsedTags(Set<String> used) {
        if (used == null || used.isEmpty()) {
            this.usedTags = null;
            return;
        }
        this.usedTags = new HashMap<String, String>();
        for (String s : used) {
            if (s == null) continue;
            s = s.intern();
            this.usedTags.put(s, s);
        }
    }

    protected String keepTag(String key, String val) {
        Set<String> vals;
        if (this.removeEmptyValue && val.isEmpty()) {
            return null;
        }
        if (this.deletedTags != null && (vals = this.deletedTags.get(key)) != null && (vals.isEmpty() || vals.contains(val))) {
            return null;
        }
        if (this.usedTags != null) {
            key = this.usedTags.get(key);
        }
        if (key != null && this.removeFixme && val.length() >= 5 && !"fixme".equals(key) && !"FIXME".equals(key) && FIXME_PATTERN.matcher(val).matches()) {
            return null;
        }
        return key;
    }

    protected void setBBox(double minlat, double minlong, double maxlat, double maxlong) {
        if (minlat == maxlat || minlong == maxlong) {
            return;
        }
        Area bbox = new Area(minlat, minlong, maxlat, maxlong);
        this.saver.setBoundingBox(bbox);
    }

    public void setElementSaver(ElementSaver elementSaver) {
        this.saver = elementSaver;
    }

    public void setHooks(OsmReadingHooks plugin) {
        this.hooks = plugin;
    }

    protected Way startWay(long id) {
        this.firstNodeRef = 0L;
        this.lastNodeRef = 0L;
        this.missingNodeRef = false;
        return new Way(id);
    }

    protected final void endWay(Way way) {
        way.setClosedInOSM(this.firstNodeRef == this.lastNodeRef);
        way.setComplete(!this.missingNodeRef);
        this.saver.addWay(way);
        this.hooks.onAddWay(way);
    }

    protected final void addCoordToWay(Way way, long id) {
        Coord co;
        this.lastNodeRef = id;
        if (this.firstNodeRef == 0L) {
            this.firstNodeRef = id;
        }
        if ((co = this.saver.getCoord(id)) != null) {
            Node node = this.saver.getNode(id);
            if (node != null && node.getTagCount() > 0) {
                this.hooks.onNodeAddedToWay(way, id);
                co = this.saver.getCoord(id);
                if (co == null) {
                    throw new ExitException("Internal error: hooks removed coord with id " + id);
                }
            }
            way.addPoint(co);
        } else {
            this.missingNodeRef = true;
        }
    }

    public void setDeleteFixmeValues(boolean b) {
        this.removeFixme = b;
    }

    public void setDeleteEmptyValueTag(boolean b) {
        this.removeEmptyValue = b;
    }

    public boolean isIgnoreBounds() {
        return this.ignoreBounds;
    }

    public void setIgnoreBounds(boolean ignoreBounds) {
        this.ignoreBounds = ignoreBounds;
    }

    public abstract boolean isFileSupported(String var1);

    public abstract void parse(InputStream var1) throws FormatException;
}

