/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.Arrays;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;

public class MultiPolygonFinishHook
implements OsmReadingHooks {
    private static final Logger log = Logger.getLogger(MultiPolygonFinishHook.class);
    private ElementSaver saver;

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props, Style style) {
        this.saver = saver;
        return true;
    }

    @Override
    public void end() {
        long t1 = System.currentTimeMillis();
        log.info((Object)"Finishing multipolygons");
        for (Way way : this.saver.getWays().values()) {
            String removeTag = way.getTag(ElementSaver.TKM_REMOVETAGS);
            if (removeTag == null) continue;
            Object[] tagsToRemove = removeTag.split(";");
            if (log.isDebugEnabled()) {
                log.debug("Remove tags", Arrays.toString(tagsToRemove), "from way", way.getId(), way.toTagString());
            }
            way.deleteTag(ElementSaver.TKM_REMOVETAGS);
            for (Object rTag : tagsToRemove) {
                way.deleteTag((String)rTag);
            }
        }
        log.info((Object)("Multipolygon hook finished in " + (System.currentTimeMillis() - t1) + " ms"));
    }
}

