/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.Collections;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.Way;

public abstract class Element {
    private static final Logger log = Logger.getLogger(Element.class);
    private static final byte TYPE_NODE = 1;
    private static final byte TYPE_WAY = 2;
    private static final byte TYPE_RELATION = 3;
    private Tags tags;
    private long id;
    private long originalId;
    private byte origType;

    public Tags getCopyOfTags() {
        return this.tags == null ? new Tags() : this.tags.copy();
    }

    public int getTagCount() {
        return this.tags == null ? 0 : this.tags.size();
    }

    public void addTagFromRawOSM(String key, String val) {
        if (val == null) {
            return;
        }
        if (!(val = val.trim()).isEmpty()) {
            String squashed = Label.squashSpaces(val);
            if (!val.equals(squashed)) {
                if (log.isInfoEnabled()) {
                    log.info(this.toBrowseURL(), "obsolete blanks removed from tag", key, "'" + val + "' -> '" + squashed + "'");
                }
                val = squashed;
            }
            if (!val.equals(squashed = Label.squashDel(val))) {
                if (log.isInfoEnabled()) {
                    log.info(this.toBrowseURL(), "DEL character (0x7f) removed from tag", key, "'" + val + "' -> '" + squashed + "'");
                }
                val = squashed;
            }
        }
        this.addTag(key, val.intern());
    }

    public void addTag(String key, String val) {
        if (this.tags == null) {
            this.tags = new Tags();
        }
        this.tags.put(key, val);
    }

    public void addTag(short tagKey, String val) {
        if (this.tags == null) {
            this.tags = new Tags();
        }
        this.tags.put(tagKey, val);
    }

    public String getTag(String key) {
        if (this.tags == null) {
            return null;
        }
        return this.tags.get(key);
    }

    public String getTag(short tagKey) {
        if (this.tags == null) {
            return null;
        }
        return this.tags.get(tagKey);
    }

    public String deleteTag(String tagname) {
        String old = null;
        if (this.tags != null) {
            old = this.tags.remove(tagname);
            if (this.tags.size() == 0) {
                this.tags = null;
            }
        }
        return old;
    }

    public String deleteTag(short tagKey) {
        String old = null;
        if (this.tags != null) {
            old = this.tags.remove(tagKey);
            if (this.tags.size() == 0) {
                this.tags = null;
            }
        }
        return old;
    }

    public boolean tagIsLikeYes(String s) {
        return this.tagIsLikeYes(TagDict.getInstance().xlate(s));
    }

    public boolean tagIsLikeYes(short tagKey) {
        String val = this.getTag(tagKey);
        return val != null && ("yes".equals(val) || "true".equals(val) || "1".equals(val));
    }

    public boolean tagIsLikeNo(String s) {
        return this.tagIsLikeNo(TagDict.getInstance().xlate(s));
    }

    public boolean tagIsLikeNo(short tagKey) {
        String val = this.getTag(tagKey);
        return val != null && ("no".equals(val) || "false".equals(val) || "0".equals(val));
    }

    public long getId() {
        return this.id;
    }

    public long getOriginalId() {
        return this.originalId;
    }

    protected void setId(long id) {
        this.id = id;
        this.originalId = id;
    }

    public void markAsGeneratedFrom(Element orig) {
        this.id = FakeIdGenerator.makeFakeId();
        this.origType = Element.elementToType(orig);
    }

    private static byte elementToType(Element orig) {
        if (orig instanceof Node) {
            return 1;
        }
        if (orig instanceof Way) {
            return 2;
        }
        if (orig instanceof Relation) {
            return 3;
        }
        throw new IllegalArgumentException("invalid type");
    }

    public String getOrigElement() {
        switch (this.origType) {
            case 1: {
                return "node";
            }
            case 2: {
                return "way";
            }
            case 3: {
                return "relation";
            }
        }
        throw new IllegalArgumentException("invalid type");
    }

    public String toTagString() {
        if (this.tags == null) {
            return "[]";
        }
        return this.tags.toString();
    }

    public void copyTags(Element other) {
        this.tags = other.tags == null ? null : other.tags.copy();
    }

    protected void copyIds(Element other) {
        this.id = other.id;
        this.originalId = other.originalId;
        this.origType = other.origType;
    }

    public String getName() {
        return this.getTag("mkgmap:label:1");
    }

    public Map<String, String> getTagsWithPrefix(String prefix, boolean removePrefix) {
        if (this.tags == null) {
            return Collections.emptyMap();
        }
        return this.tags.getTagsWithPrefix(prefix, removePrefix);
    }

    public void removeAllTags() {
        this.tags = null;
    }

    public Iterable<Map.Entry<String, String>> getTagEntryIterator() {
        return () -> this.tags == null ? Collections.emptyIterator() : this.tags.entryIterator();
    }

    public Iterable<Map.Entry<Short, String>> getFastTagEntryIterator() {
        return () -> this.tags == null ? Collections.emptyIterator() : this.tags.entryShortIterator();
    }

    protected String kind() {
        return "unknown";
    }

    public String toBrowseURL() {
        if (FakeIdGenerator.isFakeId(this.id)) {
            return this.getBasicLogInformation();
        }
        return "http://www.openstreetmap.org/" + this.kind() + "/" + this.id;
    }

    public Element copy() {
        throw new UnsupportedOperationException("unsupported element copy");
    }

    public String getDebugName() {
        String name = this.getName();
        if (name == null) {
            name = this.getTag("ref");
        }
        name = name == null ? "" : name + " ";
        return name + "(OSM id " + this.originalId + ")";
    }

    public String getBasicLogInformation() {
        String className = this.getClass().getSimpleName();
        if ("GeneralRelation".equals(className)) {
            className = "Relation";
        }
        if (FakeIdGenerator.isFakeId(this.originalId)) {
            return "generated " + className;
        }
        return className + (FakeIdGenerator.isFakeId(this.id) ? " generated from " + this.getOrigElement() : "") + " " + this.originalId;
    }

    public String toString() {
        return this.getBasicLogInformation();
    }
}

