/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.eval;

import java.util.regex.Pattern;
import uk.me.parabola.mkgmap.osmstyle.eval.AbstractBinaryOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NodeType;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.reader.osm.Element;

public class RegexOp
extends AbstractBinaryOp {
    private Pattern pattern;

    public RegexOp() {
        this.setType(NodeType.REGEX);
    }

    @Override
    public boolean eval(Element el) {
        String tagval = this.first.value(el);
        if (tagval == null) {
            return false;
        }
        return this.pattern.matcher(tagval).matches();
    }

    @Override
    public int priority() {
        return 10;
    }

    @Override
    public void setSecond(Op second) {
        assert (second.isType(NodeType.VALUE));
        super.setSecond(second);
        this.pattern = Pattern.compile(second.getKeyValue());
    }

    @Override
    public String toString() {
        return this.getFirst() + "~" + this.getSecond();
    }
}

