/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import uk.me.parabola.mkgmap.osmstyle.actions.ValueFilter;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.scan.SyntaxException;

public class SubstringFilter
extends ValueFilter {
    private int args;
    private int start;
    private int end;

    public SubstringFilter(String arg) {
        block5: {
            this.start = 0;
            this.end = 0;
            this.args = 0;
            String[] temp = arg.split(":");
            try {
                if (temp.length == 1) {
                    this.start = Integer.parseInt(temp[0]);
                    this.args = 1;
                    break block5;
                }
                if (temp.length == 2) {
                    this.start = Integer.parseInt(temp[0]);
                    this.end = Integer.parseInt(temp[1]);
                    this.args = 2;
                    break block5;
                }
                throw new SyntaxException(String.format("invalid argunemt for style substring command: '%s'", arg));
            }
            catch (NumberFormatException e) {
                throw new SyntaxException(String.format("Numbers not valid in style substring command: '%s'", arg));
            }
        }
        if (this.args == 2 && this.start > this.end) {
            throw new SyntaxException(String.format("start > end in style substring command: '%s'", arg));
        }
    }

    @Override
    protected String doFilter(String value, Element el) {
        if (value == null) {
            return null;
        }
        if (this.start > value.length()) {
            return null;
        }
        int codePointStart = 0;
        if (this.start > 0) {
            try {
                codePointStart = value.offsetByCodePoints(0, this.start);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        if (this.args == 1 || this.end > value.length()) {
            return value.substring(codePointStart);
        }
        if (this.args == 2) {
            int codePointEnd = 0;
            try {
                codePointEnd = value.offsetByCodePoints(this.start, this.end - this.start);
            }
            catch (IndexOutOfBoundsException e) {
                return value.substring(codePointStart);
            }
            return value.substring(codePointStart, codePointEnd);
        }
        return value;
    }
}

