/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.parabola.mkgmap.osmstyle.actions.ValueFilter;
import uk.me.parabola.mkgmap.reader.osm.Element;

public class SubstitutionFilter
extends ValueFilter {
    private final String from;
    private final String to;
    private boolean isRegexp = false;
    private final Pattern pattern;

    public SubstitutionFilter(String arg) {
        int i = arg.indexOf("=>");
        if (i == -1 && (i = arg.indexOf("~>")) >= 0) {
            this.isRegexp = true;
        }
        if (i >= 0) {
            this.from = arg.substring(0, i);
            this.to = arg.substring(i + 2);
        } else {
            this.from = arg;
            this.to = "";
        }
        this.pattern = this.isRegexp ? Pattern.compile(this.from) : Pattern.compile(this.from, 16);
    }

    @Override
    public String doFilter(String value, Element el) {
        if (value == null) {
            return null;
        }
        return this.pattern.matcher(value).replaceAll(this.isRegexp ? this.to : Matcher.quoteReplacement(this.to));
    }
}

