/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.main.MapProcessor;

class TypSaver
implements MapProcessor {
    TypSaver() {
    }

    @Override
    public String makeMap(CommandArgs args, String filename) {
        String outfilename = filename;
        int familyId = args.get("family-id", 6324);
        int productId = args.get("product-id", 1);
        try (FileInputStream in = new FileInputStream(filename);){
            byte[] buf = new byte[256];
            int n = in.read(buf);
            if (n == -1) {
                throw new ExitException("TYP file is empty: " + filename);
            }
            ByteBuffer buffer = ByteBuffer.wrap(buf);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            char foundFamily = buffer.getChar(47);
            char foundProduct = buffer.getChar(49);
            if (familyId != foundFamily || productId != foundProduct) {
                buffer.putChar(47, (char)familyId);
                buffer.putChar(49, (char)productId);
                outfilename = TypSaver.makeOutName(filename);
                TypSaver.writeAlteredTyp(outfilename, in, buf, n);
            }
        }
        catch (IOException e) {
            throw new ExitException("TYP file cannot be opened or read: " + filename);
        }
        return outfilename;
    }

    private static void writeAlteredTyp(String outFilename, FileInputStream in, byte[] buf, int n) {
        try (FileOutputStream out = new FileOutputStream(outFilename);){
            do {
                out.write(buf, 0, n);
            } while ((n = in.read(buf)) > 0);
        }
        catch (IOException e) {
            throw new ExitException("Could not write temporary TYP file: " + outFilename);
        }
    }

    private static String makeOutName(String path) {
        File f = new File(path);
        File dir = f.getParentFile();
        String name = f.getName();
        File out = new File(dir, "x" + name);
        return out.getPath();
    }
}

