/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.reader.osm.GType;

public class RoundCoordsFilter
implements MapFilter {
    private int shift;
    private boolean keepNodes;
    private int level;

    @Override
    public void init(FilterConfig config) {
        this.shift = config.getShift();
        this.level = config.getLevel();
        this.keepNodes = this.level == 0 && config.hasNet();
    }

    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        if (this.shift == 0) {
            next.doFilter(element);
        } else {
            MapLine line = (MapLine)element;
            int full = 1 << this.shift;
            int half = 1 << this.shift - 1;
            int mask = ~((1 << this.shift) - 1);
            ArrayList<Coord> newPoints = new ArrayList<Coord>(line.getPoints().size());
            List<Coord> coords = line.getPoints();
            int endIndex = coords.size() - 1;
            Coord lastP = null;
            boolean hasNumbers = this.keepNodes && line.isRoad() && ((MapRoad)line).getRoadDef().hasHouseNumbers();
            boolean isContourLine = GType.isContourLine(line);
            for (int i = 0; i <= endIndex; ++i) {
                Coord newP;
                boolean keepNumberNode;
                Coord p = coords.get(i);
                if (!this.keepNodes && p.isAddedNumberNode()) continue;
                boolean bl = keepNumberNode = hasNumbers && p.isNumberNode();
                if (p instanceof CoordNode && this.keepNodes) {
                    int lat = p.getLatitude() + half & mask;
                    int lon = p.getLongitude() + half & mask;
                    newP = new CoordNode(lat, lon, p.getId(), p.getOnBoundary(), p.getOnCountryBorder());
                    newP.preserved(true);
                } else if (!isContourLine || i == 0 || i == endIndex) {
                    int lat = p.getLatitude() + half & mask;
                    int lon = p.getLongitude() + half & mask;
                    newP = new Coord(lat, lon);
                    newP.setNumberNode(keepNumberNode);
                    newP.preserved(p.preserved() || keepNumberNode);
                } else {
                    Coord a = coords.get(i - 1);
                    Coord b = coords.get(i + 1);
                    int lat = p.getLatitude() & mask;
                    int lon = p.getLongitude() & mask;
                    newP = new Coord(lat, lon);
                    double minDistortion = RoundCoordsFilter.calcDistortion(newP, a, p, b);
                    lon = p.getLongitude() + full & mask;
                    Coord testP = new Coord(lat, lon);
                    double testDistortion = RoundCoordsFilter.calcDistortion(testP, a, p, b);
                    if (testDistortion < minDistortion) {
                        minDistortion = testDistortion;
                        newP = testP;
                    }
                    if ((testDistortion = RoundCoordsFilter.calcDistortion(testP = new Coord(lat = p.getLatitude() + full & mask, lon), a, p, b)) < minDistortion) {
                        minDistortion = testDistortion;
                        newP = testP;
                    }
                    if ((testDistortion = RoundCoordsFilter.calcDistortion(testP = new Coord(lat, lon = p.getLongitude() & mask), a, p, b)) < minDistortion) {
                        newP = testP;
                    }
                    newP.setNumberNode(keepNumberNode);
                    newP.preserved(p.preserved() || keepNumberNode);
                }
                if (lastP == null || !lastP.equals(newP) || newP.getId() > 0 || hasNumbers && newP.isNumberNode()) {
                    newPoints.add(newP);
                    lastP = newP;
                    continue;
                }
                if (!newP.preserved()) continue;
                lastP.preserved(true);
            }
            if (newPoints.size() > 1) {
                MapLine newLine = line.copy();
                newLine.setPoints(newPoints);
                next.doFilter(newLine);
            }
        }
    }

    private static double calcDistortion(Coord roundedMid, Coord before, Coord mid, Coord after) {
        return roundedMid.shortestDistToLineSegment(before, mid) + roundedMid.shortestDistToLineSegment(mid, after);
    }
}

