/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.filters.MustSplitException;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.util.ShapeSplitter;

public class PolygonSplitterFilter
implements MapFilter {
    private static final Logger log = Logger.getLogger(PolygonSplitterFilter.class);
    public static final int MAX_POINT_IN_ELEMENT = 250;
    private int shift;

    @Override
    public void init(FilterConfig config) {
        this.shift = config.getShift();
    }

    private void split(MapShape shape, List<MapShape> outputs) {
        Area[] tmpAreas;
        int dividingLine = 0;
        boolean isLongitude = false;
        Area bounds = shape.getBounds();
        if (bounds.getWidth() > bounds.getHeight()) {
            isLongitude = true;
            tmpAreas = bounds.split(2, 1, this.shift);
            dividingLine = tmpAreas != null ? tmpAreas[0].getMaxLong() : bounds.getMinLong() + bounds.getWidth() / 2;
        } else {
            tmpAreas = bounds.split(1, 2, this.shift);
            dividingLine = tmpAreas != null ? tmpAreas[0].getMaxLat() : bounds.getMinLat() + bounds.getHeight() / 2;
        }
        ArrayList<List<Coord>> subShapePoints = new ArrayList<List<Coord>>();
        ShapeSplitter.splitShape(shape.getPoints(), dividingLine << 6, isLongitude, subShapePoints, subShapePoints, null);
        for (List list : subShapePoints) {
            MapShape s = shape.copy();
            s.setPoints(list);
            outputs.add(s);
        }
    }

    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        MapShape shape = (MapShape)element;
        try {
            next.doFilter(shape);
        }
        catch (MustSplitException e) {
            if (log.isDebugEnabled()) {
                log.debug("splitting shape", GType.formatType(shape.getType()), "at shift", this.shift);
            }
            ArrayList<MapShape> outputs = new ArrayList<MapShape>();
            this.split(shape, outputs);
            for (MapShape s : outputs) {
                this.doFilter(s, next);
            }
        }
    }

    public List<MapShape> testSplit(MapShape shape, int shift) {
        this.shift = shift;
        ArrayList<MapShape> outputs = new ArrayList<MapShape>();
        this.split(shape, outputs);
        return outputs;
    }
}

