/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import java.nio.charset.CharsetEncoder;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.typ.ColourInfo;
import uk.me.parabola.imgfmt.app.typ.TypElement;

public class TypLine
extends TypElement {
    private static final int F_LABEL = 1;
    private static final int F_USE_ROTATION = 2;
    private static final int F_EXTENDED = 4;
    private boolean useOrientation;
    private byte lineWidth;
    private byte borderWidth;

    @Override
    public void write(ImgFileWriter writer, CharsetEncoder encoder) {
        this.offset = writer.position();
        byte flags = 0;
        if (!this.labels.isEmpty()) {
            flags = (byte)(flags | 1);
        }
        if (this.fontStyle != 0 || this.dayFontColour != null) {
            flags = (byte)(flags | 4);
        }
        if (!this.useOrientation) {
            flags = (byte)(flags | 2);
        }
        int height = 0;
        if (this.xpm.hasImage()) {
            height = this.xpm.getColourInfo().getHeight();
        }
        ColourInfo colourInfo = this.xpm.getColourInfo();
        int scheme = colourInfo.getColourScheme() & 7;
        writer.put1u(scheme & 7 | height << 3);
        writer.put1u(flags);
        colourInfo.write(writer);
        if (this.xpm.hasImage()) {
            this.xpm.writeImage(writer);
        }
        if (height == 0) {
            writer.put1u(this.lineWidth);
            if ((scheme & 0xFFFFFFFE) != 6) {
                writer.put1u(this.lineWidth + 2 * this.borderWidth);
            }
        }
        if ((flags & 1) != 0) {
            this.writeLabelBlock(writer, encoder);
        }
        if ((flags & 4) != 0) {
            this.writeExtendedFontInfo(writer);
        }
    }

    public void setUseOrientation(boolean useOrientation) {
        this.useOrientation = useOrientation;
    }

    public void setLineWidth(int val) {
        this.lineWidth = (byte)val;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = (byte)borderWidth;
    }

    public void finish() {
        if (this.borderWidth != 0) {
            this.xpm.getColourInfo().setHasBorder(true);
        }
    }
}

