/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.app.ImgFileWriter;

public class Rgb {
    private final int b;
    private final int g;
    private final int r;
    private final int a;

    public Rgb(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Rgb(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Rgb(String in) {
        String colour = in;
        if (colour.startsWith("#")) {
            colour = colour.substring(1);
        }
        this.r = Integer.parseInt(colour.substring(0, 2), 16);
        this.g = Integer.parseInt(colour.substring(2, 4), 16);
        this.b = Integer.parseInt(colour.substring(4, 6), 16);
        this.a = colour.length() > 6 ? Integer.parseInt(colour.substring(6, 8), 16) : 255;
    }

    public Rgb(Rgb rgb, int alpha) {
        this(rgb.r, rgb.g, rgb.b, alpha);
    }

    public void write(ImgFileWriter writer, byte type) {
        if (type != 16) {
            throw new FormatException("Invalid color deep");
        }
        writer.put1u(this.b);
        writer.put1u(this.g);
        writer.put1u(this.r);
    }

    public boolean isTransparent() {
        return this.a == 0;
    }

    public String toString() {
        if (this.a == 255) {
            return String.format("#%02x%02x%02x", this.r, this.g, this.b);
        }
        return String.format("#%02x%02x%02x%02x", this.r, this.g, this.b, this.a);
    }

    public int getB() {
        return this.b;
    }

    public int getG() {
        return this.g;
    }

    public int getR() {
        return this.r;
    }

    public int getA() {
        return this.a;
    }
}

