/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.util.ArrayList;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgReader;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.Section;
import uk.me.parabola.imgfmt.app.labelenc.CharacterDecoder;
import uk.me.parabola.imgfmt.app.labelenc.CodeFunctions;
import uk.me.parabola.imgfmt.app.labelenc.DecodedText;
import uk.me.parabola.imgfmt.app.lbl.LBLFileReader;
import uk.me.parabola.imgfmt.app.trergn.SubdivData;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.app.trergn.TREHeader;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;
import uk.me.parabola.util.EnhancedProperties;

public class TREFileReader
extends ImgReader {
    private Zoom[] mapLevels;
    private Subdivision[][] levelDivs;
    private static final Subdivision[] EMPTY_SUBDIVISIONS = new Subdivision[0];
    private final TREHeader header = new TREHeader();
    private int tre7Magic;

    public TREFileReader(ImgChannel chan) {
        this(chan, 0);
    }

    public TREFileReader(ImgChannel chan, int gmpOffset) {
        this.setHeader(this.header);
        this.setReader(new BufferedImgFileReader(chan, gmpOffset));
        this.header.readHeader(this.getReader());
        this.tre7Magic = this.header.getTre7Magic();
        this.readMapLevels();
        this.readSubdivs();
        this.readExtTypeOffsetsRecords();
    }

    public Area getBounds() {
        return this.header.getBounds();
    }

    public Zoom[] getMapLevels() {
        return this.mapLevels;
    }

    public Subdivision[] subdivForLevel(int level) {
        for (int i = 0; i < this.mapLevels.length; ++i) {
            if (this.mapLevels[i].getLevel() != level) continue;
            return this.levelDivs[i];
        }
        return EMPTY_SUBDIVISIONS;
    }

    private void readSubdivs() {
        ImgFileReader reader = this.getReader();
        int start = this.header.getSubdivPos();
        int end = start + this.header.getSubdivSize();
        reader.position(start);
        int subdivNum = 1;
        int lastRgnOffset = reader.get3u();
        for (int count = 0; count < this.levelDivs.length && reader.position() < (long)end; ++count) {
            Subdivision[] divs = this.levelDivs[count];
            Zoom zoom = this.mapLevels[count];
            if (divs == null) break;
            for (int i = 0; i < divs.length; ++i) {
                int flags = reader.get1u();
                int lon = reader.get3s();
                int lat = reader.get3s();
                int width = reader.get2u() & Short.MAX_VALUE;
                int height = reader.get2u();
                int extFlags = flags;
                if (reader.getGMPOffset() > 0 && (height & 0x8000) != 0) {
                    extFlags |= 1;
                    height &= Short.MAX_VALUE;
                }
                if (count < this.levelDivs.length - 1) {
                    reader.get2u();
                }
                int endRgnOffset = reader.get3u();
                SubdivData subdivData = new SubdivData(extFlags, lat, lon, width, height, lastRgnOffset, endRgnOffset);
                Subdivision subdiv = Subdivision.readSubdivision(this.mapLevels[count], subdivData);
                subdiv.setNumber(subdivNum++);
                divs[i] = subdiv;
                zoom.addSubdivision(subdiv);
                lastRgnOffset = endRgnOffset;
            }
        }
    }

    private void readExtTypeOffsetsRecords() {
        Subdivision[] divs;
        if ((this.tre7Magic & 7) == 0) {
            return;
        }
        ImgFileReader reader = this.getReader();
        int start = this.header.getExtTypeOffsetsPos();
        int end = start + this.header.getExtTypeOffsetsSize();
        int recSize = this.header.getExtTypeSectionSize();
        if (recSize == 0) {
            return;
        }
        reader.position(start);
        Subdivision sd = null;
        Subdivision sdPrev = null;
        if (this.header.getExtTypeOffsetsSize() % recSize != 0) {
            Logger.defaultLogger.error((Object)"TRE7 data seems to have varying length records, don't know how to read extended types offsets");
            return;
        }
        int available = this.header.getExtTypeOffsetsSize() / recSize;
        int firstDivIndex = 0;
        for (int i = this.levelDivs.length - 1; i >= 0; --i) {
            if ((available -= this.levelDivs[i].length) < 0) {
                Logger.defaultLogger.error((Object)"TRE7 data contains unexpected values, don't know how to read extended types offsets");
                return;
            }
            if (available != 1) continue;
            firstDivIndex = i;
            break;
        }
        for (int count = firstDivIndex; count < this.levelDivs.length && reader.position() < (long)end && (divs = this.levelDivs[count]) != null; ++count) {
            for (int i = 0; i < divs.length; ++i) {
                sdPrev = sd;
                sd = divs[i];
                sd.readExtTypeOffsetsRecord(reader, sdPrev, recSize, this.tre7Magic);
            }
        }
        if (sd != null && reader.position() < (long)end) {
            sd.readLastExtTypeOffsetsRecord(reader, recSize, this.tre7Magic);
        }
        assert (reader.position() == (long)end) : "Failed to read TRE7";
    }

    private void readMapLevels() {
        ImgFileReader reader = this.getReader();
        int levelsPos = this.header.getMapLevelsPos();
        int levelsSize = this.header.getMapLevelsSize();
        reader.position(levelsPos);
        byte[] levelsData = reader.get(levelsSize);
        ArrayList<Subdivision[]> levelDivsList = new ArrayList<Subdivision[]>();
        ArrayList<Zoom> mapLevelsList = new ArrayList<Zoom>();
        int key = 0;
        if (this.header.getLockFlag() != 0) {
            long pos = reader.position();
            if (this.header.getHeaderLength() >= 170) {
                reader.position(reader.getGMPOffset() + 170);
                key = reader.get4();
            }
            reader.position(pos);
            TREFileReader.demangle(levelsData, levelsSize, key);
        }
        int used = 0;
        while (used < levelsSize) {
            int level = levelsData[used++] & 0xFF;
            int nbits = levelsData[used++] & 0xFF;
            byte b1 = levelsData[used++];
            byte b2 = levelsData[used++];
            int ndivs = b1 & 0xFF | (b2 & 0xFF) << 8;
            Subdivision[] divs = new Subdivision[ndivs];
            levelDivsList.add(divs);
            Zoom z = new Zoom(level &= 0x7F, nbits);
            mapLevelsList.add(z);
        }
        this.levelDivs = (Subdivision[][])levelDivsList.toArray((T[])new Subdivision[levelDivsList.size()][]);
        this.mapLevels = mapLevelsList.toArray(new Zoom[mapLevelsList.size()]);
    }

    @Override
    public void config(EnhancedProperties props) {
        this.header.config(props);
    }

    public String[] getMapInfo(int codePage) {
        CodeFunctions funcs = CodeFunctions.createEncoderForLBL(0, codePage);
        CharacterDecoder decoder = funcs.getDecoder();
        ImgFileReader reader = this.getReader();
        reader.position(reader.getGMPOffset() + this.header.getHeaderLength());
        ArrayList<String> msgs = new ArrayList<String>();
        while (reader.position() < (long)(this.header.getHeaderLength() + this.header.getMapInfoSize())) {
            byte[] m = reader.getZString();
            decoder.reset();
            for (byte b : m) {
                decoder.addByte(b);
            }
            DecodedText text = decoder.getText();
            String text1 = text.getText();
            msgs.add(text1);
        }
        return msgs.toArray(new String[msgs.size()]);
    }

    public String[] getCopyrights(LBLFileReader lblReader) {
        Section sect = this.header.getCopyrightSection();
        ImgFileReader reader = this.getReader();
        ArrayList<String> msgs = new ArrayList<String>();
        for (long pos = (long)sect.getPosition(); pos < (long)sect.getEndPos(); pos += (long)sect.getItemSize()) {
            reader.position(pos);
            int offset = reader.get3u();
            Label label = lblReader.fetchLabel(offset);
            if (label == null) continue;
            msgs.add(label.getText());
        }
        return msgs.toArray(new String[msgs.size()]);
    }

    private static void demangle(byte[] data, int size, int key) {
        byte[] shuf = new byte[]{11, 12, 10, 0, 8, 15, 2, 1, 6, 4, 9, 3, 13, 5, 7, 14};
        byte sum = shuf[(key >> 24) + (key >> 16) + (key >> 8) + key & 0xF];
        int ringctr = 16;
        for (int i = 0; i < size; ++i) {
            int upper = data[i] >> 4;
            int lower = data[i];
            upper -= sum;
            upper -= key >> ringctr;
            upper -= shuf[key >> ringctr & 0xF];
            ringctr = ringctr != 0 ? ringctr - 4 : 16;
            lower -= sum;
            lower -= key >> ringctr;
            lower -= shuf[key >> ringctr & 0xF];
            ringctr = ringctr != 0 ? ringctr - 4 : 16;
            data[i] = (byte)(upper << 4 & 0xF0 | lower & 0xF);
        }
    }

    public int getTre7Magic() {
        return this.tre7Magic;
    }
}

