/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.BitWriter;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.net.Abandon;
import uk.me.parabola.imgfmt.app.net.CityZipWriter;
import uk.me.parabola.imgfmt.app.net.NumberStyle;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.imgfmt.app.net.VarBitWriter;
import uk.me.parabola.log.Logger;

public class NumberPreparer {
    private static final Logger log = Logger.getLogger(NumberPreparer.class);
    private final List<Numbers> numbers;
    private boolean valid;
    private static final int START_WIDTH_MIN = 5;
    private static final int END_WIDTH_MIN = 2;
    private BitWriter bw;
    private boolean swappedDefaultStyle;
    CityZipWriter zipWriter;
    CityZipWriter cityWriter;

    public NumberPreparer(List<Numbers> numbers) {
        this.numbers = new ArrayList<Numbers>(numbers);
        this.zipWriter = new CityZipWriter("zip", 0, 0);
        this.cityWriter = new CityZipWriter("city", 0, 0);
    }

    public NumberPreparer(List<Numbers> numbers, Zip zip, City city, int numCities, int numZips) {
        this.numbers = numbers;
        this.zipWriter = new CityZipWriter("zip", zip == null ? 0 : zip.getIndex(), numZips);
        this.cityWriter = new CityZipWriter("city", city == null ? 0 : city.getIndex(), numCities);
    }

    public boolean prepare() {
        this.fetchBitStream();
        if (!this.valid) {
            return false;
        }
        this.zipWriter.compile(this.numbers);
        this.cityWriter.compile(this.numbers);
        return true;
    }

    public BitWriter fetchBitStream() {
        if (this.bw != null) {
            return this.bw;
        }
        int initialValue = this.setup();
        this.bw = new BitWriter();
        try {
            State state = new GatheringState(initialValue);
            this.process(new BitWriter(), state);
            NumberPreparer.writeWidths(state);
            this.writeInitialValue(state);
            state = new WritingState(state);
            this.process(this.bw, state);
            if (this.bw.getLength() > 1) {
                this.valid = true;
            }
        }
        catch (Abandon e) {
            log.error((Object)e.getMessage());
            this.valid = false;
        }
        return this.bw;
    }

    private int setup() {
        this.numbers.removeIf(Numbers::isEmpty);
        if (this.numbers.isEmpty()) {
            throw new Abandon("no numbers");
        }
        Numbers first = this.numbers.get(0);
        if (first.getLeftNumberStyle() == NumberStyle.EVEN && first.getRightNumberStyle() == NumberStyle.ODD) {
            this.swappedDefaultStyle = true;
        }
        int initial = 0;
        if (first.getLeftNumberStyle() != NumberStyle.NONE) {
            initial = first.getLeftStart();
        }
        int rightStart = 0;
        if (first.getRightNumberStyle() != NumberStyle.NONE) {
            rightStart = first.getRightStart();
        }
        if (initial == 0) {
            initial = rightStart;
        }
        if (first.getLeftStart() > first.getLeftEnd() || first.getRightStart() > first.getRightEnd()) {
            initial = Math.max(initial, rightStart);
        } else if (rightStart > 0) {
            initial = Math.min(initial, rightStart);
        }
        return initial;
    }

    private void process(BitWriter bw, State state) {
        if (this.swappedDefaultStyle) {
            state.swapDefaults();
        }
        int lastNode = -1;
        for (Numbers n : this.numbers) {
            if (!n.hasIndex()) {
                throw new Abandon("no index set");
            }
            if (n.getIndex() != lastNode + 1) {
                state.writeSkip(bw, n.getIndex() - lastNode - 2);
            }
            state.setTarget(n);
            state.writeNumberingStyle(bw);
            state.calcNumbers();
            state.writeBitWidths(bw);
            state.writeNumbers(bw);
            state.restoreWriters();
            lastNode = n.getIndex();
        }
    }

    private void writeInitialValue(State state) {
        assert (state.initialValue >= 0) : "initial value is not positive: " + State.access$000(state);
        int width = 32 - Integer.numberOfLeadingZeros(state.initialValue);
        if (width > 20) {
            throw new Abandon("Initial value too large: " + state.initialValue);
        }
        if (width > 5) {
            this.bw.put1(false);
            this.bw.putn(width - 5, 4);
        } else {
            this.bw.put1(true);
            width = 5;
        }
        this.bw.putn(state.initialValue, width);
    }

    private static void writeWidths(State state) {
        state.getStartWriter().writeFormat();
        state.getEndWriter().writeFormat();
    }

    public boolean getSwapped() {
        return this.swappedDefaultStyle;
    }

    public boolean isValid() {
        this.fetchBitStream();
        return this.valid;
    }

    static class WritingState
    extends State {
        private VarBitWriter startWriter;
        private VarBitWriter endWriter;
        private boolean restoreBitWriters;
        private final VarBitWriter savedStartWriter;
        private final VarBitWriter savedEndWriter;

        public WritingState(State state) {
            this.setInitialValue(state.initialValue);
            this.left.base = state.initialValue;
            this.right.base = state.initialValue;
            this.startWriter = state.getStartWriter();
            this.endWriter = state.getEndWriter();
            this.savedStartWriter = this.startWriter;
            this.savedEndWriter = this.endWriter;
        }

        @Override
        public void writeStart(int diff) {
            this.startWriter.write(diff);
        }

        @Override
        public void writeEnd(int diff) {
            this.endWriter.write(diff);
        }

        @Override
        public void writeNumberingStyle(BitWriter bw) {
            if (this.left.targetStyle != this.left.style || this.right.targetStyle != this.right.style) {
                bw.putn(0, 2);
                bw.putn(this.left.targetStyle.getVal(), 2);
                bw.putn(this.right.targetStyle.getVal(), 2);
                this.left.style = this.left.targetStyle;
                this.right.style = this.right.targetStyle;
            }
        }

        @Override
        public void writeBitWidths(BitWriter bw) {
            this.newWriter(bw, this.startWriter, this.left.startDiff, this.right.startDiff, true);
            this.newWriter(bw, this.endWriter, this.left.endDiff, this.right.endDiff, false);
        }

        private void newWriter(BitWriter bw, VarBitWriter writer, int leftDiff, int rightDiff, boolean start) {
            if (!writer.checkFit(leftDiff) || !writer.checkFit(rightDiff)) {
                VarBitWriter nw;
                int min = Math.min(leftDiff, rightDiff);
                int max = Math.max(leftDiff, rightDiff);
                boolean signed = false;
                boolean negative = false;
                if (max < 0) {
                    negative = true;
                } else if (min < 0) {
                    signed = true;
                }
                int val = Math.max(Math.abs(min), Math.abs(max));
                int width = 32 - Integer.numberOfLeadingZeros(val);
                if (signed) {
                    ++width;
                }
                this.restoreBitWriters = true;
                if (start) {
                    this.startWriter = nw = new VarBitWriter(bw, 5, negative, signed, width);
                    bw.putn(2, 4);
                } else {
                    this.endWriter = nw = new VarBitWriter(bw, 2, negative, signed, width);
                    bw.putn(10, 4);
                }
                nw.writeFormat();
            }
        }

        @Override
        public void writeSkip(BitWriter bw, int n) {
            if (n < 0) {
                throw new Abandon("bad skip value:" + n);
            }
            bw.putn(6, 3);
            int width = 32 - Integer.numberOfLeadingZeros(n);
            if (width > 5) {
                bw.put1(true);
                width = 10;
            } else {
                bw.put1(false);
                width = 5;
            }
            bw.putn(n, width);
        }

        @Override
        public VarBitWriter getStartWriter() {
            return this.startWriter;
        }

        @Override
        public VarBitWriter getEndWriter() {
            return this.endWriter;
        }

        @Override
        protected void restoreWriters() {
            if (this.restoreBitWriters) {
                this.startWriter = this.savedStartWriter;
                this.endWriter = this.savedEndWriter;
                this.restoreBitWriters = false;
            }
        }
    }

    private class GatheringState
    extends State {
        private final BitSizes start = new BitSizes();
        private final BitSizes end = new BitSizes();

        public GatheringState(int initialValue) {
            this.setInitialValue(initialValue);
        }

        @Override
        public void writeNumberingStyle(BitWriter bw) {
            this.left.style = this.left.targetStyle;
            this.right.style = this.right.targetStyle;
        }

        @Override
        public void writeStart(int diff) {
            int val = this.testSign(this.start, diff);
            if (val > this.start.diff) {
                this.start.diff = val;
            }
        }

        @Override
        public void writeEnd(int diff) {
            int val = this.testSign(this.end, diff);
            if (val > this.end.diff) {
                this.end.diff = val;
            }
        }

        private int testSign(BitSizes bs, int val) {
            if (val > 0) {
                bs.positive = true;
            } else if (val < 0) {
                bs.negative = true;
                return -val;
            }
            return val;
        }

        @Override
        public VarBitWriter getStartWriter() {
            return this.getVarBitWriter(this.start, 5);
        }

        @Override
        public VarBitWriter getEndWriter() {
            return this.getVarBitWriter(this.end, 2);
        }

        private VarBitWriter getVarBitWriter(BitSizes bs, int minWidth) {
            VarBitWriter writer = new VarBitWriter(NumberPreparer.this.bw, minWidth);
            if (bs.isSigned()) {
                writer.signed = true;
            } else if (bs.negative) {
                writer.negative = true;
            }
            int width = bs.calcWidth();
            if (width > minWidth) {
                writer.bitWidth = width - minWidth;
            }
            if (writer.bitWidth > 15) {
                throw new Abandon("Difference too large");
            }
            return writer;
        }

        class BitSizes {
            private boolean positive;
            private boolean negative;
            private int diff;

            BitSizes() {
            }

            private boolean isSigned() {
                return this.positive && this.negative;
            }

            private int calcWidth() {
                int n = this.diff;
                if (this.isSigned()) {
                    ++n;
                }
                return 32 - Integer.numberOfLeadingZeros(n);
            }
        }
    }

    static class Side {
        private final boolean left;
        private NumberStyle style;
        private int base;
        private int end;
        private NumberStyle targetStyle;
        private int targetStart;
        private int targetEnd;
        private int startDiff;
        private int endDiff;
        private int lastEndDiff;
        private int direction;
        private boolean equalized;

        Side(boolean left) {
            this.left = left;
        }

        public void setTargets(NumberStyle style, int start, int end) {
            this.targetStyle = style;
            this.targetStart = start;
            this.targetEnd = end;
            this.direction = this.targetStart < this.targetEnd ? 1 : (this.targetEnd < this.targetStart ? -1 : 1);
        }

        private boolean tryStart(int value) {
            return value == this.targetStart || this.style.round(value, this.direction) == this.targetStart;
        }

        public boolean needOverride(Side left) {
            return this.endDiff != 0 || left.endDiff == 0;
        }

        private void calc(Side other) {
            boolean anyEqualized;
            if (this.style == NumberStyle.NONE) {
                return;
            }
            boolean bl = anyEqualized = this.equalized || other.equalized;
            if (!anyEqualized) {
                this.startDiff = this.tryStart(this.base) ? 0 : this.targetStart - this.base;
            }
            this.endDiff = this.targetEnd - (this.base + this.startDiff) + this.direction;
            if (this.targetStart == this.targetEnd && this.base == this.targetStart && this.lastEndDiff == 0 && !anyEqualized && (this.left || other.endDiff == 0)) {
                this.endDiff = 0;
            }
            this.end = this.base + this.startDiff + this.endDiff;
            if (this.left) {
                if (this.endDiff == this.lastEndDiff) {
                    this.endDiff = 0;
                }
            } else if (other.style != NumberStyle.NONE) {
                if (other.endDiff == 0 && this.endDiff == this.lastEndDiff) {
                    this.endDiff = 0;
                }
                if (other.endDiff != 0 && other.endDiff == this.endDiff) {
                    this.endDiff = 0;
                }
            }
        }

        public void finish() {
            this.lastEndDiff = this.end - (this.base + this.startDiff);
            this.base = this.end;
        }
    }

    static abstract class State {
        protected final Side left = new Side(true);
        protected final Side right = new Side(false);
        private int initialValue;

        State() {
            this.left.style = NumberStyle.ODD;
            this.right.style = NumberStyle.EVEN;
        }

        public void setInitialValue(int val) {
            this.initialValue = val;
            this.left.base = val;
            this.right.base = val;
        }

        public void setTarget(Numbers numbers) {
            this.left.setTargets(numbers.getLeftNumberStyle(), numbers.getLeftStart(), numbers.getLeftEnd());
            this.right.setTargets(numbers.getRightNumberStyle(), numbers.getRightStart(), numbers.getRightEnd());
        }

        public void writeNumberingStyle(BitWriter bw) {
        }

        public void writeBitWidths(BitWriter bw) {
        }

        public void writeSkip(BitWriter bw, int n) {
        }

        public void calcNumbers() {
            if (this.left.style == NumberStyle.NONE) {
                this.left.base = this.right.base;
            }
            this.equalizeBases();
            this.left.calc(this.right);
            this.right.calc(this.left);
        }

        private boolean equalizeBases() {
            this.left.equalized = (this.right.equalized = false);
            if (this.left.direction != this.right.direction) {
                return false;
            }
            int diff = this.left.targetStart - this.left.base;
            if (this.left.tryStart(this.left.base)) {
                diff = 0;
            }
            if (this.right.tryStart(this.left.base + diff)) {
                this.left.equalized = true;
                this.right.base = this.left.base;
                this.left.startDiff = (this.right.startDiff = diff);
                return true;
            }
            diff = this.right.targetStart - this.right.base;
            if (this.left.tryStart(this.right.base + diff)) {
                this.right.equalized = true;
                this.left.base = this.right.base;
                this.left.startDiff = (this.right.startDiff = diff);
                return true;
            }
            return false;
        }

        public void writeNumbers(BitWriter bw) {
            boolean doSingleSide = this.left.style == NumberStyle.NONE || this.right.style == NumberStyle.NONE;
            bw.put1(true);
            boolean equalized = false;
            if (!doSingleSide) {
                equalized = this.left.equalized || this.right.equalized;
                bw.put1(equalized);
                if (equalized) {
                    bw.put1(this.left.equalized);
                }
            }
            if (!doSingleSide) {
                bw.put1(!this.right.needOverride(this.left));
            }
            Side firstSide = this.left;
            if (doSingleSide && this.left.style == NumberStyle.NONE) {
                firstSide = this.right;
            }
            boolean doStart = firstSide.startDiff != 0;
            boolean doEnd = firstSide.endDiff != 0;
            bw.put1(!doStart);
            bw.put1(!doEnd);
            if (doStart) {
                this.writeStart(firstSide.startDiff);
            }
            if (doEnd) {
                this.writeEnd(firstSide.endDiff);
            }
            firstSide.finish();
            if (doSingleSide) {
                this.left.base = (this.right.base = firstSide.base);
                this.left.lastEndDiff = (this.right.lastEndDiff = firstSide.lastEndDiff);
                return;
            }
            doStart = this.right.startDiff != 0;
            boolean bl = doEnd = this.right.endDiff != 0;
            if (!equalized) {
                bw.put1(!doStart);
            }
            if (this.right.needOverride(this.left)) {
                bw.put1(!doEnd);
            }
            if (doStart && !equalized) {
                this.writeStart(this.right.startDiff);
            }
            if (doEnd) {
                this.writeEnd(this.right.endDiff);
            }
            this.right.finish();
        }

        protected void restoreWriters() {
        }

        public abstract void writeStart(int var1);

        public abstract void writeEnd(int var1);

        public abstract VarBitWriter getStartWriter();

        public abstract VarBitWriter getEndWriter();

        public void swapDefaults() {
            this.left.style = NumberStyle.EVEN;
            this.right.style = NumberStyle.ODD;
        }
    }
}

