/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.net.RouteArc;
import uk.me.parabola.imgfmt.app.net.RouteNode;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.util.EnhancedProperties;

public class AngleChecker {
    private static final Logger log = Logger.getLogger(AngleChecker.class);
    private boolean ignoreSharpAngles;
    private boolean cycleMap;
    private static final float COMPACT_DIR_DEGREES = 46.0f;
    private static final float SHARP_DEGREES = 46.0f;
    private static final float MIN_ANGLE = 23.0f;
    private static final float STRAIGHT_EPSILON = 3.0f;

    public void config(EnhancedProperties props) {
        this.ignoreSharpAngles = props.getProperty("ignore-sharp-angles", false);
        this.cycleMap = props.getProperty("cycle-map", false);
    }

    public void check(Map<Integer, RouteNode> nodes) {
        if (!this.ignoreSharpAngles) {
            byte sharpAnglesCheckMask = this.cycleMap ? (byte)-2 : -1;
            for (RouteNode node : nodes.values()) {
                this.fixSharpAngles(node, sharpAnglesCheckMask);
            }
        }
    }

    public void fixSharpAngles(RouteNode node, byte sharpAnglesCheckMask) {
        int i;
        List<RouteArc> arcs = node.getArcs();
        if (arcs.size() <= 1) {
            return;
        }
        node.setUseCompactDirs(true);
        if (arcs.size() == 2) {
            AngleChecker.doSimpleJoin(node, arcs);
            return;
        }
        ArrayList<RouteArc> directArcs = new ArrayList<RouteArc>();
        for (RouteArc arc : arcs) {
            if (arc.isDirect()) {
                directArcs.add(arc);
                continue;
            }
            log.warn("Unexpected indirect arc", arc, "from", node);
        }
        if (directArcs.size() <= 1) {
            return;
        }
        directArcs.sort((ra1, ra2) -> {
            int d = Float.compare(ra1.getInitialHeading(), ra2.getInitialHeading());
            if (d != 0) {
                return d;
            }
            d = Integer.compare(ra1.getPointsHash(), ra2.getPointsHash());
            if (d != 0) {
                return d;
            }
            return Long.compare(ra1.getRoadDef().getId(), ra2.getRoadDef().getId());
        });
        ArrayList<ArcGroup> arcGroups = new ArrayList<ArcGroup>();
        ListIterator iter = directArcs.listIterator();
        RouteArc arc1 = (RouteArc)iter.next();
        boolean addArc1 = false;
        float smallestAngle = 180.0f;
        block1: while (iter.hasNext() || addArc1) {
            ArcGroup ag = new ArcGroup();
            ag.initialHeading = arc1.getInitialHeading();
            ag.addArc(arc1);
            arcGroups.add(ag);
            addArc1 = false;
            while (iter.hasNext()) {
                RouteArc arc2 = (RouteArc)iter.next();
                float angleBetween = arc2.getInitialHeading() - ag.initialHeading;
                if (angleBetween < 1.0f) {
                    if (arc1.getDest() != arc2.getDest() && arc1.getRoadDef().getId() != arc2.getRoadDef().getId()) {
                        log.warn("sharp angle < 1\u00b0 at", node.getCoord(), ",maybe duplicated OSM way with bearing", AngleChecker.getCompassBearing(arc1.getInitialHeading()));
                    }
                    ag.addArc(arc2);
                    continue;
                }
                if (angleBetween < smallestAngle) {
                    smallestAngle = angleBetween;
                }
                arc1 = arc2;
                if (iter.hasNext()) continue block1;
                addArc1 = true;
                continue block1;
            }
        }
        int lastInx = arcGroups.size() - 1;
        if (lastInx > 0) {
            float angleBetween = ((ArcGroup)arcGroups.get((int)0)).initialHeading - ((ArcGroup)arcGroups.get((int)lastInx)).initialHeading + 360.0f;
            if (angleBetween < 1.0f) {
                for (RouteArc arc : ((ArcGroup)arcGroups.get((int)lastInx)).arcs) {
                    ((ArcGroup)arcGroups.get(0)).addArc(arc);
                }
                arcGroups.remove(lastInx);
            } else if (angleBetween < smallestAngle) {
                smallestAngle = angleBetween;
            }
        }
        if (smallestAngle >= 46.0f && arcGroups.size() == arcs.size()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("fixSharpAngles at", node.getCoord(), "mask", String.format("0x%02x", sharpAnglesCheckMask), "nArcs", arcs.size(), arcGroups.size() < arcs.size() ? "nGroups " + arcGroups.size() : "", "smallestAngle", Float.valueOf(smallestAngle));
            float lastHeading = ((RouteArc)directArcs.get(directArcs.size() - 1)).getInitialHeading() - 360.0f;
            for (RouteArc arc : directArcs) {
                RoadDef rd = arc.getRoadDef();
                log.info("Arc", "heading", Float.valueOf(arc.getInitialHeading()), AngleChecker.getCompassBearing(arc.getInitialHeading()), "angToPrev", Float.valueOf(arc.getInitialHeading() - lastHeading), "class", rd.getRoadClass(), "speed", rd.getRoadSpeed(), "way", rd.getId(), "isFake", FakeIdGenerator.isFakeId(rd.getId()), "name", rd.getName(), "access", String.format("0x%02x", rd.getAccess()), "oneway", rd.isOneway(), "forward", arc.isForward(), "paved", rd.paved());
                lastHeading = arc.getInitialHeading();
            }
        }
        if (arcGroups.size() == 1) {
            node.setUseCompactDirs(false);
            return;
        }
        if (smallestAngle >= 46.0f) {
            return;
        }
        int n = arcGroups.size();
        boolean someNeedIncrease = false;
        class AngleAttr {
            float angle;
            float minAngle;

            AngleAttr() {
            }

            private boolean straightEnough() {
                return this.angle > 177.0f && this.angle < 183.0f;
            }
        }
        AngleAttr[] angles = new AngleAttr[n];
        for (i = 0; i < n; ++i) {
            AngleAttr aa;
            ArcGroup ag1 = (ArcGroup)arcGroups.get(i);
            ArcGroup ag2 = (ArcGroup)arcGroups.get(i + 1 < n ? i + 1 : 0);
            angles[i] = aa = new AngleAttr();
            aa.angle = ag2.getInitialHeading() - ag1.getInitialHeading();
            if (i + 1 >= n) {
                aa.angle += 360.0f;
            }
            aa.minAngle = 23.0f;
            String minimalReason = null;
            byte pathAccessMask = (byte)(ag1.orAccessMask & ag2.orAccessMask);
            if (pathAccessMask == 0) {
                minimalReason = "no common vehicle allowed on both arcs";
            } else if (pathAccessMask == 1) {
                minimalReason = "only pedestrians - sharp angle not a problem";
            } else if ((pathAccessMask & sharpAnglesCheckMask) == 0) {
                minimalReason = "because it can not be used by bike";
            } else if (Math.min(ag1.maxRoadSpeed, ag2.maxRoadSpeed) == 0) {
                minimalReason = "eg service/parking where sharp angle probably indicates shouldn't turn here";
            } else if (ag1.isOneway() && ag2.isOneway()) {
                if (!ag1.isForward() && !ag2.isForward()) {
                    minimalReason = "two one-ways merge";
                    if (aa.angle < 23.0f) {
                        aa.minAngle = aa.angle;
                    }
                } else if (ag1.isForward() && ag2.isForward()) {
                    ArcGroup ag3;
                    minimalReason = "two one-ways split";
                    if (aa.angle < 23.0f && n == 3 && ag1.maxRoadClass == ag2.maxRoadClass && ag1.sameName(ag2) && (ag3 = (ArcGroup)arcGroups.get(i + 2 < n ? i + 2 : i + 2 - n)).isOneway() && ag3.maxRoadClass == ag1.maxRoadClass) {
                        minimalReason = "major road split";
                        aa.minAngle = aa.angle;
                        node.setUseCompactDirs(false);
                    }
                }
            }
            if (minimalReason != null) {
                if (log.isInfoEnabled()) {
                    log.info(aa.angle < aa.minAngle ? "minAngleSharp" : "minAngleOK", Float.valueOf(aa.angle), "minAngle", Float.valueOf(aa.minAngle), "reason", minimalReason);
                }
            } else {
                aa.minAngle = 46.0f;
            }
            if (!(aa.angle < aa.minAngle)) continue;
            someNeedIncrease = true;
        }
        if (!someNeedIncrease) {
            return;
        }
        for (i = 0; i < n; ++i) {
            AngleAttr aa = angles[i];
            float wantedIncrement = aa.minAngle - aa.angle;
            if (wantedIncrement <= 0.0f) continue;
            float oldAngle = aa.angle;
            ArcGroup ag1 = (ArcGroup)arcGroups.get(i);
            ArcGroup ag2 = (ArcGroup)arcGroups.get(i + 1 < n ? i + 1 : 0);
            AngleAttr predAA = angles[i == 0 ? n - 1 : i - 1];
            AngleAttr nextAA = angles[i >= n - 1 ? 0 : i + 1];
            float deltaPred = predAA.angle - predAA.minAngle;
            float deltaNext = nextAA.angle - nextAA.minAngle;
            if (log.isInfoEnabled()) {
                log.info("Angle", Float.valueOf(aa.angle), "between", Float.valueOf(ag1.getInitialHeading()), "and", Float.valueOf(ag2.getInitialHeading()), "minAngle", Float.valueOf(aa.minAngle), "wantedInc", Float.valueOf(wantedIncrement), "deltaPred", Float.valueOf(deltaPred), "deltaNext", Float.valueOf(deltaNext));
            }
            if (deltaNext > 0.0f && deltaPred > 0.0f) {
                ArcGroup ag0 = null;
                ArcGroup ag3 = null;
                int chooseWhich = 0;
                if (chooseWhich == 0) {
                    ag0 = (ArcGroup)arcGroups.get(i > 0 ? i - 1 : n - 1);
                    ArcGroup arcGroup = n == 3 ? ag0 : (ag3 = (ArcGroup)arcGroups.get(i + 2 < n ? i + 2 : i + 2 - n));
                    if (ag2.sameWay(ag3)) {
                        chooseWhich = -1;
                    } else if (ag1.sameWay(ag0)) {
                        chooseWhich = 1;
                    }
                }
                if (chooseWhich == 0) {
                    chooseWhich = ag1.maxRoadClass - ag2.maxRoadClass;
                }
                if (chooseWhich == 0) {
                    if (nextAA.straightEnough()) {
                        chooseWhich = -1;
                    } else if (predAA.straightEnough()) {
                        chooseWhich = 1;
                    }
                }
                if (chooseWhich == 0) {
                    if (ag2.sameName(ag3)) {
                        chooseWhich = -1;
                    } else if (ag1.sameName(ag0)) {
                        chooseWhich = 1;
                    }
                }
                if (chooseWhich == 0) {
                    chooseWhich = ag1.maxRoadSpeed - ag2.maxRoadSpeed;
                }
                if (chooseWhich == 0) {
                    deltaNext = Math.min(deltaNext, wantedIncrement * deltaNext / (deltaNext + deltaPred));
                    deltaPred = Math.min(deltaPred, wantedIncrement - deltaNext);
                } else if (chooseWhich > 0) {
                    if (deltaNext >= wantedIncrement) {
                        deltaNext = wantedIncrement;
                        deltaPred = 0.0f;
                    } else {
                        deltaPred = Math.min(deltaPred, wantedIncrement - deltaNext);
                    }
                } else if (deltaPred >= wantedIncrement) {
                    deltaPred = wantedIncrement;
                    deltaNext = 0.0f;
                } else {
                    deltaNext = Math.min(deltaNext, wantedIncrement - deltaPred);
                }
            } else if (deltaNext > 0.0f) {
                if (deltaNext > wantedIncrement) {
                    deltaNext = wantedIncrement;
                }
            } else if (deltaPred > wantedIncrement) {
                deltaPred = wantedIncrement;
            }
            if (deltaNext > 0.0f) {
                log.info("increasing arc with heading", AngleChecker.getCompassBearing(ag2.getInitialHeading()), "by", Float.valueOf(deltaNext));
                ag2.modInitialHeading(deltaNext);
                aa.angle += deltaNext;
                nextAA.angle -= deltaNext;
                wantedIncrement -= deltaNext;
            }
            if (deltaPred > 0.0f) {
                log.info("decreasing arc with heading", AngleChecker.getCompassBearing(ag1.getInitialHeading()), "by", Float.valueOf(deltaPred));
                ag1.modInitialHeading(-deltaPred);
                aa.angle += deltaPred;
                predAA.angle -= deltaPred;
                wantedIncrement -= deltaPred;
            }
            if (!(wantedIncrement > 0.0f)) continue;
            node.setUseCompactDirs(false);
            if (aa.angle == oldAngle) {
                log.info("don't know how to fix it", Float.valueOf(wantedIncrement));
                continue;
            }
            log.info("don't know how to enlarge it further", Float.valueOf(wantedIncrement));
        }
    }

    private static void doSimpleJoin(RouteNode node, List<RouteArc> arcs) {
        RouteArc arc1 = arcs.get(0);
        RouteArc arc2 = arcs.get(1);
        float angle = arc1.getInitialHeading() - arc2.getInitialHeading();
        float extra = 0.0f;
        if (angle > 314.0f) {
            extra = 360.0f - angle - 46.0f;
        } else if (angle < -314.0f) {
            extra = 46.0f - angle - 360.0f;
        } else if (angle > 0.0f) {
            if (angle < 46.0f) {
                extra = 46.0f - angle;
            }
        } else if (angle < 0.0f && angle > -46.0f) {
            extra = -angle - 46.0f;
        }
        if (extra != 0.0f) {
            if (log.isInfoEnabled()) {
                log.info("join angle", Float.valueOf(angle), "\u00b0 at", node.getCoord(), "increased by", Float.valueOf(extra));
            }
            arc1.modInitialHeading(extra / 2.0f);
            arc2.modInitialHeading(-extra / 2.0f);
        }
    }

    private static String getCompassBearing(float bearing) {
        float cb = (bearing + 360.0f) % 360.0f;
        return Math.round(cb) + "\u00b0";
    }

    private class ArcGroup {
        float initialHeading;
        int isOneWayTrueCount;
        int isForwardTrueCount;
        int maxRoadSpeed;
        int maxRoadClass;
        byte orAccessMask;
        List<RouteArc> arcs = new ArrayList<RouteArc>();

        private ArcGroup() {
        }

        public void addArc(RouteArc arc) {
            this.arcs.add(arc);
            if (arc.getRoadDef().isOneway()) {
                ++this.isOneWayTrueCount;
            }
            if (arc.isForward()) {
                ++this.isForwardTrueCount;
            }
            if (arc.getRoadDef().getRoadSpeed() > this.maxRoadSpeed) {
                this.maxRoadSpeed = arc.getRoadDef().getRoadSpeed();
            }
            if (arc.getRoadDef().getRoadClass() > this.maxRoadClass) {
                this.maxRoadClass = arc.getRoadDef().getRoadClass();
            }
            this.orAccessMask = (byte)(this.orAccessMask | arc.getRoadDef().getAccess());
        }

        public float getInitialHeading() {
            return this.initialHeading;
        }

        public boolean isOneway() {
            return this.isOneWayTrueCount == this.arcs.size();
        }

        public boolean isForward() {
            return this.isForwardTrueCount == this.arcs.size();
        }

        public boolean sameWay(ArcGroup other) {
            for (RouteArc thisArc : this.arcs) {
                for (RouteArc otherArc : other.arcs) {
                    if (thisArc.getRoadDef() != otherArc.getRoadDef()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean sameName(ArcGroup other) {
            for (RouteArc thisArc : this.arcs) {
                String thisName = thisArc.getRoadDef().getName();
                if (thisName == null) continue;
                for (RouteArc otherArc : other.arcs) {
                    if (!thisName.equals(otherArc.getRoadDef().getName())) continue;
                    return true;
                }
            }
            return false;
        }

        public void modInitialHeading(float modIH) {
            this.initialHeading += modIH;
            if (this.initialHeading >= 180.0f) {
                this.initialHeading -= 360.0f;
            } else if (this.initialHeading < -180.0f) {
                this.initialHeading += 360.0f;
            }
            log.info("modInitialHeading arc from", Float.valueOf(this.arcs.get(0).getInitialHeading()), "by", Float.valueOf(modIH), "to", Float.valueOf(this.initialHeading));
            for (RouteArc arc : this.arcs) {
                arc.modInitialHeading(modIH);
            }
        }

        public String toString() {
            return this.arcs.get(0).toString();
        }
    }
}

