/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.TagDict;

public final class AccessTagsAndBits {
    public static final byte FOOT = 1;
    public static final byte BIKE = 2;
    public static final byte CAR = 4;
    public static final byte DELIVERY = 8;
    public static final byte TRUCK = 16;
    public static final byte BUS = 32;
    public static final byte TAXI = 64;
    public static final byte EMERGENCY = -128;
    public static final byte R_THROUGHROUTE = 1;
    public static final byte R_CARPOOL = 2;
    public static final byte R_ONEWAY = 4;
    public static final byte R_TOLL = 8;
    public static final byte R_UNPAVED = 16;
    public static final byte R_FERRY = 32;
    public static final byte R_ROUNDABOUT = 64;
    public static final Map<String, Byte> ACCESS_TAGS;
    public static final Map<Short, Byte> ACCESS_TAGS_COMPILED;
    public static final Map<String, Byte> ROUTE_TAGS;
    private static final short TKM_CARPOOL;
    private static final short TKM_TOLL;
    private static final short TKM_UNPAVED;
    private static final short TKM_FERRY;
    private static final short TKM_THROUGHROUTE;
    private static final short TK_JUNCTION;
    private static final short TK_ONEWAY;

    private AccessTagsAndBits() {
    }

    public static byte evalAccessTags(Element el) {
        int noAccess = 0;
        for (Map.Entry<Short, Byte> entry : ACCESS_TAGS_COMPILED.entrySet()) {
            if (!el.tagIsLikeNo(entry.getKey())) continue;
            noAccess = (byte)(noAccess | entry.getValue());
        }
        return (byte)(~noAccess);
    }

    public static byte evalRouteTags(Element el) {
        byte routeFlags = 0;
        if (el.tagIsLikeYes(TKM_CARPOOL)) {
            routeFlags = (byte)(routeFlags | 2);
        }
        if (el.tagIsLikeYes(TKM_TOLL)) {
            routeFlags = (byte)(routeFlags | 8);
        }
        if (el.tagIsLikeYes(TKM_UNPAVED)) {
            routeFlags = (byte)(routeFlags | 0x10);
        }
        if (el.tagIsLikeYes(TKM_FERRY)) {
            routeFlags = (byte)(routeFlags | 0x20);
        }
        routeFlags = el.tagIsLikeNo(TKM_THROUGHROUTE) ? (byte)((byte)(routeFlags & 0xFFFFFFFE)) : (byte)((byte)(routeFlags | 1));
        if ("roundabout".equals(el.getTag(TK_JUNCTION))) {
            routeFlags = (byte)(routeFlags | 0x40);
        }
        if (el.tagIsLikeYes(TK_ONEWAY)) {
            routeFlags = (byte)(routeFlags | 4);
        }
        return routeFlags;
    }

    static {
        LinkedHashMap<String, Byte> accessTags = new LinkedHashMap<String, Byte>();
        accessTags.put("mkgmap:foot", (byte)1);
        accessTags.put("mkgmap:bicycle", (byte)2);
        accessTags.put("mkgmap:car", (byte)4);
        accessTags.put("mkgmap:delivery", (byte)8);
        accessTags.put("mkgmap:truck", (byte)16);
        accessTags.put("mkgmap:bus", (byte)32);
        accessTags.put("mkgmap:taxi", (byte)64);
        accessTags.put("mkgmap:emergency", (byte)-128);
        ACCESS_TAGS = Collections.unmodifiableMap(accessTags);
        LinkedHashMap accessTagsCompiled = new LinkedHashMap();
        for (Map.Entry entry : accessTags.entrySet()) {
            accessTagsCompiled.put(TagDict.getInstance().xlate((String)entry.getKey()), entry.getValue());
        }
        ACCESS_TAGS_COMPILED = Collections.unmodifiableMap(accessTagsCompiled);
        LinkedHashMap<String, Byte> routeTags = new LinkedHashMap<String, Byte>();
        routeTags.put("mkgmap:throughroute", (byte)1);
        routeTags.put("mkgmap:carpool", (byte)2);
        routeTags.put("oneway", (byte)4);
        routeTags.put("mkgmap:toll", (byte)8);
        routeTags.put("mkgmap:unpaved", (byte)16);
        routeTags.put("mkgmap:ferry", (byte)32);
        routeTags.put("junction", (byte)64);
        ROUTE_TAGS = Collections.unmodifiableMap(routeTags);
        TKM_CARPOOL = TagDict.getInstance().xlate("mkgmap:carpool");
        TKM_TOLL = TagDict.getInstance().xlate("mkgmap:toll");
        TKM_UNPAVED = TagDict.getInstance().xlate("mkgmap:unpaved");
        TKM_FERRY = TagDict.getInstance().xlate("mkgmap:ferry");
        TKM_THROUGHROUTE = TagDict.getInstance().xlate("mkgmap:throughroute");
        TK_JUNCTION = TagDict.getInstance().xlate("junction");
        TK_ONEWAY = TagDict.getInstance().xlate("oneway");
    }
}

