/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr1;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;

public abstract class MdrMapSection
extends MdrSection
implements HasHeaderFlags {
    private Mdr1 index;

    public void setMapIndex(Mdr1 index) {
        this.index = index;
    }

    public final void initIndex(int sectionNumber) {
        int n = this.getNumberOfItems();
        this.index.setPointerSize(sectionNumber, Utils.numberToPointerSize(n));
    }

    public void addIndexPointer(int mapNumber, int recordNumber) {
        if (!this.isForDevice()) {
            this.index.addPointer(mapNumber, recordNumber);
        }
    }

    protected void putCityIndex(ImgFileWriter writer, int cityIndex) {
        int flag = cityIndex > 0 ? this.getSizes().getCityFlag() : 0;
        writer.putNu(this.getSizes().getCitySizeFlagged(), cityIndex | flag);
    }

    protected void putRegionIndex(ImgFileWriter writer, int region) {
        writer.putNu(this.getSizes().getCitySizeFlagged(), region);
    }

    protected void putPoiIndex(ImgFileWriter writer, int poiIndex, boolean isNew) {
        int flag = isNew ? this.getSizes().getPoiFlag() : 0;
        writer.putNu(this.getSizes().getPoiSizeFlagged(), poiIndex | flag);
    }

    protected boolean hasFlag(int val) {
        return (this.getExtraValue() & val) != 0;
    }
}

