/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.LargeListSorter;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrMapSection;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.RecordBase;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr7
extends MdrMapSection {
    public static final int MDR7_HAS_STRING = 1;
    public static final int MDR7_HAS_NAME_OFFSET = 32;
    public static final int MDR7_PARTIAL_SHIFT = 6;
    public static final int MDR7_U1 = 2;
    public static final int MDR7_HAS_MDR17 = 4;
    private static final int MAX_NAME_OFFSET = 127;
    private final int codepage;
    private final boolean isMulti;
    private final boolean splitName;
    private Set<Mdr7Record> roadsPerMap = new HashSet<Mdr7Record>();
    private ArrayList<Mdr7Record> allStreets = new ArrayList();
    private ArrayList<Mdr7Record> streets = new ArrayList();
    private int lastMaxIndex = -1;
    private int partialInfoSize;
    private Set<String> exclNames;
    private final Sort sort;
    private int maxPrefixCount;
    private int maxSuffixCount;
    private boolean magicIsValid;
    private int magic;

    public Mdr7(MdrConfig config) {
        this.setConfig(config);
        this.sort = config.getSort();
        this.splitName = config.isSplitName();
        this.exclNames = config.getMdr7Excl();
        this.codepage = this.sort.getCodepage();
        this.isMulti = this.sort.isMulti();
    }

    public void addStreet(int mapId, String name, int lblOffset, int strOff, Mdr5Record mdrCity) {
        int c;
        int sep;
        if (name.isEmpty()) {
            return;
        }
        int prefix = 0;
        if (name.charAt(0) < '\u0007') {
            prefix = 1;
        }
        if ((sep = name.indexOf(30)) < 0) {
            sep = name.indexOf(27);
        }
        if (sep > 0) {
            prefix = sep + 1;
        }
        if ((sep = name.indexOf(31)) < 0) {
            sep = name.indexOf(28);
        }
        int suffix = 0;
        if (sep > 0) {
            suffix = sep;
        }
        if (prefix >= 127 || suffix >= 127) {
            return;
        }
        Mdr7Record st = new Mdr7Record();
        st.setMapIndex(mapId);
        st.setLabelOffset(lblOffset);
        st.setStringOffset(strOff);
        st.setName(name);
        st.setCity(mdrCity);
        st.setPrefixOffset((byte)prefix);
        st.setSuffixOffset((byte)suffix);
        this.storeMdr7(st);
        if (!this.splitName) {
            return;
        }
        boolean start = false;
        boolean inWord = false;
        int outOffset = 0;
        int end = Math.min((suffix > 0 ? suffix : name.length()) - prefix - 1, 127);
        for (int nameOffset = 0; nameOffset < end && (c = name.codePointAt(prefix + nameOffset)) != 40; nameOffset += Character.charCount(c)) {
            if (!Character.isLetterOrDigit(c)) {
                start = true;
                inWord = false;
            } else if (start && Character.isLetterOrDigit(c)) {
                inWord = true;
            }
            if (start && inWord && outOffset > 0) {
                st = new Mdr7Record();
                st.setMapIndex(mapId);
                st.setLabelOffset(lblOffset);
                st.setStringOffset(strOff);
                st.setName(name);
                st.setCity(mdrCity);
                st.setNameOffset((byte)nameOffset);
                st.setOutNameOffset((byte)outOffset);
                st.setPrefixOffset((byte)prefix);
                st.setSuffixOffset((byte)suffix);
                if (!this.exclNames.contains(st.getPartialName())) {
                    this.storeMdr7(st);
                }
                start = false;
            }
            if ((outOffset += this.outSize(c)) > 127) break;
        }
    }

    private void storeMdr7(Mdr7Record st) {
        if (this.lastMaxIndex != st.getMapIndex()) {
            this.lastMaxIndex = st.getMapIndex();
            this.roadsPerMap.clear();
        }
        if (this.roadsPerMap.add(st)) {
            this.allStreets.add(st);
        }
    }

    private int outSize(int c) {
        if (this.codepage == 65001) {
            if (c < 128) {
                return 1;
            }
            if (c <= 2047) {
                return 2;
            }
            if (c <= 65535) {
                return 3;
            }
            if (c <= 0x10FFFF) {
                return 4;
            }
            throw new MapFailedException(String.format("Invalid code point: 0x%x", c));
        }
        if (!this.isMulti) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void preWriteImpl() {
        LargeListSorter<Mdr7Record> partialSorter = new LargeListSorter<Mdr7Record>(this.sort){

            @Override
            protected SortKey<Mdr7Record> makeKey(Mdr7Record r, Sort sort, Map<String, byte[]> cache) {
                return sort.createSortKey(r, r.getPartialName(), 0, cache);
            }
        };
        ArrayList<Mdr7Record> sorted = new ArrayList<Mdr7Record>(this.allStreets);
        this.allStreets.clear();
        partialSorter.sort(sorted);
        String lastPartial = null;
        ArrayList<Mdr7Record> samePartial = new ArrayList<Mdr7Record>();
        Collator collator = this.sort.getCollator();
        collator.setStrength(1);
        for (int i = 0; i < sorted.size(); ++i) {
            Mdr7Record r = sorted.get(i);
            String partial = r.getPartialName();
            if (lastPartial == null || collator.compare(partial, lastPartial) != 0) {
                this.groupByNameAndMap(samePartial);
                samePartial.clear();
            }
            samePartial.add(r);
            lastPartial = partial;
        }
        this.groupByNameAndMap(samePartial);
        this.allStreets.trimToSize();
        this.streets.trimToSize();
    }

    private void groupByNameAndMap(List<Mdr7Record> samePartial) {
        if (samePartial.isEmpty()) {
            return;
        }
        LargeListSorter<Mdr7Record> fullNameSorter = new LargeListSorter<Mdr7Record>(this.sort){

            @Override
            protected SortKey<Mdr7Record> makeKey(Mdr7Record r, Sort sort, Map<String, byte[]> cache) {
                return sort.createSortKey(r, r.getName(), r.getMapIndex(), cache);
            }
        };
        fullNameSorter.sort(samePartial);
        RecordBase last = null;
        int recordNumber = this.streets.size();
        for (int i = 0; i < samePartial.size(); ++i) {
            Mdr7Record r = samePartial.get(i);
            if (last != null && r.getMapIndex() == last.getMapIndex() && r.getName().equals(((Mdr7Record)last).getName())) {
                r.setIndex(recordNumber);
            } else {
                r.setIndex(++recordNumber);
                this.streets.add(r);
            }
            if (r.getCity() != null) {
                this.allStreets.add(r);
            }
            last = r;
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        boolean hasStrings = this.hasFlag(1);
        boolean hasNameOffset = this.hasFlag(32);
        Collator collator = this.sort.getCollator();
        collator.setStrength(1);
        Mdr7Record last = null;
        for (Mdr7Record s : this.streets) {
            this.addIndexPointer(s.getMapIndex(), s.getIndex());
            this.putMapIndex(writer, s.getMapIndex());
            int lab = s.getLabelOffset();
            int rr = s.checkRepeat(last, collator);
            if (rr != 3) {
                lab |= 0x800000;
            }
            writer.put3u(lab);
            if (hasStrings) {
                this.putStringOffset(writer, s.getStringOffset());
            }
            if (hasNameOffset) {
                writer.put1u(s.getOutNameOffset());
            }
            if (this.partialInfoSize > 0) {
                int trailingFlags = (rr & 1) == 0 ? 1 : 0;
                writer.putNu(this.partialInfoSize, trailingFlags);
            }
            last = s;
        }
    }

    @Override
    public int getItemSize() {
        MdrSection.PointerSizes sizes = this.getSizes();
        int size = sizes.getMapSize() + 3 + this.partialInfoSize;
        if (!this.isForDevice()) {
            size += sizes.getStrOffSize();
        }
        if ((this.getExtraValue() & 0x20) != 0) {
            ++size;
        }
        return size;
    }

    @Override
    protected int numberOfItems() {
        return this.streets.size();
    }

    @Override
    public int getExtraValue() {
        if (!this.magicIsValid) {
            int bitsPrefix = this.maxPrefixCount == 0 ? 0 : Integer.numberOfTrailingZeros(Integer.highestOneBit(this.maxPrefixCount)) + 1;
            int bitsSuffix = this.maxSuffixCount == 0 ? 0 : Integer.numberOfTrailingZeros(Integer.highestOneBit(this.maxSuffixCount)) + 1;
            int bits = bitsPrefix + bitsSuffix + 1;
            this.partialInfoSize = 1 + bits / 8;
            assert (bitsSuffix <= 15);
            this.magic = 0x22 | this.partialInfoSize << 6 | bitsPrefix << 9;
            if (this.isForDevice()) {
                if (!this.getConfig().getSort().isMulti()) {
                    this.magic |= 4;
                }
            } else {
                this.magic |= 1;
            }
            int unk2size = this.magic >> 6 & 7;
            int unk2split = this.magic >> 9 & 0xF;
            assert (unk2size == this.partialInfoSize);
            assert (unk2split == bitsPrefix);
            this.magicIsValid = true;
        }
        return this.magic;
    }

    @Override
    protected void releaseMemory() {
        this.allStreets = null;
        this.streets = null;
    }

    public List<Mdr7Record> getStreets() {
        return Collections.unmodifiableList(this.allStreets);
    }

    public List<Mdr7Record> getSortedStreets() {
        return Collections.unmodifiableList(this.streets);
    }

    public void trim() {
        this.allStreets.trimToSize();
        this.roadsPerMap = new HashSet<Mdr7Record>();
    }
}

