/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr14Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr29Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr25
extends MdrSection {
    private final List<Mdr5Record> cities = new ArrayList<Mdr5Record>();

    public Mdr25(MdrConfig config) {
        this.setConfig(config);
    }

    public void sortCities(List<Mdr5Record> list) {
        Sort sort = this.getConfig().getSort();
        ArrayList<SortKey<Mdr5Record>> keys = new ArrayList<SortKey<Mdr5Record>>();
        for (Mdr5Record c : list) {
            SortKey<Mdr5Record> key = sort.createSortKey(c, c.getMdrCountry().getName(), c.getGlobalCityIndex());
            keys.add(key);
        }
        keys.sort(null);
        String lastName = null;
        Mdr5Record lastCity = null;
        int record = 0;
        for (SortKey sortKey : keys) {
            Mdr5Record city = (Mdr5Record)sortKey.getObject();
            if (lastCity != null && city.getName().equals(lastCity.getName()) && city.getRegionName().equals(lastCity.getRegionName()) && city.getCountryName().equals(lastCity.getCountryName())) continue;
            ++record;
            Mdr14Record mdrCountry = city.getMdrCountry();
            Mdr29Record mdr29 = mdrCountry.getMdr29();
            String name = mdr29.getName();
            assert (mdrCountry.getName().equals(name));
            if (!name.equals(lastName)) {
                mdr29.setMdr25(record);
                lastName = name;
            }
            this.cities.add(city);
            lastCity = city;
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int size = this.getItemSize();
        for (Mdr5Record city : this.cities) {
            writer.putNu(size, city.getGlobalCityIndex());
        }
    }

    @Override
    public int getItemSize() {
        return this.getSizes().getCitySize();
    }

    @Override
    protected int numberOfItems() {
        return this.cities.size();
    }
}

