/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.map;

import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileNotWritableException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.dem.DEMFile;
import uk.me.parabola.imgfmt.app.labelenc.CodeFunctions;
import uk.me.parabola.imgfmt.app.lbl.LBLFile;
import uk.me.parabola.imgfmt.app.net.NETFile;
import uk.me.parabola.imgfmt.app.net.NODFile;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.trergn.InternalFiles;
import uk.me.parabola.imgfmt.app.trergn.MapObject;
import uk.me.parabola.imgfmt.app.trergn.PointOverview;
import uk.me.parabola.imgfmt.app.trergn.PolygonOverview;
import uk.me.parabola.imgfmt.app.trergn.PolylineOverview;
import uk.me.parabola.imgfmt.app.trergn.RGNFile;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.app.trergn.TREFile;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.sys.ImgFS;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.combiners.OverviewBuilder;
import uk.me.parabola.util.Configurable;
import uk.me.parabola.util.EnhancedProperties;

public class Map
implements InternalFiles,
Configurable {
    private static final Logger log = Logger.getLogger(Map.class);
    private String filename;
    private String mapName;
    private int mapId;
    private FileSystem fileSystem;
    private TREFile treFile;
    private RGNFile rgnFile;
    private LBLFile lblFile;
    private NETFile netFile;
    private NODFile nodFile;
    private DEMFile demFile;
    private boolean isOverviewCombined;

    private Map() {
    }

    public static Map createMap(String mapname, String outputdir, FileSystemParam params, String mapnumber, Sort sort, boolean overviewCombined) throws FileExistsException, FileNotWritableException {
        int mapid;
        Map m = new Map();
        m.mapName = mapname;
        String outFilename = Utils.joinPath(outputdir, mapname, "img");
        FileSystem fs = ImgFS.createFs(outFilename, params);
        m.filename = outFilename;
        m.fileSystem = fs;
        m.rgnFile = new RGNFile(m.fileSystem.create(mapnumber + ".RGN"));
        m.treFile = new TREFile(m.fileSystem.create(mapnumber + ".TRE"));
        m.lblFile = new LBLFile(m.fileSystem.create(mapnumber + ".LBL"), sort);
        m.isOverviewCombined = overviewCombined;
        try {
            mapid = Integer.parseInt(mapnumber);
        }
        catch (NumberFormatException e) {
            mapid = 0;
        }
        m.mapId = mapid;
        m.treFile.setMapId(mapid);
        m.fileSystem = fs;
        return m;
    }

    @Override
    public void config(EnhancedProperties props) {
        boolean isOverviewComponent = OverviewBuilder.isOverviewImg(this.mapName);
        if (!isOverviewComponent && !this.isOverviewCombined) {
            try {
                if (props.containsKey("route") || props.containsKey("net") || props.containsKey("housenumbers")) {
                    this.addNet();
                }
                if (props.containsKey("route")) {
                    this.addNod();
                }
            }
            catch (FileExistsException e) {
                log.warn((Object)"Could not add NET and/or NOD sections");
            }
            this.treFile.config(props);
        }
        if (!isOverviewComponent && (!this.isOverviewCombined || props.containsKey("overview-dem-dist")) && props.containsKey("dem")) {
            try {
                this.addDem();
            }
            catch (FileExistsException e) {
                log.warn((Object)"Could not add DEM section");
            }
        }
    }

    private void addNet() throws FileExistsException {
        this.netFile = new NETFile(this.fileSystem.create(this.mapName + ".NET"));
    }

    private void addNod() throws FileExistsException {
        this.nodFile = new NODFile(this.fileSystem.create(this.mapName + ".NOD"), true);
    }

    private void addDem() throws FileExistsException {
        this.demFile = new DEMFile(this.fileSystem.create(this.mapId + ".DEM"), true);
    }

    public void setBounds(Area area) {
        this.treFile.setBounds(area);
    }

    public void addCopyright(String str) {
        Label cpy = this.lblFile.newLabel(str, false);
        this.treFile.addCopyright(cpy);
    }

    public void addInfo(String msg) {
        int codePage = this.lblFile.getCodePage();
        CodeFunctions functions = CodeFunctions.createEncoderForLBL(0, codePage);
        this.treFile.addInfo(functions.getEncoder().encodeText(msg));
    }

    public Zoom createZoom(int level, int bits) {
        return this.treFile.createZoom(level, bits);
    }

    public Subdivision topLevelSubdivision(Area area, Zoom zoom) {
        zoom.setInherited(true);
        Map ifiles = this;
        Subdivision sub = Subdivision.topLevelSubdivision(ifiles, area, zoom);
        this.rgnFile.startDivision(sub);
        return sub;
    }

    public Subdivision createSubdivision(Subdivision parent, Area area, Zoom zoom) {
        log.debug((Object)"creating division");
        return parent.createSubdivision(this, area, zoom);
    }

    public void addPointOverview(PointOverview ov) {
        this.treFile.addPointOverview(ov);
    }

    public void addPolylineOverview(PolylineOverview ov) {
        this.treFile.addPolylineOverview(ov);
    }

    public void addPolygonOverview(PolygonOverview ov) {
        this.treFile.addPolygonOverview(ov);
    }

    public void addPoiDisplayFlags(int flags) {
        this.treFile.addPoiDisplayFlags(flags);
    }

    public void addMapObject(MapObject item) {
        this.rgnFile.addMapObject(item);
    }

    public void setSort(Sort sort) {
        this.lblFile.setSort(sort);
        if (this.netFile != null) {
            this.netFile.setSort(sort);
        }
    }

    public void setLabelCharset(String desc, boolean forceUpper) {
        this.lblFile.setCharacterType(desc, forceUpper);
    }

    public void close() {
        this.fileSystem.close();
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public RGNFile getRgnFile() {
        return this.rgnFile;
    }

    @Override
    public LBLFile getLblFile() {
        return this.lblFile;
    }

    @Override
    public TREFile getTreFile() {
        return this.treFile;
    }

    @Override
    public NETFile getNetFile() {
        return this.netFile;
    }

    @Override
    public NODFile getNodFile() {
        return this.nodFile;
    }

    public DEMFile getDemFile() {
        return this.demFile;
    }
}

