/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.labelenc;

import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.Locale;
import uk.me.parabola.imgfmt.app.labelenc.BaseEncoder;
import uk.me.parabola.imgfmt.app.labelenc.CharacterEncoder;
import uk.me.parabola.imgfmt.app.labelenc.EncodedText;

public class Utf8Encoder
extends BaseEncoder
implements CharacterEncoder {
    @Override
    public EncodedText encodeText(String text) {
        if (text == null || text.isEmpty()) {
            return NO_TEXT;
        }
        String uctext = this.isUpperCase() ? text.toUpperCase(Locale.ENGLISH) : text;
        uctext = Normalizer.normalize(uctext, Normalizer.Form.NFC);
        byte[] buf = uctext.getBytes(StandardCharsets.UTF_8);
        byte[] res = new byte[buf.length + 1];
        System.arraycopy(buf, 0, res, 0, buf.length);
        res[buf.length] = 0;
        EncodedText et = new EncodedText(res, res.length, uctext.toCharArray());
        return et;
    }
}

