/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cytodynamics.nucleus;

import com.linkedin.cytodynamics.nucleus.FileOriginRestrictionFilter;
import com.linkedin.cytodynamics.nucleus.GlobPatternRestrictionFilter;
import com.linkedin.cytodynamics.nucleus.OriginMatchResults;
import com.linkedin.cytodynamics.nucleus.OriginRestrictionFilter;
import com.linkedin.cytodynamics.nucleus.ProtocolOriginRestrictionFilter;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class OriginRestriction {
    private final boolean allowedByDefault;
    private List<OriginRestrictionFilter> filters = new ArrayList<OriginRestrictionFilter>();

    private OriginRestriction(boolean allowedByDefault) {
        this.allowedByDefault = allowedByDefault;
    }

    public static OriginRestriction allowByDefault() {
        return new OriginRestriction(true);
    }

    public static OriginRestriction denyByDefault() {
        return new OriginRestriction(false);
    }

    public OriginRestriction allowingProtocols(String ... protocols) {
        this.filters.add(new ProtocolOriginRestrictionFilter(new HashSet<String>(Arrays.asList(protocols)), OriginMatchResults.ALLOW));
        return this;
    }

    public OriginRestriction denyingProtocols(String ... protocols) {
        this.filters.add(new ProtocolOriginRestrictionFilter(new HashSet<String>(Arrays.asList(protocols)), OriginMatchResults.DENY));
        return this;
    }

    public OriginRestriction allowingGlobPattern(String globPattern) {
        this.filters.add(new GlobPatternRestrictionFilter(globPattern, OriginMatchResults.ALLOW));
        return this;
    }

    public OriginRestriction denyingGlobPattern(String globPattern) {
        this.filters.add(new GlobPatternRestrictionFilter(globPattern, OriginMatchResults.DENY));
        return this;
    }

    public OriginRestriction allowingDirectory(File directory, boolean recursive) {
        this.filters.add(new FileOriginRestrictionFilter(directory, recursive, OriginMatchResults.ALLOW));
        return this;
    }

    public OriginRestriction denyingDirectory(File directory, boolean recursive) {
        this.filters.add(new FileOriginRestrictionFilter(directory, recursive, OriginMatchResults.DENY));
        return this;
    }

    boolean isAllowed(URL url) {
        OriginRestrictionFilter filter;
        OriginMatchResults lastCheckResults = null;
        Iterator<OriginRestrictionFilter> iterator = this.filters.iterator();
        while (iterator.hasNext() && !(lastCheckResults = (filter = iterator.next()).isAllowed(url)).matches()) {
        }
        if (lastCheckResults != null && lastCheckResults.matches()) {
            return lastCheckResults.isAllowed();
        }
        return this.allowedByDefault;
    }
}

