/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cytodynamics.isolation;

import com.linkedin.cytodynamics.isolation.Chooser;
import com.linkedin.cytodynamics.isolation.FullIsolationChooser;
import com.linkedin.cytodynamics.isolation.NoneIsolationChooser;
import com.linkedin.cytodynamics.isolation.NoneIsolationListChooser;
import com.linkedin.cytodynamics.isolation.TransitionalIsolationChooser;
import com.linkedin.cytodynamics.isolation.TransitionalIsolationListChooser;
import com.linkedin.cytodynamics.nucleus.IsolationLevel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ChooserMappingFactory {
    public static <T> Map<IsolationLevel, Chooser<T>> buildChooserMapping(Consumer<T> reportDelegateUsageWarning) {
        HashMap<IsolationLevel, Chooser> chooserMap = new HashMap<IsolationLevel, Chooser>();
        chooserMap.put(IsolationLevel.NONE, new NoneIsolationChooser());
        chooserMap.put(IsolationLevel.TRANSITIONAL, new TransitionalIsolationChooser<T>(reportDelegateUsageWarning));
        chooserMap.put(IsolationLevel.FULL, new FullIsolationChooser());
        return Collections.unmodifiableMap(chooserMap);
    }

    public static <T> Map<IsolationLevel, Chooser<List<T>>> buildChooserMappingForList(Consumer<List<T>> reportDelegateUsageWarning) {
        HashMap<IsolationLevel, Chooser> chooserMap = new HashMap<IsolationLevel, Chooser>();
        chooserMap.put(IsolationLevel.NONE, new NoneIsolationListChooser());
        chooserMap.put(IsolationLevel.TRANSITIONAL, new TransitionalIsolationListChooser<T>(reportDelegateUsageWarning));
        chooserMap.put(IsolationLevel.FULL, new FullIsolationChooser());
        return Collections.unmodifiableMap(chooserMap);
    }
}

