/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.diff;

import io.confluent.kafka.schemaregistry.json.diff.Context;
import io.confluent.kafka.schemaregistry.json.diff.Difference;
import java.util.Objects;
import org.everit.json.schema.NumberSchema;

class NumberSchemaDiff {
    NumberSchemaDiff() {
    }

    static void compare(Context ctx, NumberSchema original, NumberSchema update) {
        if (!Objects.equals(original.getMaximum(), update.getMaximum())) {
            if (original.getMaximum() == null && update.getMaximum() != null) {
                ctx.addDifference("maximum", Difference.Type.MAXIMUM_ADDED);
            } else if (original.getMaximum() != null && update.getMaximum() == null) {
                ctx.addDifference("maximum", Difference.Type.MAXIMUM_REMOVED);
            } else if (original.getMaximum().doubleValue() < update.getMaximum().doubleValue()) {
                ctx.addDifference("maximum", Difference.Type.MAXIMUM_INCREASED);
            } else if (original.getMaximum().doubleValue() > update.getMaximum().doubleValue()) {
                ctx.addDifference("maximum", Difference.Type.MAXIMUM_DECREASED);
            }
        }
        if (!Objects.equals(original.getMinimum(), update.getMinimum())) {
            if (original.getMinimum() == null && update.getMinimum() != null) {
                ctx.addDifference("minimum", Difference.Type.MINIMUM_ADDED);
            } else if (original.getMinimum() != null && update.getMinimum() == null) {
                ctx.addDifference("minimum", Difference.Type.MINIMUM_REMOVED);
            } else if (original.getMinimum().doubleValue() < update.getMinimum().doubleValue()) {
                ctx.addDifference("minimum", Difference.Type.MINIMUM_INCREASED);
            } else if (original.getMinimum().doubleValue() > update.getMinimum().doubleValue()) {
                ctx.addDifference("minimum", Difference.Type.MINIMUM_DECREASED);
            }
        }
        if (!Objects.equals(original.getExclusiveMaximumLimit(), update.getExclusiveMaximumLimit())) {
            if (original.getExclusiveMaximumLimit() == null && update.getExclusiveMaximumLimit() != null) {
                ctx.addDifference("exclusiveMaximum", Difference.Type.EXCLUSIVE_MAXIMUM_ADDED);
            } else if (original.getExclusiveMaximumLimit() != null && update.getExclusiveMaximumLimit() == null) {
                ctx.addDifference("exclusiveMaximum", Difference.Type.EXCLUSIVE_MAXIMUM_REMOVED);
            } else if (original.getExclusiveMaximumLimit().doubleValue() < update.getExclusiveMaximumLimit().doubleValue()) {
                ctx.addDifference("exclusiveMaximum", Difference.Type.EXCLUSIVE_MAXIMUM_INCREASED);
            } else if (original.getExclusiveMaximumLimit().doubleValue() > update.getMaximum().doubleValue()) {
                ctx.addDifference("exclusiveMaximum", Difference.Type.EXCLUSIVE_MAXIMUM_DECREASED);
            }
        }
        if (!Objects.equals(original.getExclusiveMinimumLimit(), update.getExclusiveMinimumLimit())) {
            if (original.getExclusiveMinimumLimit() == null && update.getExclusiveMinimumLimit() != null) {
                ctx.addDifference("exclusiveMinimum", Difference.Type.EXCLUSIVE_MINIMUM_ADDED);
            } else if (original.getExclusiveMinimumLimit() != null && update.getExclusiveMinimumLimit() == null) {
                ctx.addDifference("exclusiveMinimum", Difference.Type.EXCLUSIVE_MINIMUM_REMOVED);
            } else if (original.getExclusiveMinimumLimit().doubleValue() < update.getExclusiveMinimumLimit().doubleValue()) {
                ctx.addDifference("exclusiveMinimum", Difference.Type.EXCLUSIVE_MINIMUM_INCREASED);
            } else if (original.getExclusiveMinimumLimit().doubleValue() > update.getExclusiveMinimumLimit().doubleValue()) {
                ctx.addDifference("exclusiveMinimum", Difference.Type.EXCLUSIVE_MINIMUM_DECREASED);
            }
        }
        if (!Objects.equals(original.getMultipleOf(), update.getMultipleOf())) {
            if (original.getMultipleOf() == null && update.getMultipleOf() != null) {
                ctx.addDifference("multipleOf", Difference.Type.MULTIPLE_OF_ADDED);
            } else if (original.getMultipleOf() != null && update.getMultipleOf() == null) {
                ctx.addDifference("multipleOf", Difference.Type.MULTIPLE_OF_REMOVED);
            } else if (update.getMultipleOf().intValue() % original.getMultipleOf().intValue() == 0) {
                ctx.addDifference("multipleOf", Difference.Type.MULTIPLE_OF_EXPANDED);
            } else if (original.getMultipleOf().intValue() % update.getMultipleOf().intValue() == 0) {
                ctx.addDifference("multipleOf", Difference.Type.MULTIPLE_OF_REDUCED);
            } else {
                ctx.addDifference("multipleOf", Difference.Type.MULTIPLE_OF_CHANGED);
            }
        }
        if (original.requiresInteger() != update.requiresInteger()) {
            if (original.requiresInteger()) {
                ctx.addDifference(Difference.Type.TYPE_EXTENDED);
            } else {
                ctx.addDifference(Difference.Type.TYPE_NARROWED);
            }
        }
    }
}

