/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird.immutable;

import com.twitter.algebird.Approximate;
import com.twitter.algebird.Hash128;
import com.twitter.algebird.immutable.BloomFilter;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichDouble$;

public final class BloomFilter$
implements Serializable {
    public static final BloomFilter$ MODULE$ = new BloomFilter$();

    public final <A> BloomFilter<A> apply(int numEntries, double fpProb, Hash128<A> hash) {
        Option<Object> option = this.optimalWidth(numEntries, fpProb);
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(121).append("BloomFilter cannot guarantee the specified false positive probability for the number of entries! (numEntries: ").append(numEntries).append(", fpProb: ").append(fpProb).append(")").toString());
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        int width = BoxesRunTime.unboxToInt((Object)((Some)option).value());
        int numHashes = this.optimalNumHashes(numEntries, width);
        BloomFilter<A> bloomFilter = new BloomFilter<A>(numHashes, width, hash);
        return bloomFilter;
    }

    public int optimalNumHashes(int numEntries, int width) {
        return (int)package$.MODULE$.ceil((double)(width / numEntries) * package$.MODULE$.log(2.0));
    }

    public Option<Object> optimalWidth(int numEntries, double fpProb) {
        int widthEstimate = (int)package$.MODULE$.ceil((double)(-1 * numEntries) * package$.MODULE$.log(fpProb) / package$.MODULE$.log(2.0) / package$.MODULE$.log(2.0));
        if (widthEstimate == Integer.MAX_VALUE) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)widthEstimate));
    }

    public Approximate<Object> sizeEstimate(int numBits, int numHashes, int width, double approximationWidth) {
        Predef$.MODULE$.assert(0.0 <= approximationWidth && approximationWidth < 1.0, (Function0 & Serializable)() -> "approximationWidth must lie in [0, 1)");
        int n = (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(BloomFilter$.sInverse$1(numBits, width, numHashes)));
        int nl = (int)package$.MODULE$.min(RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(BloomFilter$.sInverse$1(numBits - 1, width, numHashes))), (1.0 - approximationWidth) * (double)n);
        int nr = (int)package$.MODULE$.max(RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(BloomFilter$.sInverse$1(numBits + 1, width, numHashes))), (1.0 + approximationWidth) * (double)n);
        double prob = 1.0 - package$.MODULE$.exp((double)(numBits - 1) - BloomFilter$.s$1(nl, width, numHashes)) * package$.MODULE$.pow(BloomFilter$.s$1(nl, width, numHashes) / (double)(numBits - 1), (double)(numBits - 1)) - package$.MODULE$.exp(-package$.MODULE$.pow((double)(numBits + 1) - BloomFilter$.s$1(nr, width, numHashes), 2.0) / ((double)2 * BloomFilter$.s$1(nr, width, numHashes)));
        return new Approximate<Object>(BoxesRunTime.boxToLong((long)nl), BoxesRunTime.boxToLong((long)n), BoxesRunTime.boxToLong((long)nr), package$.MODULE$.max(0.0, prob), (Numeric<Object>)Numeric.LongIsIntegral$.MODULE$);
    }

    public double sizeEstimate$default$4() {
        return 0.05;
    }

    public <A> BloomFilter<A> apply(int numHashes, int width, Hash128<A> hash) {
        return new BloomFilter<A>(numHashes, width, hash);
    }

    public <A> Option<Tuple2<Object, Object>> unapply(BloomFilter<A> x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2.mcII.sp(x$0.numHashes(), x$0.width()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BloomFilter$.class);
    }

    private static final double s$1(int n, int width$1, int numHashes$1) {
        return (double)width$1 * (1.0 - package$.MODULE$.pow(1.0 - 1.0 / (double)width$1, (double)(numHashes$1 * n)));
    }

    private static final double sInverse$1(int t, int width$1, int numHashes$1) {
        return package$.MODULE$.log1p(-((double)t) / (double)width$1) / ((double)numHashes$1 * package$.MODULE$.log1p(-1.0 / (double)width$1));
    }

    private BloomFilter$() {
    }
}

