/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird;

import com.twitter.algebird.CMSHash;
import com.twitter.algebird.CMSHasher;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

public final class CMSFunctions$ {
    public static final CMSFunctions$ MODULE$ = new CMSFunctions$();

    public double eps(int width) {
        return package$.MODULE$.exp(1.0) / (double)width;
    }

    /*
     * WARNING - void declaration
     */
    public double delta(int depth) throws IllegalArgumentException {
        void var2_2;
        double i = package$.MODULE$.exp((double)(-depth));
        Predef$.MODULE$.require(i > 0.0, (Function0 & Serializable)() -> new StringBuilder(103).append("depth must be smaller as it causes precision errors when computing delta (").append(depth).append(" led to an invalid delta of ").append(i).append(")").toString());
        return (double)var2_2;
    }

    public int depth(double delta) throws IllegalArgumentException {
        Predef$.MODULE$.require(0.0 < delta && delta < 1.0, (Function0 & Serializable)() -> "delta must lie in (0, 1)");
        return (int)package$.MODULE$.ceil(package$.MODULE$.log(1.0 / delta));
    }

    public int width(double eps) {
        return (int)package$.MODULE$.ceil(this.truncatePrecisionError(package$.MODULE$.exp(1.0) / eps, 6));
    }

    public int maxExactCount(Option<Object> maxExactCountOpt, int depth, int width) {
        return BoxesRunTime.unboxToInt((Object)maxExactCountOpt.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> package$.MODULE$.max(width * depth / 100, 50)));
    }

    private double truncatePrecisionError(double i, int decimalPlaces) {
        return scala.package$.MODULE$.BigDecimal().apply(i).setScale(decimalPlaces, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toDouble();
    }

    private int truncatePrecisionError$default$2() {
        return 6;
    }

    public <K> Seq<CMSHash<K>> generateHashes(double eps, double delta, int seed, CMSHasher<K> evidence$2) {
        Random r = new Random(seed);
        int numHashes = this.depth(delta);
        int numCounters = this.width(eps);
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), numHashes - 1).map((Function1 & Serializable)x$1 -> CMSFunctions$.$anonfun$generateHashes$1(r, numCounters, evidence$2, BoxesRunTime.unboxToInt((Object)x$1)));
    }

    public static final /* synthetic */ CMSHash $anonfun$generateHashes$1(Random r$1, int numCounters$1, CMSHasher evidence$2$1, int x$1) {
        return new CMSHash(r$1.nextInt(), 0, numCounters$1, evidence$2$1);
    }

    private CMSFunctions$() {
    }
}

