/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.algebird;

import com.googlecode.javaewah.IntIterator;
import com.twitter.algebird.Approximate;
import com.twitter.algebird.ApproximateBoolean;
import com.twitter.algebird.ApproximateBoolean$;
import com.twitter.algebird.BF$;
import com.twitter.algebird.BFHash;
import com.twitter.algebird.BFInstance;
import com.twitter.algebird.BFItem;
import com.twitter.algebird.BFSparse;
import com.twitter.algebird.BFZero;
import java.io.Serializable;
import java.util.Arrays;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.BitSet;
import scala.math.Equiv;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u0005mr!B\n\u0015\u0011\u0003Yb!B\u000f\u0015\u0011\u0003q\u0002\"B\u0017\u0002\t\u0003q\u0003\"B\u0018\u0002\t\u0007\u0001\u0004\"CA\u0016\u0003\u0005\u0005I\u0011BA\u0017\r\u0015iB#!\t@\u0011\u0015iS\u0001\"\u0001B\u0011\u0015qUA\"\u0001P\u0011\u0015\u0019VA\"\u0001P\u0011\u0015!VA\"\u0001P\u0011\u0015)V\u0001\"\u0001W\u0011\u0015QVA\"\u0001\\\u0011\u0015qVA\"\u0001`\u0011\u0015\tWA\"\u0001c\u0011\u0015YW\u0001\"\u0001m\u0011\u0015qWA\"\u0001p\u0011\u0015!XA\"\u0001v\u0011\u0015aXA\"\u0001~\u0011\u001d\ti!\u0002C\u0001\u0003\u001f\t!A\u0011$\u000b\u0005U1\u0012\u0001C1mO\u0016\u0014\u0017N\u001d3\u000b\u0005]A\u0012a\u0002;xSR$XM\u001d\u0006\u00023\u0005\u00191m\\7\u0004\u0001A\u0011A$A\u0007\u0002)\t\u0011!IR\n\u0004\u0003})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'W5\tqE\u0003\u0002)S\u0005\u0011\u0011n\u001c\u0006\u0002U\u0005!!.\u0019<b\u0013\tasE\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u00027\u0005)Q-];jmV\u0019\u0011'!\u000b\u0016\u0003I\u00022aM\u001e?\u001d\t!\u0014H\u0004\u00026q5\taG\u0003\u000285\u00051AH]8pizJ\u0011AI\u0005\u0003u\u0005\nq\u0001]1dW\u0006<W-\u0003\u0002={\t)Q)];jm*\u0011!(\t\t\u00059\u0015\t9#\u0006\u0002A\u000bN\u0019QaH\u0013\u0015\u0003\t\u00032\u0001H\u0003D!\t!U\t\u0004\u0001\u0005\u000b\u0019+!\u0019A$\u0003\u0003\u0005\u000b\"\u0001S&\u0011\u0005\u0001J\u0015B\u0001&\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\t'\n\u00055\u000b#aA!os\u0006Ia.^7ICNDWm]\u000b\u0002!B\u0011\u0001%U\u0005\u0003%\u0006\u00121!\u00138u\u0003\u00159\u0018\u000e\u001a;i\u0003\u001dqW/\u001c\"jiN\fq\u0001Z3og&$\u00180F\u0001X!\t\u0001\u0003,\u0003\u0002ZC\t1Ai\\;cY\u0016\f!\u0002\n9mkN$\u0003\u000f\\;t)\t\u0011E\fC\u0003^\u0017\u0001\u0007!)A\u0003pi\",'/A\u0003%a2,8\u000f\u0006\u0002CA\")Q\f\u0004a\u0001\u0007\u0006Y1\r[3dW\u0006sG-\u00113e)\t\u0019\u0017\u000e\u0005\u0003!I\n3\u0017BA3\"\u0005\u0019!V\u000f\u001d7feA\u0011AdZ\u0005\u0003QR\u0011!#\u00119qe>D\u0018.\\1uK\n{w\u000e\\3b]\")!.\u0004a\u0001\u0007\u0006!\u0011\u000e^3n\u0003!\u0019wN\u001c;bS:\u001cHC\u00014n\u0011\u0015Qg\u00021\u0001D\u00035i\u0017-\u001f2f\u0007>tG/Y5ogR\u0011\u0001o\u001d\t\u0003AEL!A]\u0011\u0003\u000f\t{w\u000e\\3b]\")!n\u0004a\u0001\u0007\u0006!1/\u001b>f+\u00051\bc\u0001\u000fxs&\u0011\u0001\u0010\u0006\u0002\f\u0003B\u0004(o\u001c=j[\u0006$X\r\u0005\u0002!u&\u001110\t\u0002\u0005\u0019>tw-\u0001\u0005u_\nKGoU3u+\u0005q\bcA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!A\u0005j[6,H/\u00192mK*\u0019\u0011qA\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\f\u0005\u0005!A\u0002\"jiN+G/A\biC6l\u0017N\\4ESN$\u0018M\\2f)\r\u0001\u0016\u0011\u0003\u0005\u0007\u0003'\u0011\u0002\u0019\u0001\"\u0002\tQD\u0017\r^\u0015\n\u000b\u0005]\u00111DA\u0010\u0003GI1!!\u0007\u0015\u0005)\u0011e)\u00138ti\u0006t7-Z\u0005\u0004\u0003;!\"A\u0002\"G\u0013R,W.C\u0002\u0002\"Q\u0011\u0001B\u0011$Ta\u0006\u00148/Z\u0005\u0004\u0003K!\"A\u0002\"G5\u0016\u0014x\u000eE\u0002E\u0003S!QAR\u0002C\u0002\u001d\u000bAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a\f\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e*\u0003\u0011a\u0017M\\4\n\t\u0005e\u00121\u0007\u0002\u0007\u001f\nTWm\u0019;")
public abstract class BF<A>
implements Serializable {
    public static <A> Equiv<BF<A>> equiv() {
        return new Equiv<BF<A>>(){

            public boolean equiv(BF<A> a, BF<A> b) {
                return a == b || a.numHashes() == b.numHashes() && a.width() == b.width() && $anon$1.eqIntIter$1($anon$1.toIntIt$1(a), $anon$1.toIntIt$1(b));
            }

            private static final IntIterator toIntIt$1(BF b) {
                IntIterator intIterator;
                if (b instanceof BFItem) {
                    BFItem bFItem = (BFItem)b;
                    A it = bFItem.item();
                    BFHash<A> hashes = bFItem.hashes();
                    intIterator = new IntIterator(null, hashes, it){
                        private final int[] hashvalues;
                        private final int[] uniqVs;
                        private final int len;
                        private int pos;

                        private int[] hashvalues() {
                            return this.hashvalues;
                        }

                        private int uniq(int[] src, int[] dst, int prev, int spos, int dpos) {
                            while (spos < src.length) {
                                if (spos == 0) {
                                    int first;
                                    dst[0] = first = src[0];
                                    ++dpos;
                                    ++spos;
                                    prev = first;
                                    continue;
                                }
                                int cur = src[spos];
                                if (cur == prev) {
                                    ++spos;
                                    continue;
                                }
                                dst[dpos] = cur;
                                ++dpos;
                                ++spos;
                                prev = cur;
                            }
                            return dpos;
                        }

                        private int[] uniqVs() {
                            return this.uniqVs;
                        }

                        private int len() {
                            return this.len;
                        }

                        private int pos() {
                            return this.pos;
                        }

                        private void pos_$eq(int x$1) {
                            this.pos = x$1;
                        }

                        public boolean hasNext() {
                            return this.pos() < this.len();
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public int next() {
                            void var1_1;
                            int n = this.uniqVs()[this.pos()];
                            this.pos_$eq(this.pos() + 1);
                            return (int)var1_1;
                        }
                        {
                            this.hashvalues = hashes$1.apply(it$1);
                            Arrays.sort(this.hashvalues());
                            this.uniqVs = new int[this.hashvalues().length];
                            this.len = this.uniq(this.hashvalues(), this.uniqVs(), -1, 0, 0);
                            this.pos = 0;
                        }
                    };
                } else if (b instanceof BFSparse) {
                    intIterator = ((BFSparse)b).bits().intIterator();
                } else if (b instanceof BFInstance) {
                    BitSet bitset = ((BFInstance)b).bits();
                    intIterator = new IntIterator(null, bitset){
                        private final Iterator<Object> boxedIter;

                        private Iterator<Object> boxedIter() {
                            return this.boxedIter;
                        }

                        public boolean hasNext() {
                            return this.boxedIter().hasNext();
                        }

                        public int next() {
                            return BoxesRunTime.unboxToInt((Object)this.boxedIter().next());
                        }
                        {
                            this.boxedIter = bitset$1.iterator();
                        }
                    };
                } else if (b instanceof BFZero) {
                    intIterator = new IntIterator(null){

                        public boolean hasNext() {
                            return false;
                        }

                        public Nothing$ next() {
                            return scala.sys.package$.MODULE$.error("BFZero has no hashes set");
                        }
                    };
                } else {
                    throw new MatchError((Object)b);
                }
                return intIterator;
            }

            private static final boolean eqIntIter$1(IntIterator a, IntIterator b) {
                while (a.hasNext() && b.hasNext()) {
                    if (a.next() == b.next()) continue;
                    return false;
                }
                return a.hasNext() == b.hasNext();
            }
        };
    }

    public abstract int numHashes();

    public abstract int width();

    public abstract int numBits();

    public double density() {
        return (double)this.numBits() / (double)this.width();
    }

    public abstract BF<A> $plus$plus(BF<A> var1);

    public abstract BF<A> $plus(A var1);

    public abstract Tuple2<BF<A>, ApproximateBoolean> checkAndAdd(A var1);

    public ApproximateBoolean contains(A item) {
        if (this.maybeContains(item)) {
            double fpProb = this.density() > 0.95 ? 1.0 : package$.MODULE$.pow(1.0 - package$.MODULE$.exp((double)((long)(-this.numHashes()) * BoxesRunTime.unboxToLong((Object)this.size().estimate())) * 1.1 / (double)this.width()), (double)this.numHashes());
            return new ApproximateBoolean(true, 1.0 - fpProb);
        }
        return ApproximateBoolean$.MODULE$.exactFalse();
    }

    public abstract boolean maybeContains(A var1);

    public abstract Approximate<Object> size();

    public abstract BitSet toBitSet();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hammingDistance(BF<A> that) {
        if (this instanceof BFZero && that instanceof BFZero) {
            return 0;
        }
        if (this instanceof BFZero && that != null) {
            return that.numBits();
        }
        if (that instanceof BFZero) {
            return this.numBits();
        }
        if (!(this instanceof BFSparse)) return this.toBitSet().$up((scala.collection.BitSet)that.toBitSet()).size();
        BFSparse bFSparse = (BFSparse)this;
        if (!(that instanceof BFSparse)) return this.toBitSet().$up((scala.collection.BitSet)that.toBitSet()).size();
        BFSparse bFSparse2 = (BFSparse)that;
        return bFSparse.bits().xorCardinality(bFSparse2.bits());
    }
}

