/*
 * Decompiled with CFR 0.152.
 */
package zio.config.typesafe;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import zio.CanFail$;
import zio.Task$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZManaged$;
import zio.config.ConfigSourceModule;
import zio.config.PropertyTree;
import zio.config.PropertyTree$;
import zio.config.ReadError;
import zio.config.package$;

public final class TypesafeConfigSource$ {
    public static final TypesafeConfigSource$ MODULE$ = new TypesafeConfigSource$();

    public ConfigSourceModule.ConfigSource fromResourcePath() {
        return this.fromTypesafeConfig((ZIO<Object, Throwable, Config>)ZIO$.MODULE$.effect((Function0 & Serializable)() -> ConfigFactory.load().resolve()));
    }

    public <A> ConfigSourceModule.ConfigSource fromHoconFile(File file) {
        ZIO rawConfig = Task$.MODULE$.effect((Function0 & Serializable)() -> ConfigFactory.parseFile((File)file).resolve());
        return this.fromTypesafeConfig((ZIO<Object, Throwable, Config>)rawConfig);
    }

    public <A> ConfigSourceModule.ConfigSource fromHoconFilePath(String filePath) {
        return this.fromHoconFile(new File(filePath));
    }

    public ConfigSourceModule.ConfigSource fromHoconString(String input) {
        return this.fromTypesafeConfig((ZIO<Object, Throwable, Config>)ZIO$.MODULE$.effect((Function0 & Serializable)() -> ConfigFactory.parseString((String)input).resolve()));
    }

    public ConfigSourceModule.ConfigSource fromTypesafeConfig(ZIO<Object, Throwable, Config> rawConfig) {
        ZIO readerZIO = rawConfig.flatMap((Function1 & Serializable)value -> {
            ZIO zIO;
            Either<String, PropertyTree<String, String>> either = MODULE$.getPropertyTree((Config)value);
            if (either instanceof Left) {
                String error = (String)((Left)either).value();
                zIO = ZIO$.MODULE$.fail((Function0 & Serializable)() -> new ReadError.SourceError(error, ReadError.SourceError$.MODULE$.apply$default$2()));
            } else if (either instanceof Right) {
                PropertyTree tree = (PropertyTree)((Right)either).value();
                zIO = ZIO$.MODULE$.succeed((Function0 & Serializable)() -> (Function1 & Serializable)path -> ZIO$.MODULE$.succeed((Function0 & Serializable)() -> tree.at(path)));
            } else {
                throw new MatchError(either);
            }
            return zIO;
        }).mapError((Function1 & Serializable)exception -> new ReadError.SourceError(exception.getMessage(), ReadError.SourceError$.MODULE$.apply$default$2()), CanFail$.MODULE$.canFail());
        return package$.MODULE$.ConfigSource().fromManaged("hocon", ZManaged$.MODULE$.fromEffect(readerZIO)).memoize();
    }

    public Either<String, PropertyTree<String, String>> getPropertyTree(Config input) {
        Right right;
        Function1 & Serializable strictLeaf = (Function1 & Serializable)x$1 -> new PropertyTree.Leaf(x$1, false);
        PropertyTree loopNull = PropertyTree$.MODULE$.empty();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> TypesafeConfigSource$.loopConfig$1(input.root(), loopNull, strictLeaf));
        if (try_ instanceof Failure) {
            Throwable t = ((Failure)try_).exception();
            right = scala.package$.MODULE$.Left().apply((Object)new StringBuilder(138).append("Unable to form the zio.config.PropertyTree from Hocon string. This may be due to the presence of explicit usage of nulls in hocon string. ").append(t.getMessage()).toString());
        } else if (try_ instanceof Success) {
            PropertyTree.Record value = (PropertyTree.Record)((Success)try_).value();
            right = scala.package$.MODULE$.Right().apply((Object)value);
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    public ConfigObject fromPropertyTree(PropertyTree<String, String> tree) {
        return this.loopAny(tree, (Option<String>)None$.MODULE$);
    }

    private ConfigObject loopAny(PropertyTree<String, String> tree, Option<String> key) {
        ConfigObject configObject;
        if (tree instanceof PropertyTree.Leaf) {
            PropertyTree.Leaf leaf = (PropertyTree.Leaf)tree;
            configObject = this.loopLeaf(key, (PropertyTree.Leaf<String>)leaf);
        } else if (tree instanceof PropertyTree.Record) {
            PropertyTree.Record record = (PropertyTree.Record)tree;
            configObject = this.loopRecord(key, (PropertyTree.Record<String, String>)record);
        } else if (PropertyTree.Empty$.MODULE$.equals(tree)) {
            configObject = this.loopEmpty(key);
        } else if (tree instanceof PropertyTree.Sequence) {
            PropertyTree.Sequence sequence = (PropertyTree.Sequence)tree;
            configObject = this.loopSequence(key, (PropertyTree.Sequence<String, String>)sequence);
        } else {
            throw new MatchError(tree);
        }
        return configObject;
    }

    private ConfigObject loopEmpty(Option<String> key) {
        return (ConfigObject)key.fold((Function0 & Serializable)() -> ConfigFactory.empty().root(), (Function1 & Serializable)k -> ConfigFactory.empty().withValue(k, ConfigValueFactory.fromAnyRef(null)).root());
    }

    private ConfigObject loopLeaf(Option<String> key, PropertyTree.Leaf<String> tree) {
        return ((Config)key.fold((Function0 & Serializable)() -> ConfigFactory.empty(), (Function1 & Serializable)last -> ConfigFactory.empty().withValue(new StringBuilder(4).append(" \"").append((String)last).append("\" ").toString(), ConfigValueFactory.fromAnyRef((Object)tree.value())))).root();
    }

    private ConfigObject loopRecord(Option<String> key2, PropertyTree.Record<String, String> tree) {
        ConfigObject inner = (ConfigObject)tree.value().toList().foldLeft((Object)ConfigFactory.empty().root(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (x1$1 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)x1$1._1();
            PropertyTree tree = (PropertyTree)x1$1._2();
            ConfigObject newObject = MODULE$.loopAny((PropertyTree<String, String>)tree, (Option<String>)new Some((Object)k));
            ConfigObject configObject = x0$1.withValue(k, (ConfigValue)newObject.getOrDefault((Object)k, (Object)newObject));
            return configObject;
        });
        return (ConfigObject)key2.fold((Function0 & Serializable)() -> inner, (Function1 & Serializable)key -> inner.atKey(key).root());
    }

    private ConfigObject loopSequence(Option<String> key, PropertyTree.Sequence<String, String> tree) {
        ConfigObject configObject;
        if (key instanceof Some) {
            String key2 = (String)((Some)key).value();
            List leaves = this.partitionWith((List)tree.value(), (PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends PropertyTree<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    if (x1 instanceof PropertyTree.Leaf) {
                        PropertyTree.Leaf leaf = (PropertyTree.Leaf)x1;
                        String value = (String)leaf.value();
                        boolean bool = leaf.canBeSequence();
                        object = new PropertyTree.Leaf((Object)value, bool);
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(PropertyTree<String, String> x1) {
                    boolean bl = x1 instanceof PropertyTree.Leaf;
                    return bl;
                }
            });
            configObject = leaves.nonEmpty() ? ConfigFactory.empty().withValue(key2, (ConfigValue)ConfigValueFactory.fromIterable((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaves.map((Function1 & Serializable)x$2 -> (String)x$2.value())).asJava())).root() : ConfigFactory.empty().withValue(key2, (ConfigValue)ConfigValueFactory.fromIterable((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)tree.value().map((Function1 & Serializable)t -> {
                ConfigObject newObj = MODULE$.loopAny((PropertyTree<String, String>)t, (Option<String>)new Some((Object)key2));
                return (ConfigValue)newObj.getOrDefault((Object)key2, (Object)newObj);
            })).asJava())).root();
        } else if (None$.MODULE$.equals(key)) {
            configObject = ConfigFactory.empty().root();
        } else {
            throw new MatchError(key);
        }
        return configObject;
    }

    public <K, V, A> List<A> partitionWith(List<PropertyTree<K, V>> trees, PartialFunction<PropertyTree<K, V>, A> pf) {
        return (List)trees.map((Function1 & Serializable)x0$1 -> {
            Nil$ nil$;
            if (pf.isDefinedAt(x0$1)) {
                Object object = pf.apply(x0$1);
                nil$ = Nil$.MODULE$.$colon$colon(object);
            } else {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }).foldLeft((Object)scala.package$.MODULE$.List().empty(), (Function2 & Serializable)(x0$2, x1$1) -> (List)x0$2.$plus$plus((IterableOnce)x1$1));
    }

    private static final PropertyTree.Leaf loopBoolean$1(boolean value, Function1 strictLeaf$1) {
        return (PropertyTree.Leaf)strictLeaf$1.apply((Object)Boolean.toString(value));
    }

    private static final PropertyTree.Leaf loopNumber$1(Number value, Function1 strictLeaf$1) {
        return (PropertyTree.Leaf)strictLeaf$1.apply((Object)value.toString());
    }

    private static final PropertyTree.Leaf loopString$1(String value, Function1 strictLeaf$1) {
        return (PropertyTree.Leaf)strictLeaf$1.apply((Object)value);
    }

    private static final PropertyTree.Sequence loopList$1(List values, PropertyTree loopNull$1, Function1 strictLeaf$1) {
        return new PropertyTree.Sequence(values.map((Function1 & Serializable)value -> TypesafeConfigSource$.loopAny$1(value, loopNull$1, strictLeaf$1)));
    }

    private static final PropertyTree.Record loopConfig$1(ConfigObject config, PropertyTree loopNull$1, Function1 strictLeaf$1) {
        return new PropertyTree.Record(((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala((Map)config).asScala().toVector().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            ConfigValue value = (ConfigValue)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)TypesafeConfigSource$.loopAny$1(value, loopNull$1, strictLeaf$1));
            return tuple2;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private static final PropertyTree loopAny$1(ConfigValue value, PropertyTree loopNull$1, Function1 strictLeaf$1) {
        PropertyTree.Record record;
        ConfigValueType configValueType = value.valueType();
        if (ConfigValueType.OBJECT.equals(configValueType)) {
            record = TypesafeConfigSource$.loopConfig$1((ConfigObject)value, loopNull$1, strictLeaf$1);
        } else if (ConfigValueType.LIST.equals(configValueType)) {
            record = TypesafeConfigSource$.loopList$1(CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)((ConfigList)value)).asScala().toList(), loopNull$1, strictLeaf$1);
        } else if (ConfigValueType.BOOLEAN.equals(configValueType)) {
            record = TypesafeConfigSource$.loopBoolean$1(Predef$.MODULE$.Boolean2boolean((Boolean)value.unwrapped()), strictLeaf$1);
        } else if (ConfigValueType.NUMBER.equals(configValueType)) {
            record = TypesafeConfigSource$.loopNumber$1((Number)value.unwrapped(), strictLeaf$1);
        } else if (ConfigValueType.NULL.equals(configValueType)) {
            record = loopNull$1;
        } else if (ConfigValueType.STRING.equals(configValueType)) {
            record = TypesafeConfigSource$.loopString$1((String)value.unwrapped(), strictLeaf$1);
        } else {
            throw new MatchError((Object)configValueType);
        }
        return record;
    }

    private TypesafeConfigSource$() {
    }
}

