/*
 * Decompiled with CFR 0.152.
 */
package org.slieb.throwables;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slieb.throwables.SuppressedException;

@FunctionalInterface
public interface RunnableWithThrowable<E extends Throwable>
extends Runnable {
    public static <E extends Throwable> RunnableWithThrowable<E> castRunnableWithThrowable(RunnableWithThrowable<E> runnablewiththrowable) {
        return runnablewiththrowable;
    }

    public static <E extends Throwable> Runnable aRunnableThatUnsafelyThrowsUnchecked(RunnableWithThrowable<E> runnablewiththrowable) throws E {
        return runnablewiththrowable.thatUnsafelyThrowsUnchecked();
    }

    public static <E extends Throwable> RunnableWithThrowable<E> asRunnableWithThrowable(Runnable runnable) {
        return runnable::run;
    }

    @Override
    default public void run() {
        try {
            this.runWithThrowable();
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new SuppressedException(throwable);
        }
    }

    public void runWithThrowable() throws E;

    default public Runnable thatThrowsNothing() {
        return () -> {
            try {
                this.runWithThrowable();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    default public Runnable thatUnsafelyThrowsUnchecked() throws E {
        return () -> {
            try {
                this.runWithThrowable();
            }
            catch (Throwable throwable) {
                SuppressedException.throwUnsafelyAsUnchecked(throwable);
            }
        };
    }

    default public RunnableWithThrowable<E> withLogging(Logger logger, String message) {
        return () -> {
            try {
                this.runWithThrowable();
            }
            catch (Throwable throwable) {
                logger.error(message, throwable);
                throw throwable;
            }
        };
    }

    default public RunnableWithThrowable<E> withLogging(Logger logger) {
        return this.withLogging(logger, "Exception in RunnableWithThrowable");
    }

    default public RunnableWithThrowable<E> withLogging() {
        return this.withLogging(LoggerFactory.getLogger(this.getClass()));
    }

    default public RunnableWithThrowable<E> onException(Consumer<Throwable> consumer) {
        return () -> {
            try {
                this.runWithThrowable();
            }
            catch (Throwable throwable) {
                consumer.accept(throwable);
                throw throwable;
            }
        };
    }
}

