/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.jumpstart.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JumpstartAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(JumpstartAgent.class);
    private static final Duration ALIVE_WINDOW = Duration.ofSeconds(30L);
    private static final String STOP_SIGNAL = "STOP";
    private static final String KEEP_ALIVE_SIGNAL = "KEEP_ALIVE";

    public static void premain(String string, Instrumentation instrumentation) {
        new Thread(() -> {
            try {
                Props props = JumpstartAgent.parseArg(string);
                JumpstartAgent.startTcpServer(props);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }).start();
    }

    private static Props parseArg(String string) {
        List list = Arrays.stream(string.trim().split(",")).collect(Collectors.toList());
        Component component = null;
        int n = -1;
        for (String string2 : list) {
            String[] stringArray = string2.split("=");
            String string3 = stringArray[0].trim();
            String string4 = stringArray[1].trim();
            if (string3.equalsIgnoreCase("component")) {
                if (string4.equalsIgnoreCase("kafka")) {
                    component = Component.KAFKA;
                    continue;
                }
                if (string4.equalsIgnoreCase("zookeeper")) {
                    component = Component.ZOOKEEPER;
                    continue;
                }
                if (!string4.equalsIgnoreCase("registry")) continue;
                component = Component.REGISTRY;
                continue;
            }
            if (!string3.equalsIgnoreCase("port")) continue;
            n = Integer.parseInt(string4);
        }
        if (component != null && n != -1) {
            return new Props(component, n);
        }
        throw new IllegalArgumentException(string);
    }

    private static ServerSocket createServerSocket(Props props) throws IOException {
        InetAddress inetAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        return new ServerSocket(props.port, 0, inetAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startTcpServer(Props props) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        try {
            try {
                ServerSocket serverSocket = JumpstartAgent.createServerSocket(props);
                try {
                    LOGGER.info("Server is listening on port " + props.port + ".");
                    new TickChecker(JumpstartAgent.ALIVE_WINDOW, () -> JumpstartAgent.exitApp(props), atomicBoolean).start();
                    while (true) {
                        Socket socket = serverSocket.accept();
                        executorService.execute(() -> JumpstartAgent.receiveKeepAlive(atomicBoolean, socket));
                    }
                }
                catch (Throwable throwable) {
                    if (serverSocket != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                LOGGER.error("Agent exit unexpectedly.");
                JumpstartAgent.exitApp(props);
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("Agent exit unexpectedly.");
            JumpstartAgent.exitApp(props);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void receiveKeepAlive(AtomicBoolean atomicBoolean, Socket socket) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.equalsIgnoreCase(KEEP_ALIVE_SIGNAL)) {
                    LOGGER.info("Keep alive signal receive.");
                    atomicBoolean.set(true);
                    continue;
                }
                if (!string.equalsIgnoreCase(STOP_SIGNAL)) continue;
                LOGGER.info("Stop signal receive.");
                JumpstartAgent.forceExitApp();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void forceExitApp() {
        System.exit(0);
    }

    private static void exitApp(Props props) {
        try {
            if (props.component.equals((Object)Component.ZOOKEEPER)) {
                Thread.sleep(ALIVE_WINDOW.toMillis());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            LOGGER.info("Keep alive have expired, agent is going to shutdown.");
            System.exit(1);
        }
    }

    public static enum Component {
        KAFKA,
        ZOOKEEPER,
        REGISTRY;

    }

    public static class Props {
        public final Component component;
        public final int port;

        public Props(Component component, int n) {
            this.component = component;
            this.port = n;
        }
    }

    private static class TickChecker {
        private static final Duration tick = Duration.ofSeconds(1L);
        private final Stop stop;
        private final int nbTickBeforeFailure;
        private final AtomicInteger failureCount;
        private final ScheduledThreadPoolExecutor scheduledExecutor;
        private final AtomicBoolean keepAliveReceived;

        private TickChecker(Duration duration, Stop stop, AtomicBoolean atomicBoolean) {
            this.keepAliveReceived = atomicBoolean;
            this.scheduledExecutor = new ScheduledThreadPoolExecutor(1);
            this.failureCount = new AtomicInteger(0);
            this.nbTickBeforeFailure = Math.toIntExact(duration.dividedBy(tick));
            this.stop = stop;
        }

        private void start() {
            Duration duration = Duration.ZERO;
            this.scheduledExecutor.scheduleAtFixedRate(this::checkTick, duration.toMillis(), tick.toMillis(), TimeUnit.MILLISECONDS);
        }

        private void checkTick() {
            try {
                boolean bl = this.keepAliveReceived.getAndSet(false);
                if (!bl) {
                    int n = this.failureCount.incrementAndGet();
                    if (n > this.nbTickBeforeFailure) {
                        this.stop.stop();
                    }
                } else {
                    this.failureCount.set(0);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static interface Stop {
        public void stop();
    }
}

