/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.auth.http;

import com.github.kittinunf.fuel.FuelKt;
import com.github.kittinunf.fuel.core.Request;
import com.github.kittinunf.fuel.json.FuelJson;
import com.github.kittinunf.fuel.json.FuelJsonKt;
import com.github.kittinunf.result.Result;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import com.sun.net.httpserver.HttpExchange;
import io.conduktor.auth.AuthException;
import io.conduktor.auth.http.HttpHelperKt;
import io.conduktor.auth.http.LocalAuthHttpServer;
import io.conduktor.auth.http.OIDCClient;
import io.conduktor.auth.http.OIDCConfiguration;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ,\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J\u001a\u0010#\u001a\u00020\f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00070\u0005J'\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%*\u00020\u001e2\u0006\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010)J\u001c\u0010*\u001a\u00020+*\u00020 2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/conduktor/auth/http/OIDCClient;", "", "config", "Lio/conduktor/auth/http/OIDCConfiguration;", "errorTracker", "Lkotlin/Function1;", "", "", "(Lio/conduktor/auth/http/OIDCConfiguration;Lkotlin/jvm/functions/Function1;)V", "clientId", "Lcom/nimbusds/oauth2/sdk/id/ClientID;", "failedHtmlTemplate", "", "httpServer", "Lio/conduktor/auth/http/LocalAuthHttpServer;", "getHttpServer", "()Lio/conduktor/auth/http/LocalAuthHttpServer;", "httpServer$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "requests", "", "Lkotlin/Pair;", "Lcom/nimbusds/openid/connect/sdk/AuthenticationRequest;", "Lcom/nimbusds/oauth2/sdk/pkce/CodeVerifier;", "successHtmlTemplate", "handleRedirect", "http", "Lcom/sun/net/httpserver/HttpExchange;", "provider", "Lcom/nimbusds/openid/connect/sdk/op/OIDCProviderMetadata;", "onLoginSuccess", "Lcom/nimbusds/openid/connect/sdk/OIDCTokenResponse;", "loginUrl", "sendErrorAndThrow", "T", "logMessage", "errorObject", "Lcom/nimbusds/oauth2/sdk/ErrorObject;", "(Lcom/sun/net/httpserver/HttpExchange;Ljava/lang/String;Lcom/nimbusds/oauth2/sdk/ErrorObject;)Ljava/lang/Object;", "verifyIdToken", "Lcom/nimbusds/openid/connect/sdk/claims/IDTokenClaimsSet;", "idToken", "Lcom/nimbusds/jwt/JWT;", "nonce", "Lcom/nimbusds/openid/connect/sdk/Nonce;", "auth"})
public final class OIDCClient {
    @NotNull
    private final OIDCConfiguration config;
    @NotNull
    private final Function1<Throwable, Unit> errorTracker;
    @NotNull
    private final ClientID clientId;
    @NotNull
    private final String successHtmlTemplate;
    @NotNull
    private final String failedHtmlTemplate;
    @NotNull
    private final Lazy httpServer$delegate;
    @NotNull
    private final Map<String, Pair<AuthenticationRequest, CodeVerifier>> requests;
    private final Logger logger;

    public OIDCClient(@NotNull OIDCConfiguration config, @NotNull Function1<? super Throwable, Unit> errorTracker) {
        this.config = config;
        this.errorTracker = errorTracker;
        this.clientId = new ClientID(this.config.getClientId());
        URL uRL = this.getClass().getResource(this.config.getLoginSuccessTemplate());
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        this.successHtmlTemplate = StringsKt.replace$default((String)new String(byArray, charset), (String)"{success-url}", (String)this.config.getLoginSuccessUrl(), (boolean)false, (int)4, null);
        uRL = this.getClass().getResource(this.config.getLoginFailedTemplate());
        charset = Charsets.UTF_8;
        byArray = TextStreamsKt.readBytes((URL)uRL);
        this.failedHtmlTemplate = StringsKt.replace$default((String)new String(byArray, charset), (String)"{failure-url}", (String)this.config.getLoginFailedUrl(), (boolean)false, (int)4, null);
        this.httpServer$delegate = LazyKt.lazy((Function0)httpServer.2.INSTANCE);
        this.requests = new LinkedHashMap();
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    private final LocalAuthHttpServer getHttpServer() {
        Lazy lazy = this.httpServer$delegate;
        return (LocalAuthHttpServer)lazy.getValue();
    }

    @NotNull
    public final String loginUrl(@NotNull Function1<? super OIDCTokenResponse, Unit> onLoginSuccess) {
        Result providerInfoResponse = (Result)FuelJsonKt.responseJson((Request)FuelKt.httpGet$default((String)(this.config.getIssuer() + this.config.getWellKnownPath()), null, (int)1, null)).component3();
        OIDCProviderMetadata provider = OIDCProviderMetadata.parse((String)((FuelJson)providerInfoResponse.get()).getContent());
        int port2 = this.getHttpServer().startHttpServerIfNotUpYet((Function2<? super HttpExchange, ? super Integer, Unit>)((Function2)new Function2<HttpExchange, Integer, Unit>(this, provider, onLoginSuccess){
            final /* synthetic */ OIDCClient this$0;
            final /* synthetic */ OIDCProviderMetadata $provider;
            final /* synthetic */ Function1<OIDCTokenResponse, Unit> $onLoginSuccess;
            {
                this.this$0 = $receiver;
                this.$provider = $provider;
                this.$onLoginSuccess = $onLoginSuccess;
                super(2);
            }

            public final void invoke(@NotNull HttpExchange http, int n) {
                OIDCClient.access$handleRedirect(this.this$0, http, this.$provider, this.$onLoginSuccess);
            }
        }));
        State state = new State();
        CodeVerifier codeVerifier = new CodeVerifier();
        Nonce nonce = new Nonce();
        String[] stringArray = new String[]{"openid"};
        Scope scope = new Scope(stringArray);
        AuthenticationRequest request = new AuthenticationRequest.Builder(ResponseType.CODE, scope, this.clientId, new URI(StringsKt.replace$default((String)this.config.getRedirectUrl(), (String)"{PORT}", (String)String.valueOf(port2), (boolean)false, (int)4, null))).endpointURI(provider.getAuthorizationEndpointURI()).codeChallenge(codeVerifier, CodeChallengeMethod.S256).state(state).nonce(nonce).build();
        this.requests.put(state.getValue(), (Pair<AuthenticationRequest, CodeVerifier>)TuplesKt.to((Object)request, (Object)codeVerifier));
        return request.toURI().toString();
    }

    private final void handleRedirect(HttpExchange http, OIDCProviderMetadata provider, Function1<? super OIDCTokenResponse, Unit> onLoginSuccess) {
        AuthenticationResponse response = AuthenticationResponseParser.parse((URI)http.getRequestURI());
        if (response instanceof AuthenticationErrorResponse) {
            this.sendErrorAndThrow(http, "Authentication Error: {}", ((AuthenticationErrorResponse)response).getErrorObject());
        }
        AuthenticationResponse authenticationResponse = response;
        if (authenticationResponse == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse");
        }
        State state = ((AuthenticationSuccessResponse)authenticationResponse).getState();
        Pair pair = this.requests.remove(state.getValue());
        if (pair == null) {
            pair = (Pair)this.sendErrorAndThrow(http, "Error getting the OAuth2 tokens: {}", new ErrorObject("invalid-state"));
        }
        Pair pair2 = pair;
        AuthenticationRequest authRequest = (AuthenticationRequest)pair2.component1();
        CodeVerifier codeVerifier = (CodeVerifier)pair2.component2();
        AuthorizationCode code = ((AuthenticationSuccessResponse)response).getAuthorizationCode();
        TokenRequest tokenRequest = new TokenRequest(provider.getTokenEndpointURI(), this.clientId, (AuthorizationGrant)new AuthorizationCodeGrant(code, authRequest.getRedirectionURI(), codeVerifier));
        TokenResponse tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)tokenRequest.toHTTPRequest().send());
        if (tokenResponse instanceof TokenErrorResponse) {
            this.sendErrorAndThrow(http, "Error getting the OAuth2 tokens: {}", ((TokenErrorResponse)tokenResponse).getErrorObject());
        }
        try {
            TokenResponse tokenResponse2 = tokenResponse;
            if (tokenResponse2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.nimbusds.openid.connect.sdk.OIDCTokenResponse");
            }
            this.verifyIdToken(provider, ((OIDCTokenResponse)tokenResponse2).getOIDCTokens().getIDToken(), authRequest.getNonce());
        }
        catch (JOSEException e) {
            this.sendErrorAndThrow(http, "Invalid Id Token: {}", new ErrorObject("invalid-id-token", e.getMessage()));
        }
        HttpHelperKt.sendResponse(http, 200, this.successHtmlTemplate);
        if (this.requests.isEmpty()) {
            this.getHttpServer().close();
        }
        TokenResponse tokenResponse3 = tokenResponse;
        if (tokenResponse3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.nimbusds.openid.connect.sdk.OIDCTokenResponse");
        }
        onLoginSuccess.invoke((Object)((OIDCTokenResponse)tokenResponse3));
    }

    private final IDTokenClaimsSet verifyIdToken(OIDCProviderMetadata $this$verifyIdToken, JWT idToken, Nonce nonce) {
        IDTokenValidator validator = new IDTokenValidator($this$verifyIdToken.getIssuer(), this.clientId, JWSAlgorithm.RS256, $this$verifyIdToken.getJWKSetURI().toURL());
        return validator.validate(idToken, nonce);
    }

    private final <T> T sendErrorAndThrow(HttpExchange $this$sendErrorAndThrow, String logMessage, ErrorObject errorObject) {
        this.logger.warn(logMessage, (Object)errorObject);
        HttpHelperKt.sendResponse($this$sendErrorAndThrow, 500, StringsKt.replace$default((String)this.failedHtmlTemplate, (String)"{error}", (String)(errorObject.getCode() + "-" + errorObject.getDescription()), (boolean)false, (int)4, null));
        if (this.requests.isEmpty()) {
            this.getHttpServer().close();
        }
        AuthException exception = new AuthException(errorObject.getDescription());
        this.errorTracker.invoke((Object)exception);
        throw exception;
    }

    public static final /* synthetic */ void access$handleRedirect(OIDCClient $this, HttpExchange http, OIDCProviderMetadata provider, Function1 onLoginSuccess) {
        $this.handleRedirect(http, provider, (Function1<? super OIDCTokenResponse, Unit>)onLoginSuccess);
    }
}

